untrusted comment: signature from openbsd 6.2 base secret key
RWRVWzAMgtyg7iwDDKzr8jqGQilhX2Jb/xXpH/XOwX31dwge3F31LAXborc7cF/t+DJnU9R2a4+D6uz9r484QxtYMHm8qKoRzQc=

OpenBSD 6.2 errata 021, August 4, 2018:

Incorrect initialization of the FPU caused floating point exceptions
when running on Xen.

Apply by doing:
    signify -Vep /etc/signify/openbsd-62-base.pub -x 021_fpuinit.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/arch/amd64/amd64/cpu.c
===================================================================
RCS file: /cvs/src/sys/arch/amd64/amd64/cpu.c,v
retrieving revision 1.107.2.2
diff -u -p -r1.107.2.2 cpu.c
--- sys/arch/amd64/amd64/cpu.c	22 Jun 2018 13:05:33 -0000	1.107.2.2
+++ sys/arch/amd64/amd64/cpu.c	2 Aug 2018 23:14:56 -0000
@@ -568,6 +568,9 @@ cpu_init(struct cpu_info *ci)
 	/* Give proc0 a clean FPU save area */
 	sfp = &proc0.p_addr->u_pcb.pcb_savefpu;
 	memset(sfp, 0, fpu_save_len);
+	sfp->fp_fxsave.fx_fcw = __INITIAL_NPXCW__;
+	sfp->fp_fxsave.fx_mxcsr = __INITIAL_MXCSR__;
+	fpureset();
 	if (xsave_mask) {
 		/* must not use xsaveopt here */
 		xsave(sfp, xsave_mask);
