untrusted comment: signature from openbsd 6.2 base secret key
RWRVWzAMgtyg7rV9KTlfWkfafPmWTOLMKkpjfA8gUrsBGVbPkEXfn1rPcZo6nWYnrShxfGIp/y97bfxKGJ+xjzHtpa7+DNdaHws=

OpenBSD 6.2 errata 020, July 31, 2018:

On i386, IO port permissions were incorrectly restricted.

Apply by doing:
    signify -Vep /etc/signify/openbsd-62-base.pub -x 020_ioport.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/arch/i386/i386/gdt.c
===================================================================
RCS file: /cvs/src/sys/arch/i386/i386/gdt.c,v
diff -u -p -u -r1.37 gdt.c
--- sys/arch/i386/i386/gdt.c	7 Mar 2016 05:32:46 -0000	1.37
+++ sys/arch/i386/i386/gdt.c	23 Jul 2018 23:53:28 -0000
@@ -210,7 +210,7 @@ tss_alloc(struct pcb *pcb)
 	int slot;
 
 	slot = gdt_get_slot();
-	setgdt(slot, &pcb->pcb_tss, sizeof(struct pcb) - 1,
+	setgdt(slot, &pcb->pcb_tss, sizeof(struct i386tss) - 1,
 	    SDT_SYS386TSS, SEL_KPL, 0, 0);
 	return GSEL(slot, SEL_KPL);
 }
