/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 25 "../../../openbgpd-portable/src/bgpd/parse.y"

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#include <netinet/ip_ipsp.h>
#include <netinet/icmp6.h>
#include <arpa/inet.h>

#include <ctype.h>
#include <endian.h>
#include <err.h>
#include <unistd.h>
#include <errno.h>
#include <limits.h>
#include <netdb.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>

#include "bgpd.h"
#include "session.h"
#include "rde.h"
#include "log.h"

#ifndef nitems
#define nitems(_a)	(sizeof((_a)) / sizeof((_a)[0]))
#endif

#define MACRO_NAME_LEN		128

TAILQ_HEAD(files, file)		 files = TAILQ_HEAD_INITIALIZER(files);
static struct file {
	TAILQ_ENTRY(file)	 entry;
	FILE			*stream;
	char			*name;
	size_t			 ungetpos;
	size_t			 ungetsize;
	u_char			*ungetbuf;
	int			 eof_reached;
	int			 lineno;
	int			 errors;
} *file, *topfile;
struct file	*pushfile(const char *, int);
int		 popfile(void);
int		 check_file_secrecy(int, const char *);
int		 yyparse(void);
int		 yylex(void);
int		 yyerror(const char *, ...)
    __attribute__((__format__ (printf, 1, 2)))
    __attribute__((__nonnull__ (1)));
int		 kw_cmp(const void *, const void *);
int		 lookup(char *);
int		 igetc(void);
int		 lgetc(int);
void		 lungetc(int);
int		 findeol(void);
int		 expand_macro(void);

TAILQ_HEAD(symhead, sym)	 symhead = TAILQ_HEAD_INITIALIZER(symhead);
struct sym {
	TAILQ_ENTRY(sym)	 entry;
	int			 used;
	int			 persist;
	char			*nam;
	char			*val;
};
int		 symset(const char *, const char *, int);
char		*symget(const char *);

struct filter_rib_l {
	struct filter_rib_l	*next;
	char			 name[PEER_DESCR_LEN];
};

struct filter_peers_l {
	struct filter_peers_l	*next;
	struct filter_peers	 p;
};

struct filter_prefix_l {
	struct filter_prefix_l	*next;
	struct filter_prefix	 p;
};

struct filter_prefixlen {
	enum comp_ops		op;
	int			len_min;
	int			len_max;
};

struct filter_as_l {
	struct filter_as_l	*next;
	struct filter_as	 a;
};

struct filter_match_l {
	struct filter_match	 m;
	struct filter_prefix_l	*prefix_l;
	struct filter_as_l	*as_l;
	struct filter_prefixset	*prefixset;
} fmopts;

struct aspa_tas_l {
	struct aspa_tas_l	*next;
	uint32_t		 as;
	uint32_t		 num;
};

struct flowspec_context {
	uint8_t			*components[FLOWSPEC_TYPE_MAX];
	uint16_t		 complen[FLOWSPEC_TYPE_MAX];
	uint8_t			 aid;
	uint8_t			 type;
	uint8_t			 addr_type;
};

struct peer	*alloc_peer(void);
struct peer	*new_peer(void);
struct peer	*new_group(void);
int		 add_mrtconfig(enum mrt_type, char *, int, struct peer *,
		    char *);
struct rde_rib	*add_rib(char *);
struct rde_rib	*find_rib(char *);
int		 rib_add_fib(struct rde_rib *, u_int);
int		 get_id(struct peer *);
int		 merge_prefixspec(struct filter_prefix *,
		    struct filter_prefixlen *);
int		 expand_rule(struct filter_rule *, struct filter_rib_l *,
		    struct filter_peers_l *, struct filter_match_l *,
		    struct filter_set_head *);
int		 str2key(char *, char *, size_t);
int		 neighbor_consistent(struct peer *);
int		 merge_filterset(struct filter_set_head *, struct filter_set *);
void		 optimize_filters(struct filter_head *);
struct filter_rule	*get_rule(enum action_types);

int		 parsecommunity(struct community *, int, char *);
int		 parseextcommunity(struct community *, char *,
		    char *);
static int	 new_as_set(char *);
static void	 add_as_set(uint32_t);
static void	 done_as_set(void);
static struct prefixset	*new_prefix_set(char *, int);
static void	 add_roa_set(struct prefixset_item *, uint32_t, uint8_t,
		    time_t);
static struct rtr_config	*get_rtr(struct bgpd_addr *);
static int	 insert_rtr(struct rtr_config *);
static int	 merge_aspa_set(uint32_t, struct aspa_tas_l *, time_t);
static int	 map_tos(char *, int *);
static int	 getservice(char *);
static int	 parse_flags(char *);
static struct flowspec_config	*flow_to_flowspec(struct flowspec_context *);
static void	 flow_free(struct flowspec_context *);
static int	 push_prefix(struct bgpd_addr *, uint8_t);
static int	 push_binop(uint8_t, long long);
static int	 push_unary_numop(enum comp_ops, long long);
static int	 push_binary_numop(enum comp_ops, long long, long long);
static int	 geticmptypebyname(char *, uint8_t);
static int	 geticmpcodebyname(u_long, char *, uint8_t);

static struct bgpd_config	*conf;
static struct network_head	*netconf;
static struct peer_head		*new_peers, *cur_peers;
static struct rtr_config_head	*cur_rtrs;
static struct peer		*curpeer;
static struct peer		*curgroup;
static struct rde_rib		*currib;
static struct l3vpn		*curvpn;
static struct prefixset		*curpset, *curoset;
static struct roa_tree		*curroatree;
static struct rtr_config	*currtr;
static struct filter_head	*filter_l;
static struct filter_head	*peerfilter_l;
static struct filter_head	*groupfilter_l;
static struct filter_rule	*curpeer_filter[2];
static struct filter_rule	*curgroup_filter[2];
static struct flowspec_context	*curflow;
static int			 noexpires;

typedef struct {
	union {
		long long		 number;
		char			*string;
		struct bgpd_addr	 addr;
		uint8_t			 u8;
		struct filter_rib_l	*filter_rib;
		struct filter_peers_l	*filter_peers;
		struct filter_match_l	 filter_match;
		struct filter_prefixset	*filter_prefixset;
		struct filter_prefix_l	*filter_prefix;
		struct filter_as_l	*filter_as;
		struct filter_set	*filter_set;
		struct filter_set_head	*filter_set_head;
		struct aspa_tas_l	*aspa_elm;
		struct {
			struct bgpd_addr	prefix;
			uint8_t			len;
		}			prefix;
		struct filter_prefixlen	prefixlen;
		struct prefixset_item	*prefixset_item;
		struct {
			enum auth_enc_alg	enc_alg;
			uint8_t			enc_key_len;
			char			enc_key[IPSEC_ENC_KEY_LEN];
		}			encspec;
	} v;
	int lineno;
} YYSTYPE;


#line 288 "parse.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif


/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token kinds.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    YYEMPTY = -2,
    YYEOF = 0,                     /* "end of file"  */
    YYerror = 256,                 /* error  */
    YYUNDEF = 257,                 /* "invalid token"  */
    AS = 258,                      /* AS  */
    ROUTERID = 259,                /* ROUTERID  */
    HOLDTIME = 260,                /* HOLDTIME  */
    YMIN = 261,                    /* YMIN  */
    LISTEN = 262,                  /* LISTEN  */
    ON = 263,                      /* ON  */
    FIBUPDATE = 264,               /* FIBUPDATE  */
    FIBPRIORITY = 265,             /* FIBPRIORITY  */
    RTABLE = 266,                  /* RTABLE  */
    NONE = 267,                    /* NONE  */
    UNICAST = 268,                 /* UNICAST  */
    VPN = 269,                     /* VPN  */
    RD = 270,                      /* RD  */
    EXPORT = 271,                  /* EXPORT  */
    EXPORTTRGT = 272,              /* EXPORTTRGT  */
    IMPORTTRGT = 273,              /* IMPORTTRGT  */
    DEFAULTROUTE = 274,            /* DEFAULTROUTE  */
    RDE = 275,                     /* RDE  */
    RIB = 276,                     /* RIB  */
    EVALUATE = 277,                /* EVALUATE  */
    IGNORE = 278,                  /* IGNORE  */
    COMPARE = 279,                 /* COMPARE  */
    RTR = 280,                     /* RTR  */
    PORT = 281,                    /* PORT  */
    MINVERSION = 282,              /* MINVERSION  */
    GROUP = 283,                   /* GROUP  */
    NEIGHBOR = 284,                /* NEIGHBOR  */
    NETWORK = 285,                 /* NETWORK  */
    EBGP = 286,                    /* EBGP  */
    IBGP = 287,                    /* IBGP  */
    FLOWSPEC = 288,                /* FLOWSPEC  */
    PROTO = 289,                   /* PROTO  */
    FLAGS = 290,                   /* FLAGS  */
    FRAGMENT = 291,                /* FRAGMENT  */
    TOS = 292,                     /* TOS  */
    LENGTH = 293,                  /* LENGTH  */
    ICMPTYPE = 294,                /* ICMPTYPE  */
    CODE = 295,                    /* CODE  */
    LOCALAS = 296,                 /* LOCALAS  */
    REMOTEAS = 297,                /* REMOTEAS  */
    DESCR = 298,                   /* DESCR  */
    LOCALADDR = 299,               /* LOCALADDR  */
    MULTIHOP = 300,                /* MULTIHOP  */
    PASSIVE = 301,                 /* PASSIVE  */
    MAXPREFIX = 302,               /* MAXPREFIX  */
    RESTART = 303,                 /* RESTART  */
    ANNOUNCE = 304,                /* ANNOUNCE  */
    REFRESH = 305,                 /* REFRESH  */
    AS4BYTE = 306,                 /* AS4BYTE  */
    CONNECTRETRY = 307,            /* CONNECTRETRY  */
    ENHANCED = 308,                /* ENHANCED  */
    ADDPATH = 309,                 /* ADDPATH  */
    SEND = 310,                    /* SEND  */
    RECV = 311,                    /* RECV  */
    PLUS = 312,                    /* PLUS  */
    POLICY = 313,                  /* POLICY  */
    ROLE = 314,                    /* ROLE  */
    DEMOTE = 315,                  /* DEMOTE  */
    ENFORCE = 316,                 /* ENFORCE  */
    NEIGHBORAS = 317,              /* NEIGHBORAS  */
    ASOVERRIDE = 318,              /* ASOVERRIDE  */
    REFLECTOR = 319,               /* REFLECTOR  */
    DEPEND = 320,                  /* DEPEND  */
    DOWN = 321,                    /* DOWN  */
    DUMP = 322,                    /* DUMP  */
    IN = 323,                      /* IN  */
    OUT = 324,                     /* OUT  */
    SOCKET = 325,                  /* SOCKET  */
    RESTRICTED = 326,              /* RESTRICTED  */
    LOG = 327,                     /* LOG  */
    TRANSPARENT = 328,             /* TRANSPARENT  */
    FILTERED = 329,                /* FILTERED  */
    TCP = 330,                     /* TCP  */
    MD5SIG = 331,                  /* MD5SIG  */
    PASSWORD = 332,                /* PASSWORD  */
    KEY = 333,                     /* KEY  */
    TTLSECURITY = 334,             /* TTLSECURITY  */
    ALLOW = 335,                   /* ALLOW  */
    DENY = 336,                    /* DENY  */
    MATCH = 337,                   /* MATCH  */
    QUICK = 338,                   /* QUICK  */
    FROM = 339,                    /* FROM  */
    TO = 340,                      /* TO  */
    ANY = 341,                     /* ANY  */
    CONNECTED = 342,               /* CONNECTED  */
    STATIC = 343,                  /* STATIC  */
    COMMUNITY = 344,               /* COMMUNITY  */
    EXTCOMMUNITY = 345,            /* EXTCOMMUNITY  */
    LARGECOMMUNITY = 346,          /* LARGECOMMUNITY  */
    DELETE = 347,                  /* DELETE  */
    MAXCOMMUNITIES = 348,          /* MAXCOMMUNITIES  */
    MAXEXTCOMMUNITIES = 349,       /* MAXEXTCOMMUNITIES  */
    MAXLARGECOMMUNITIES = 350,     /* MAXLARGECOMMUNITIES  */
    PREFIX = 351,                  /* PREFIX  */
    PREFIXLEN = 352,               /* PREFIXLEN  */
    PREFIXSET = 353,               /* PREFIXSET  */
    ASPASET = 354,                 /* ASPASET  */
    ROASET = 355,                  /* ROASET  */
    ORIGINSET = 356,               /* ORIGINSET  */
    OVS = 357,                     /* OVS  */
    AVS = 358,                     /* AVS  */
    EXPIRES = 359,                 /* EXPIRES  */
    ASSET = 360,                   /* ASSET  */
    SOURCEAS = 361,                /* SOURCEAS  */
    TRANSITAS = 362,               /* TRANSITAS  */
    PEERAS = 363,                  /* PEERAS  */
    PROVIDERAS = 364,              /* PROVIDERAS  */
    CUSTOMERAS = 365,              /* CUSTOMERAS  */
    MAXASLEN = 366,                /* MAXASLEN  */
    MAXASSEQ = 367,                /* MAXASSEQ  */
    SET = 368,                     /* SET  */
    LOCALPREF = 369,               /* LOCALPREF  */
    MED = 370,                     /* MED  */
    METRIC = 371,                  /* METRIC  */
    NEXTHOP = 372,                 /* NEXTHOP  */
    REJECT = 373,                  /* REJECT  */
    BLACKHOLE = 374,               /* BLACKHOLE  */
    NOMODIFY = 375,                /* NOMODIFY  */
    SELF = 376,                    /* SELF  */
    PREPEND_SELF = 377,            /* PREPEND_SELF  */
    PREPEND_PEER = 378,            /* PREPEND_PEER  */
    PFTABLE = 379,                 /* PFTABLE  */
    WEIGHT = 380,                  /* WEIGHT  */
    RTLABEL = 381,                 /* RTLABEL  */
    ORIGIN = 382,                  /* ORIGIN  */
    PRIORITY = 383,                /* PRIORITY  */
    ERROR = 384,                   /* ERROR  */
    INCLUDE = 385,                 /* INCLUDE  */
    IPSEC = 386,                   /* IPSEC  */
    ESP = 387,                     /* ESP  */
    AH = 388,                      /* AH  */
    SPI = 389,                     /* SPI  */
    IKE = 390,                     /* IKE  */
    IPV4 = 391,                    /* IPV4  */
    IPV6 = 392,                    /* IPV6  */
    QUALIFY = 393,                 /* QUALIFY  */
    VIA = 394,                     /* VIA  */
    NE = 395,                      /* NE  */
    LE = 396,                      /* LE  */
    GE = 397,                      /* GE  */
    XRANGE = 398,                  /* XRANGE  */
    LONGER = 399,                  /* LONGER  */
    MAXLEN = 400,                  /* MAXLEN  */
    MAX = 401,                     /* MAX  */
    STRING = 402,                  /* STRING  */
    NUMBER = 403                   /* NUMBER  */
  };
  typedef enum yytokentype yytoken_kind_t;
#endif
/* Token kinds.  */
#define YYEMPTY -2
#define YYEOF 0
#define YYerror 256
#define YYUNDEF 257
#define AS 258
#define ROUTERID 259
#define HOLDTIME 260
#define YMIN 261
#define LISTEN 262
#define ON 263
#define FIBUPDATE 264
#define FIBPRIORITY 265
#define RTABLE 266
#define NONE 267
#define UNICAST 268
#define VPN 269
#define RD 270
#define EXPORT 271
#define EXPORTTRGT 272
#define IMPORTTRGT 273
#define DEFAULTROUTE 274
#define RDE 275
#define RIB 276
#define EVALUATE 277
#define IGNORE 278
#define COMPARE 279
#define RTR 280
#define PORT 281
#define MINVERSION 282
#define GROUP 283
#define NEIGHBOR 284
#define NETWORK 285
#define EBGP 286
#define IBGP 287
#define FLOWSPEC 288
#define PROTO 289
#define FLAGS 290
#define FRAGMENT 291
#define TOS 292
#define LENGTH 293
#define ICMPTYPE 294
#define CODE 295
#define LOCALAS 296
#define REMOTEAS 297
#define DESCR 298
#define LOCALADDR 299
#define MULTIHOP 300
#define PASSIVE 301
#define MAXPREFIX 302
#define RESTART 303
#define ANNOUNCE 304
#define REFRESH 305
#define AS4BYTE 306
#define CONNECTRETRY 307
#define ENHANCED 308
#define ADDPATH 309
#define SEND 310
#define RECV 311
#define PLUS 312
#define POLICY 313
#define ROLE 314
#define DEMOTE 315
#define ENFORCE 316
#define NEIGHBORAS 317
#define ASOVERRIDE 318
#define REFLECTOR 319
#define DEPEND 320
#define DOWN 321
#define DUMP 322
#define IN 323
#define OUT 324
#define SOCKET 325
#define RESTRICTED 326
#define LOG 327
#define TRANSPARENT 328
#define FILTERED 329
#define TCP 330
#define MD5SIG 331
#define PASSWORD 332
#define KEY 333
#define TTLSECURITY 334
#define ALLOW 335
#define DENY 336
#define MATCH 337
#define QUICK 338
#define FROM 339
#define TO 340
#define ANY 341
#define CONNECTED 342
#define STATIC 343
#define COMMUNITY 344
#define EXTCOMMUNITY 345
#define LARGECOMMUNITY 346
#define DELETE 347
#define MAXCOMMUNITIES 348
#define MAXEXTCOMMUNITIES 349
#define MAXLARGECOMMUNITIES 350
#define PREFIX 351
#define PREFIXLEN 352
#define PREFIXSET 353
#define ASPASET 354
#define ROASET 355
#define ORIGINSET 356
#define OVS 357
#define AVS 358
#define EXPIRES 359
#define ASSET 360
#define SOURCEAS 361
#define TRANSITAS 362
#define PEERAS 363
#define PROVIDERAS 364
#define CUSTOMERAS 365
#define MAXASLEN 366
#define MAXASSEQ 367
#define SET 368
#define LOCALPREF 369
#define MED 370
#define METRIC 371
#define NEXTHOP 372
#define REJECT 373
#define BLACKHOLE 374
#define NOMODIFY 375
#define SELF 376
#define PREPEND_SELF 377
#define PREPEND_PEER 378
#define PFTABLE 379
#define WEIGHT 380
#define RTLABEL 381
#define ORIGIN 382
#define PRIORITY 383
#define ERROR 384
#define INCLUDE 385
#define IPSEC 386
#define ESP 387
#define AH 388
#define SPI 389
#define IKE 390
#define IPV4 391
#define IPV6 392
#define QUALIFY 393
#define VIA 394
#define NE 395
#define LE 396
#define GE 397
#define XRANGE 398
#define LONGER 399
#define MAXLEN 400
#define MAX 401
#define STRING 402
#define NUMBER 403

/* Value type.  */


extern YYSTYPE yylval;


int yyparse (void);



/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_AS = 3,                         /* AS  */
  YYSYMBOL_ROUTERID = 4,                   /* ROUTERID  */
  YYSYMBOL_HOLDTIME = 5,                   /* HOLDTIME  */
  YYSYMBOL_YMIN = 6,                       /* YMIN  */
  YYSYMBOL_LISTEN = 7,                     /* LISTEN  */
  YYSYMBOL_ON = 8,                         /* ON  */
  YYSYMBOL_FIBUPDATE = 9,                  /* FIBUPDATE  */
  YYSYMBOL_FIBPRIORITY = 10,               /* FIBPRIORITY  */
  YYSYMBOL_RTABLE = 11,                    /* RTABLE  */
  YYSYMBOL_NONE = 12,                      /* NONE  */
  YYSYMBOL_UNICAST = 13,                   /* UNICAST  */
  YYSYMBOL_VPN = 14,                       /* VPN  */
  YYSYMBOL_RD = 15,                        /* RD  */
  YYSYMBOL_EXPORT = 16,                    /* EXPORT  */
  YYSYMBOL_EXPORTTRGT = 17,                /* EXPORTTRGT  */
  YYSYMBOL_IMPORTTRGT = 18,                /* IMPORTTRGT  */
  YYSYMBOL_DEFAULTROUTE = 19,              /* DEFAULTROUTE  */
  YYSYMBOL_RDE = 20,                       /* RDE  */
  YYSYMBOL_RIB = 21,                       /* RIB  */
  YYSYMBOL_EVALUATE = 22,                  /* EVALUATE  */
  YYSYMBOL_IGNORE = 23,                    /* IGNORE  */
  YYSYMBOL_COMPARE = 24,                   /* COMPARE  */
  YYSYMBOL_RTR = 25,                       /* RTR  */
  YYSYMBOL_PORT = 26,                      /* PORT  */
  YYSYMBOL_MINVERSION = 27,                /* MINVERSION  */
  YYSYMBOL_GROUP = 28,                     /* GROUP  */
  YYSYMBOL_NEIGHBOR = 29,                  /* NEIGHBOR  */
  YYSYMBOL_NETWORK = 30,                   /* NETWORK  */
  YYSYMBOL_EBGP = 31,                      /* EBGP  */
  YYSYMBOL_IBGP = 32,                      /* IBGP  */
  YYSYMBOL_FLOWSPEC = 33,                  /* FLOWSPEC  */
  YYSYMBOL_PROTO = 34,                     /* PROTO  */
  YYSYMBOL_FLAGS = 35,                     /* FLAGS  */
  YYSYMBOL_FRAGMENT = 36,                  /* FRAGMENT  */
  YYSYMBOL_TOS = 37,                       /* TOS  */
  YYSYMBOL_LENGTH = 38,                    /* LENGTH  */
  YYSYMBOL_ICMPTYPE = 39,                  /* ICMPTYPE  */
  YYSYMBOL_CODE = 40,                      /* CODE  */
  YYSYMBOL_LOCALAS = 41,                   /* LOCALAS  */
  YYSYMBOL_REMOTEAS = 42,                  /* REMOTEAS  */
  YYSYMBOL_DESCR = 43,                     /* DESCR  */
  YYSYMBOL_LOCALADDR = 44,                 /* LOCALADDR  */
  YYSYMBOL_MULTIHOP = 45,                  /* MULTIHOP  */
  YYSYMBOL_PASSIVE = 46,                   /* PASSIVE  */
  YYSYMBOL_MAXPREFIX = 47,                 /* MAXPREFIX  */
  YYSYMBOL_RESTART = 48,                   /* RESTART  */
  YYSYMBOL_ANNOUNCE = 49,                  /* ANNOUNCE  */
  YYSYMBOL_REFRESH = 50,                   /* REFRESH  */
  YYSYMBOL_AS4BYTE = 51,                   /* AS4BYTE  */
  YYSYMBOL_CONNECTRETRY = 52,              /* CONNECTRETRY  */
  YYSYMBOL_ENHANCED = 53,                  /* ENHANCED  */
  YYSYMBOL_ADDPATH = 54,                   /* ADDPATH  */
  YYSYMBOL_SEND = 55,                      /* SEND  */
  YYSYMBOL_RECV = 56,                      /* RECV  */
  YYSYMBOL_PLUS = 57,                      /* PLUS  */
  YYSYMBOL_POLICY = 58,                    /* POLICY  */
  YYSYMBOL_ROLE = 59,                      /* ROLE  */
  YYSYMBOL_DEMOTE = 60,                    /* DEMOTE  */
  YYSYMBOL_ENFORCE = 61,                   /* ENFORCE  */
  YYSYMBOL_NEIGHBORAS = 62,                /* NEIGHBORAS  */
  YYSYMBOL_ASOVERRIDE = 63,                /* ASOVERRIDE  */
  YYSYMBOL_REFLECTOR = 64,                 /* REFLECTOR  */
  YYSYMBOL_DEPEND = 65,                    /* DEPEND  */
  YYSYMBOL_DOWN = 66,                      /* DOWN  */
  YYSYMBOL_DUMP = 67,                      /* DUMP  */
  YYSYMBOL_IN = 68,                        /* IN  */
  YYSYMBOL_OUT = 69,                       /* OUT  */
  YYSYMBOL_SOCKET = 70,                    /* SOCKET  */
  YYSYMBOL_RESTRICTED = 71,                /* RESTRICTED  */
  YYSYMBOL_LOG = 72,                       /* LOG  */
  YYSYMBOL_TRANSPARENT = 73,               /* TRANSPARENT  */
  YYSYMBOL_FILTERED = 74,                  /* FILTERED  */
  YYSYMBOL_TCP = 75,                       /* TCP  */
  YYSYMBOL_MD5SIG = 76,                    /* MD5SIG  */
  YYSYMBOL_PASSWORD = 77,                  /* PASSWORD  */
  YYSYMBOL_KEY = 78,                       /* KEY  */
  YYSYMBOL_TTLSECURITY = 79,               /* TTLSECURITY  */
  YYSYMBOL_ALLOW = 80,                     /* ALLOW  */
  YYSYMBOL_DENY = 81,                      /* DENY  */
  YYSYMBOL_MATCH = 82,                     /* MATCH  */
  YYSYMBOL_QUICK = 83,                     /* QUICK  */
  YYSYMBOL_FROM = 84,                      /* FROM  */
  YYSYMBOL_TO = 85,                        /* TO  */
  YYSYMBOL_ANY = 86,                       /* ANY  */
  YYSYMBOL_CONNECTED = 87,                 /* CONNECTED  */
  YYSYMBOL_STATIC = 88,                    /* STATIC  */
  YYSYMBOL_COMMUNITY = 89,                 /* COMMUNITY  */
  YYSYMBOL_EXTCOMMUNITY = 90,              /* EXTCOMMUNITY  */
  YYSYMBOL_LARGECOMMUNITY = 91,            /* LARGECOMMUNITY  */
  YYSYMBOL_DELETE = 92,                    /* DELETE  */
  YYSYMBOL_MAXCOMMUNITIES = 93,            /* MAXCOMMUNITIES  */
  YYSYMBOL_MAXEXTCOMMUNITIES = 94,         /* MAXEXTCOMMUNITIES  */
  YYSYMBOL_MAXLARGECOMMUNITIES = 95,       /* MAXLARGECOMMUNITIES  */
  YYSYMBOL_PREFIX = 96,                    /* PREFIX  */
  YYSYMBOL_PREFIXLEN = 97,                 /* PREFIXLEN  */
  YYSYMBOL_PREFIXSET = 98,                 /* PREFIXSET  */
  YYSYMBOL_ASPASET = 99,                   /* ASPASET  */
  YYSYMBOL_ROASET = 100,                   /* ROASET  */
  YYSYMBOL_ORIGINSET = 101,                /* ORIGINSET  */
  YYSYMBOL_OVS = 102,                      /* OVS  */
  YYSYMBOL_AVS = 103,                      /* AVS  */
  YYSYMBOL_EXPIRES = 104,                  /* EXPIRES  */
  YYSYMBOL_ASSET = 105,                    /* ASSET  */
  YYSYMBOL_SOURCEAS = 106,                 /* SOURCEAS  */
  YYSYMBOL_TRANSITAS = 107,                /* TRANSITAS  */
  YYSYMBOL_PEERAS = 108,                   /* PEERAS  */
  YYSYMBOL_PROVIDERAS = 109,               /* PROVIDERAS  */
  YYSYMBOL_CUSTOMERAS = 110,               /* CUSTOMERAS  */
  YYSYMBOL_MAXASLEN = 111,                 /* MAXASLEN  */
  YYSYMBOL_MAXASSEQ = 112,                 /* MAXASSEQ  */
  YYSYMBOL_SET = 113,                      /* SET  */
  YYSYMBOL_LOCALPREF = 114,                /* LOCALPREF  */
  YYSYMBOL_MED = 115,                      /* MED  */
  YYSYMBOL_METRIC = 116,                   /* METRIC  */
  YYSYMBOL_NEXTHOP = 117,                  /* NEXTHOP  */
  YYSYMBOL_REJECT = 118,                   /* REJECT  */
  YYSYMBOL_BLACKHOLE = 119,                /* BLACKHOLE  */
  YYSYMBOL_NOMODIFY = 120,                 /* NOMODIFY  */
  YYSYMBOL_SELF = 121,                     /* SELF  */
  YYSYMBOL_PREPEND_SELF = 122,             /* PREPEND_SELF  */
  YYSYMBOL_PREPEND_PEER = 123,             /* PREPEND_PEER  */
  YYSYMBOL_PFTABLE = 124,                  /* PFTABLE  */
  YYSYMBOL_WEIGHT = 125,                   /* WEIGHT  */
  YYSYMBOL_RTLABEL = 126,                  /* RTLABEL  */
  YYSYMBOL_ORIGIN = 127,                   /* ORIGIN  */
  YYSYMBOL_PRIORITY = 128,                 /* PRIORITY  */
  YYSYMBOL_ERROR = 129,                    /* ERROR  */
  YYSYMBOL_INCLUDE = 130,                  /* INCLUDE  */
  YYSYMBOL_IPSEC = 131,                    /* IPSEC  */
  YYSYMBOL_ESP = 132,                      /* ESP  */
  YYSYMBOL_AH = 133,                       /* AH  */
  YYSYMBOL_SPI = 134,                      /* SPI  */
  YYSYMBOL_IKE = 135,                      /* IKE  */
  YYSYMBOL_IPV4 = 136,                     /* IPV4  */
  YYSYMBOL_IPV6 = 137,                     /* IPV6  */
  YYSYMBOL_QUALIFY = 138,                  /* QUALIFY  */
  YYSYMBOL_VIA = 139,                      /* VIA  */
  YYSYMBOL_NE = 140,                       /* NE  */
  YYSYMBOL_LE = 141,                       /* LE  */
  YYSYMBOL_GE = 142,                       /* GE  */
  YYSYMBOL_XRANGE = 143,                   /* XRANGE  */
  YYSYMBOL_LONGER = 144,                   /* LONGER  */
  YYSYMBOL_MAXLEN = 145,                   /* MAXLEN  */
  YYSYMBOL_MAX = 146,                      /* MAX  */
  YYSYMBOL_STRING = 147,                   /* STRING  */
  YYSYMBOL_NUMBER = 148,                   /* NUMBER  */
  YYSYMBOL_149_n_ = 149,                   /* '\n'  */
  YYSYMBOL_150_ = 150,                     /* '='  */
  YYSYMBOL_151_ = 151,                     /* '{'  */
  YYSYMBOL_152_ = 152,                     /* '}'  */
  YYSYMBOL_153_ = 153,                     /* '/'  */
  YYSYMBOL_154_ = 154,                     /* '+'  */
  YYSYMBOL_155_ = 155,                     /* '-'  */
  YYSYMBOL_156_ = 156,                     /* ','  */
  YYSYMBOL_157_ = 157,                     /* '<'  */
  YYSYMBOL_158_ = 158,                     /* '>'  */
  YYSYMBOL_YYACCEPT = 159,                 /* $accept  */
  YYSYMBOL_grammar = 160,                  /* grammar  */
  YYSYMBOL_asnumber = 161,                 /* asnumber  */
  YYSYMBOL_as4number = 162,                /* as4number  */
  YYSYMBOL_as4number_any = 163,            /* as4number_any  */
  YYSYMBOL_string = 164,                   /* string  */
  YYSYMBOL_yesno = 165,                    /* yesno  */
  YYSYMBOL_varset = 166,                   /* varset  */
  YYSYMBOL_include = 167,                  /* include  */
  YYSYMBOL_as_set = 168,                   /* as_set  */
  YYSYMBOL_169_1 = 169,                    /* $@1  */
  YYSYMBOL_as_set_l = 170,                 /* as_set_l  */
  YYSYMBOL_prefixset = 171,                /* prefixset  */
  YYSYMBOL_172_2 = 172,                    /* $@2  */
  YYSYMBOL_prefixset_l = 173,              /* prefixset_l  */
  YYSYMBOL_prefixset_item = 174,           /* prefixset_item  */
  YYSYMBOL_roa_set = 175,                  /* roa_set  */
  YYSYMBOL_176_3 = 176,                    /* $@3  */
  YYSYMBOL_origin_set = 177,               /* origin_set  */
  YYSYMBOL_178_4 = 178,                    /* $@4  */
  YYSYMBOL_expires = 179,                  /* expires  */
  YYSYMBOL_roa_set_l = 180,                /* roa_set_l  */
  YYSYMBOL_aspa_set = 181,                 /* aspa_set  */
  YYSYMBOL_aspa_set_l = 182,               /* aspa_set_l  */
  YYSYMBOL_aspa_elm = 183,                 /* aspa_elm  */
  YYSYMBOL_aspa_tas_l = 184,               /* aspa_tas_l  */
  YYSYMBOL_aspa_tas = 185,                 /* aspa_tas  */
  YYSYMBOL_rtr = 186,                      /* rtr  */
  YYSYMBOL_187_5 = 187,                    /* $@5  */
  YYSYMBOL_rtropt_l = 188,                 /* rtropt_l  */
  YYSYMBOL_rtropt = 189,                   /* rtropt  */
  YYSYMBOL_conf_main = 190,                /* conf_main  */
  YYSYMBOL_rib = 191,                      /* rib  */
  YYSYMBOL_192_6 = 192,                    /* $@6  */
  YYSYMBOL_ribopts = 193,                  /* ribopts  */
  YYSYMBOL_fibupdate = 194,                /* fibupdate  */
  YYSYMBOL_mrtdump = 195,                  /* mrtdump  */
  YYSYMBOL_network = 196,                  /* network  */
  YYSYMBOL_flowspec = 197,                 /* flowspec  */
  YYSYMBOL_198_7 = 198,                    /* $@7  */
  YYSYMBOL_proto = 199,                    /* proto  */
  YYSYMBOL_proto_list = 200,               /* proto_list  */
  YYSYMBOL_proto_item = 201,               /* proto_item  */
  YYSYMBOL_from = 202,                     /* from  */
  YYSYMBOL_203_8 = 203,                    /* $@8  */
  YYSYMBOL_to = 204,                       /* to  */
  YYSYMBOL_205_9 = 205,                    /* $@9  */
  YYSYMBOL_ipportspec = 206,               /* ipportspec  */
  YYSYMBOL_ipspec = 207,                   /* ipspec  */
  YYSYMBOL_portspec = 208,                 /* portspec  */
  YYSYMBOL_port_list = 209,                /* port_list  */
  YYSYMBOL_port_item = 210,                /* port_item  */
  YYSYMBOL_port = 211,                     /* port  */
  YYSYMBOL_flow_rules = 212,               /* flow_rules  */
  YYSYMBOL_flow_rules_l = 213,             /* flow_rules_l  */
  YYSYMBOL_flowrule = 214,                 /* flowrule  */
  YYSYMBOL_215_10 = 215,                   /* $@10  */
  YYSYMBOL_216_11 = 216,                   /* $@11  */
  YYSYMBOL_flags = 217,                    /* flags  */
  YYSYMBOL_flag = 218,                     /* flag  */
  YYSYMBOL_icmpspec = 219,                 /* icmpspec  */
  YYSYMBOL_icmp_list = 220,                /* icmp_list  */
  YYSYMBOL_icmp_item = 221,                /* icmp_item  */
  YYSYMBOL_icmptype = 222,                 /* icmptype  */
  YYSYMBOL_tos = 223,                      /* tos  */
  YYSYMBOL_lengthspec = 224,               /* lengthspec  */
  YYSYMBOL_length_list = 225,              /* length_list  */
  YYSYMBOL_length_item = 226,              /* length_item  */
  YYSYMBOL_length = 227,                   /* length  */
  YYSYMBOL_inout = 228,                    /* inout  */
  YYSYMBOL_restricted = 229,               /* restricted  */
  YYSYMBOL_address = 230,                  /* address  */
  YYSYMBOL_prefix = 231,                   /* prefix  */
  YYSYMBOL_addrspec = 232,                 /* addrspec  */
  YYSYMBOL_optnumber = 233,                /* optnumber  */
  YYSYMBOL_l3vpn = 234,                    /* l3vpn  */
  YYSYMBOL_235_12 = 235,                   /* $@12  */
  YYSYMBOL_l3vpnopts_l = 236,              /* l3vpnopts_l  */
  YYSYMBOL_l3vpnopts = 237,                /* l3vpnopts  */
  YYSYMBOL_neighbor = 238,                 /* neighbor  */
  YYSYMBOL_239_13 = 239,                   /* $@13  */
  YYSYMBOL_240_14 = 240,                   /* $@14  */
  YYSYMBOL_group = 241,                    /* group  */
  YYSYMBOL_242_15 = 242,                   /* $@15  */
  YYSYMBOL_groupopts_l = 243,              /* groupopts_l  */
  YYSYMBOL_addpathextra = 244,             /* addpathextra  */
  YYSYMBOL_addpathmax = 245,               /* addpathmax  */
  YYSYMBOL_peeropts_h = 246,               /* peeropts_h  */
  YYSYMBOL_peeropts_l = 247,               /* peeropts_l  */
  YYSYMBOL_peeropts = 248,                 /* peeropts  */
  YYSYMBOL_restart = 249,                  /* restart  */
  YYSYMBOL_af = 250,                       /* af  */
  YYSYMBOL_safi = 251,                     /* safi  */
  YYSYMBOL_nettype = 252,                  /* nettype  */
  YYSYMBOL_espah = 253,                    /* espah  */
  YYSYMBOL_encspec = 254,                  /* encspec  */
  YYSYMBOL_filterrule = 255,               /* filterrule  */
  YYSYMBOL_action = 256,                   /* action  */
  YYSYMBOL_quick = 257,                    /* quick  */
  YYSYMBOL_direction = 258,                /* direction  */
  YYSYMBOL_filter_rib_h = 259,             /* filter_rib_h  */
  YYSYMBOL_filter_rib_l = 260,             /* filter_rib_l  */
  YYSYMBOL_filter_rib = 261,               /* filter_rib  */
  YYSYMBOL_filter_peer_h = 262,            /* filter_peer_h  */
  YYSYMBOL_filter_peer_l = 263,            /* filter_peer_l  */
  YYSYMBOL_filter_peer = 264,              /* filter_peer  */
  YYSYMBOL_filter_prefix_h = 265,          /* filter_prefix_h  */
  YYSYMBOL_filter_prefix_m = 266,          /* filter_prefix_m  */
  YYSYMBOL_filter_prefix_l = 267,          /* filter_prefix_l  */
  YYSYMBOL_filter_prefix = 268,            /* filter_prefix  */
  YYSYMBOL_filter_as_h = 269,              /* filter_as_h  */
  YYSYMBOL_filter_as_t_l = 270,            /* filter_as_t_l  */
  YYSYMBOL_filter_as_t = 271,              /* filter_as_t  */
  YYSYMBOL_filter_as_l_h = 272,            /* filter_as_l_h  */
  YYSYMBOL_filter_as_l = 273,              /* filter_as_l  */
  YYSYMBOL_filter_as = 274,                /* filter_as  */
  YYSYMBOL_filter_match_h = 275,           /* filter_match_h  */
  YYSYMBOL_276_16 = 276,                   /* $@16  */
  YYSYMBOL_filter_match = 277,             /* filter_match  */
  YYSYMBOL_filter_elm = 278,               /* filter_elm  */
  YYSYMBOL_prefixlenop = 279,              /* prefixlenop  */
  YYSYMBOL_filter_as_type = 280,           /* filter_as_type  */
  YYSYMBOL_filter_set = 281,               /* filter_set  */
  YYSYMBOL_filter_set_l = 282,             /* filter_set_l  */
  YYSYMBOL_community = 283,                /* community  */
  YYSYMBOL_delete = 284,                   /* delete  */
  YYSYMBOL_enforce = 285,                  /* enforce  */
  YYSYMBOL_yesnoenforce = 286,             /* yesnoenforce  */
  YYSYMBOL_filter_set_opt = 287,           /* filter_set_opt  */
  YYSYMBOL_origincode = 288,               /* origincode  */
  YYSYMBOL_validity = 289,                 /* validity  */
  YYSYMBOL_aspa_validity = 290,            /* aspa_validity  */
  YYSYMBOL_optnl = 291,                    /* optnl  */
  YYSYMBOL_comma = 292,                    /* comma  */
  YYSYMBOL_unaryop = 293,                  /* unaryop  */
  YYSYMBOL_equalityop = 294,               /* equalityop  */
  YYSYMBOL_binaryop = 295                  /* binaryop  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  2
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   960

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  159
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  137
/* YYNRULES -- Number of rules.  */
#define YYNRULES  412
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  756

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   403


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     149,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   154,   156,   155,     2,   153,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     157,   150,   158,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   151,     2,   152,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   300,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   322,   333,   365,   375,   402,   407,   413,   416,
     431,   459,   474,   474,   488,   496,   497,   499,   499,   509,
     519,   533,   549,   566,   566,   571,   574,   574,   588,   600,
     603,   611,   621,   633,   634,   637,   638,   641,   658,   659,
     666,   672,   680,   689,   689,   701,   702,   705,   716,   724,
     727,   737,   744,   748,   755,   763,   771,   785,   799,   806,
     817,   823,   829,   838,   866,   898,   908,   918,   931,   944,
     952,   965,   981,   988,  1004,  1004,  1014,  1015,  1024,  1033,
    1034,  1042,  1072,  1093,  1122,  1141,  1164,  1184,  1184,  1213,
    1214,  1217,  1222,  1229,  1241,  1250,  1250,  1256,  1256,  1262,
    1263,  1264,  1267,  1268,  1274,  1275,  1278,  1279,  1282,  1286,
    1290,  1296,  1304,  1314,  1315,  1318,  1319,  1322,  1323,  1324,
    1324,  1327,  1327,  1330,  1331,  1334,  1335,  1342,  1357,  1361,
    1365,  1368,  1378,  1379,  1382,  1383,  1386,  1391,  1409,  1423,
    1435,  1444,  1464,  1473,  1474,  1477,  1478,  1481,  1485,  1489,
    1495,  1503,  1504,  1507,  1508,  1511,  1532,  1550,  1570,  1577,
    1580,  1581,  1584,  1584,  1629,  1630,  1631,  1632,  1635,  1653,
    1671,  1689,  1695,  1698,  1699,  1698,  1733,  1733,  1765,  1766,
    1767,  1768,  1769,  1772,  1773,  1783,  1784,  1794,  1795,  1796,
    1799,  1800,  1801,  1802,  1805,  1808,  1815,  1819,  1830,  1843,
    1853,  1860,  1863,  1866,  1877,  1893,  1901,  1909,  1931,  1934,
    1937,  1940,  1943,  1956,  2004,  2007,  2026,  2029,  2032,  2035,
    2041,  2047,  2062,  2070,  2078,  2096,  2112,  2122,  2215,  2218,
    2225,  2237,  2238,  2248,  2264,  2276,  2300,  2306,  2317,  2323,
    2326,  2341,  2342,  2352,  2353,  2356,  2357,  2358,  2359,  2362,
    2363,  2366,  2367,  2370,  2373,  2406,  2433,  2434,  2435,  2438,
    2439,  2442,  2443,  2446,  2447,  2448,  2450,  2451,  2457,  2479,
    2480,  2483,  2484,  2490,  2497,  2517,  2524,  2545,  2551,  2559,
    2574,  2589,  2590,  2593,  2594,  2595,  2607,  2608,  2614,  2629,
    2630,  2633,  2634,  2646,  2650,  2657,  2680,  2681,  2682,  2695,
    2696,  2702,  2710,  2716,  2724,  2738,  2741,  2741,  2749,  2750,
    2753,  2766,  2773,  2785,  2797,  2815,  2837,  2856,  2872,  2884,
    2896,  2904,  2911,  2960,  2980,  2988,  2998,  2999,  3005,  3016,
    3059,  3075,  3076,  3077,  3078,  3081,  3082,  3089,  3092,  3097,
    3106,  3107,  3110,  3111,  3114,  3115,  3118,  3119,  3122,  3137,
    3147,  3157,  3172,  3182,  3192,  3207,  3217,  3227,  3242,  3252,
    3262,  3269,  3274,  3279,  3284,  3289,  3299,  3309,  3314,  3341,
    3355,  3383,  3401,  3417,  3425,  3440,  3455,  3470,  3471,  3474,
    3475,  3476,  3477,  3480,  3481,  3482,  3483,  3484,  3485,  3488,
    3489,  3492,  3493
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "AS", "ROUTERID",
  "HOLDTIME", "YMIN", "LISTEN", "ON", "FIBUPDATE", "FIBPRIORITY", "RTABLE",
  "NONE", "UNICAST", "VPN", "RD", "EXPORT", "EXPORTTRGT", "IMPORTTRGT",
  "DEFAULTROUTE", "RDE", "RIB", "EVALUATE", "IGNORE", "COMPARE", "RTR",
  "PORT", "MINVERSION", "GROUP", "NEIGHBOR", "NETWORK", "EBGP", "IBGP",
  "FLOWSPEC", "PROTO", "FLAGS", "FRAGMENT", "TOS", "LENGTH", "ICMPTYPE",
  "CODE", "LOCALAS", "REMOTEAS", "DESCR", "LOCALADDR", "MULTIHOP",
  "PASSIVE", "MAXPREFIX", "RESTART", "ANNOUNCE", "REFRESH", "AS4BYTE",
  "CONNECTRETRY", "ENHANCED", "ADDPATH", "SEND", "RECV", "PLUS", "POLICY",
  "ROLE", "DEMOTE", "ENFORCE", "NEIGHBORAS", "ASOVERRIDE", "REFLECTOR",
  "DEPEND", "DOWN", "DUMP", "IN", "OUT", "SOCKET", "RESTRICTED", "LOG",
  "TRANSPARENT", "FILTERED", "TCP", "MD5SIG", "PASSWORD", "KEY",
  "TTLSECURITY", "ALLOW", "DENY", "MATCH", "QUICK", "FROM", "TO", "ANY",
  "CONNECTED", "STATIC", "COMMUNITY", "EXTCOMMUNITY", "LARGECOMMUNITY",
  "DELETE", "MAXCOMMUNITIES", "MAXEXTCOMMUNITIES", "MAXLARGECOMMUNITIES",
  "PREFIX", "PREFIXLEN", "PREFIXSET", "ASPASET", "ROASET", "ORIGINSET",
  "OVS", "AVS", "EXPIRES", "ASSET", "SOURCEAS", "TRANSITAS", "PEERAS",
  "PROVIDERAS", "CUSTOMERAS", "MAXASLEN", "MAXASSEQ", "SET", "LOCALPREF",
  "MED", "METRIC", "NEXTHOP", "REJECT", "BLACKHOLE", "NOMODIFY", "SELF",
  "PREPEND_SELF", "PREPEND_PEER", "PFTABLE", "WEIGHT", "RTLABEL", "ORIGIN",
  "PRIORITY", "ERROR", "INCLUDE", "IPSEC", "ESP", "AH", "SPI", "IKE",
  "IPV4", "IPV6", "QUALIFY", "VIA", "NE", "LE", "GE", "XRANGE", "LONGER",
  "MAXLEN", "MAX", "STRING", "NUMBER", "'\\n'", "'='", "'{'", "'}'", "'/'",
  "'+'", "'-'", "','", "'<'", "'>'", "$accept", "grammar", "asnumber",
  "as4number", "as4number_any", "string", "yesno", "varset", "include",
  "as_set", "$@1", "as_set_l", "prefixset", "$@2", "prefixset_l",
  "prefixset_item", "roa_set", "$@3", "origin_set", "$@4", "expires",
  "roa_set_l", "aspa_set", "aspa_set_l", "aspa_elm", "aspa_tas_l",
  "aspa_tas", "rtr", "$@5", "rtropt_l", "rtropt", "conf_main", "rib",
  "$@6", "ribopts", "fibupdate", "mrtdump", "network", "flowspec", "$@7",
  "proto", "proto_list", "proto_item", "from", "$@8", "to", "$@9",
  "ipportspec", "ipspec", "portspec", "port_list", "port_item", "port",
  "flow_rules", "flow_rules_l", "flowrule", "$@10", "$@11", "flags",
  "flag", "icmpspec", "icmp_list", "icmp_item", "icmptype", "tos",
  "lengthspec", "length_list", "length_item", "length", "inout",
  "restricted", "address", "prefix", "addrspec", "optnumber", "l3vpn",
  "$@12", "l3vpnopts_l", "l3vpnopts", "neighbor", "$@13", "$@14", "group",
  "$@15", "groupopts_l", "addpathextra", "addpathmax", "peeropts_h",
  "peeropts_l", "peeropts", "restart", "af", "safi", "nettype", "espah",
  "encspec", "filterrule", "action", "quick", "direction", "filter_rib_h",
  "filter_rib_l", "filter_rib", "filter_peer_h", "filter_peer_l",
  "filter_peer", "filter_prefix_h", "filter_prefix_m", "filter_prefix_l",
  "filter_prefix", "filter_as_h", "filter_as_t_l", "filter_as_t",
  "filter_as_l_h", "filter_as_l", "filter_as", "filter_match_h", "$@16",
  "filter_match", "filter_elm", "prefixlenop", "filter_as_type",
  "filter_set", "filter_set_l", "community", "delete", "enforce",
  "yesnoenforce", "filter_set_opt", "origincode", "validity",
  "aspa_validity", "optnl", "comma", "unaryop", "equalityop", "binaryop", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-572)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-400)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
    -572,   712,  -572,   -98,   -72,   -74,    23,    82,   -43,   -25,
      -5,    65,    90,   -74,    73,   -12,    81,    53,    31,    98,
     102,   -43,  -572,  -572,  -572,   105,   -18,   116,   127,   130,
     142,   181,   149,   139,  -572,   161,   169,   171,   183,   189,
     197,   211,   217,   230,   239,   250,   259,   261,   266,   268,
     313,   284,   290,   320,  -572,  -572,  -572,  -572,   317,  -572,
    -572,   339,  -572,   -74,  -572,  -572,  -572,  -572,   445,   321,
     341,   465,    84,   340,  -572,   343,   346,  -572,  -572,   342,
     347,   386,     0,  -572,  -572,   354,    47,   432,  -572,  -572,
     353,   356,   356,   355,   357,   368,   -43,  -572,    73,  -572,
    -572,  -572,  -572,  -572,  -572,  -572,  -572,  -572,  -572,  -572,
    -572,  -572,  -572,  -572,   166,  -572,  -572,  -572,   489,  -572,
    -572,   485,   365,   390,  -572,   369,  -572,  -572,   374,  -572,
     375,   386,   379,   380,   304,  -572,  -572,  -572,   382,   383,
     386,   222,   385,  -572,  -572,   393,   396,  -572,  -572,   356,
     356,   -60,   378,   356,   356,   397,  -572,   343,   342,  -572,
    -572,  -572,    89,   260,   243,  -572,   459,    21,  -572,   356,
    -572,  -572,  -572,  -572,  -572,  -572,   453,  -572,    54,   100,
     118,   144,   398,   399,   401,   154,   402,   414,   356,   453,
    -572,   386,   386,  -572,   186,  -572,  -572,   254,   256,   236,
    -572,  -572,  -572,  -572,  -572,   386,   222,  -572,  -572,   416,
    -572,  -572,   393,   403,  -572,   -72,  -572,   -47,  -572,  -572,
     275,   410,   412,  -572,   418,  -572,   356,  -572,  -572,  -572,
      46,  -572,  -572,  -572,   419,  -572,   -43,   423,   545,  -572,
    -572,   255,   493,  -572,   -56,  -572,   425,   427,  -572,   428,
     429,  -572,   430,   431,  -572,  -572,  -572,  -572,  -572,  -572,
    -572,  -572,  -572,   433,   434,  -572,  -572,  -572,   822,   436,
    -572,  -572,  -572,  -572,   356,  -572,   -16,   -16,  -572,  -572,
    -572,  -572,  -572,  -572,  -572,  -572,   356,  -572,  -572,  -572,
    -572,   -33,   437,  -572,  -572,   356,  -572,   534,     7,     7,
    -572,  -572,   393,  -572,  -572,   275,   476,   356,   435,   438,
     478,   480,   163,   -49,  -572,   275,  -572,   277,   811,  -572,
     442,   -72,   444,  -572,  -572,  -572,   356,  -572,   -30,  -572,
    -572,  -572,   583,  -572,   243,   446,   449,   -74,   356,  -572,
     448,    25,   122,   571,   451,   243,   -72,   -72,    73,   -74,
     452,  -572,   454,   193,    22,   456,    39,   -43,   -74,   591,
     457,   458,   460,   -43,   525,   -43,   777,   503,   305,  -572,
    -572,   565,  -572,   461,   463,   467,   468,  -572,  -572,  -572,
    -572,  -572,  -572,  -572,  -572,   163,  -572,  -572,   300,  -572,
    -572,   469,  -572,   464,  -572,   316,  -572,  -572,   437,  -572,
     324,   332,   223,  -572,  -572,   594,  -572,  -572,  -572,   163,
    -572,   473,   513,   474,   356,  -572,  -572,   277,   475,   275,
     319,  -572,   477,  -572,   163,  -572,  -572,  -572,   163,  -572,
     479,   138,  -572,  -572,  -572,    66,   386,    55,    27,  -572,
    -572,  -572,  -572,  -572,    12,  -572,   481,  -572,  -572,  -572,
     483,  -572,  -572,   317,  -572,   343,  -572,  -572,    34,   -20,
     -20,   -20,   578,   426,   -20,   257,  -572,  -572,  -572,   -43,
     -43,  -572,  -572,   486,  -572,   415,  -572,  -572,   408,  -572,
     356,  -572,   -43,  -572,  -572,    52,  -572,  -572,  -572,  -572,
    -572,   484,   822,   163,  -572,  -572,   469,   163,  -572,  -572,
     163,  -572,  -572,  -572,   356,  -572,  -572,   -33,   243,   223,
     491,   275,  -572,   490,  -572,   476,  -572,   529,   -33,   498,
    -572,   495,   496,   277,   618,  -572,   497,   442,   163,  -572,
    -572,  -572,   -42,   502,   504,   505,   238,   507,   508,   509,
     510,  -572,  -572,  -572,   518,   520,    18,   -49,   -49,    76,
    -572,  -572,  -572,    55,  -572,   128,   511,   488,   -43,   522,
     523,   524,  -572,  -572,  -572,   526,  -572,  -572,  -572,  -572,
    -572,   528,   603,  -572,  -572,  -572,  -572,  -572,  -572,   -20,
     527,   -20,  -572,  -572,  -572,  -572,  -572,   611,  -572,  -572,
    -572,    73,    73,   822,  -572,  -572,   539,  -572,  -572,   535,
     300,  -572,   536,   316,   537,   324,   294,   243,  -572,  -572,
    -572,  -572,   356,  -572,   277,   538,  -572,  -572,  -572,  -572,
     543,  -572,  -572,   546,  -572,  -572,   542,    66,   549,   551,
    -572,  -572,  -572,   298,   -49,  -572,   -49,  -572,  -572,  -572,
    -572,  -572,  -572,  -572,  -572,  -572,  -572,  -572,   179,  -572,
    -572,  -572,   552,  -572,  -572,   153,   -33,  -572,   277,  -572,
    -572,  -572,  -572,   553,   554,  -572,  -572,  -572,  -572,   645,
    -572,  -572,  -572,   343,   343,   163,   555,  -572,  -572,  -572,
    -572,  -572,  -572,   163,  -572,  -572,   277,   476,  -572,  -572,
    -572,  -572,  -572,  -572,  -572,   275,   556,   203,  -572,  -572,
    -572,   356,  -572,    76,  -572,   177,   557,   205,  -572,   277,
    -572,  -572,  -572,   558,   561,   559,   567,   566,   294,    81,
     163,  -572,  -572,   220,  -572,   275,  -572,  -572,   226,  -572,
     177,  -572,  -572,   572,   611,  -572,   577,  -572,  -572,  -572,
     573,   277,   298,  -572,   153,  -572,  -572,  -572,   581,  -572,
    -572,  -572,  -572,   582,  -572,  -572
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       2,     0,     1,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   276,   277,   278,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     3,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   279,    21,    23,    22,    24,    71,   175,
      73,     0,    74,     0,    29,    79,    78,    91,     0,     0,
       0,     0,     0,    62,    28,   196,     0,   263,   264,     0,
       0,   355,     0,   107,    92,     0,     0,   173,    82,    80,
       0,   397,   397,     0,     0,     0,     0,    31,     0,     4,
       5,     6,     7,     8,    10,     9,    11,    16,    12,    15,
      13,    14,    17,    18,     0,    19,    20,   280,   283,    72,
      75,    76,     0,    94,    88,     0,    85,    86,     0,    27,
       0,   355,     0,     0,     0,   102,   270,   269,     0,     0,
     355,   133,     0,   171,   172,   180,     0,   174,    93,   397,
     397,     0,    43,   397,   397,     0,    81,    30,   175,   178,
     179,   194,     0,     0,     0,   182,     0,    99,    87,   397,
     198,   103,   176,   177,   387,   360,   362,   361,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   397,   362,
     356,   355,   355,   106,     0,   139,   141,     0,     0,     0,
     115,   117,   145,   137,   138,   355,   134,   135,   143,     0,
     181,    83,   180,    37,   398,     0,    54,   397,    55,    45,
       0,    46,    32,    90,   209,   288,   397,   284,   281,   282,
       0,   132,   131,    77,     0,    89,     0,     0,     0,    95,
      96,     0,     0,   363,     0,   368,     0,     0,   371,     0,
       0,   374,     0,     0,   382,   381,   383,   384,   380,   385,
     386,   388,   377,     0,     0,   389,   394,   393,     0,     0,
     104,   105,   113,   114,   397,   109,     0,     0,   161,   162,
     146,   404,   405,   407,   170,   403,   397,   406,   408,   144,
     163,   167,     0,   159,   160,   397,   152,   156,     0,     0,
     108,   136,   180,   101,    39,     0,    49,   397,   400,     0,
       0,     0,   399,   346,    48,     0,    34,     0,     0,   195,
       0,     0,     0,   297,   298,   293,   397,   294,   326,   289,
     184,   100,    99,    98,     0,     0,     0,     0,   397,    65,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   221,     0,     0,     0,     0,     0,     0,   252,     0,
     222,     0,     0,     0,     0,     0,     0,     0,     0,   199,
     197,     0,   251,     0,     0,     0,     0,   369,   370,   372,
     373,   375,   376,   378,   379,   399,   359,   390,     0,   150,
     151,     0,   140,   149,   142,     0,   412,   411,     0,   168,
       0,     0,     0,   122,   116,   119,   123,   118,    84,   399,
      40,     0,     0,   401,   397,    53,    56,     0,     0,     0,
       0,   347,     0,    42,   399,    25,    26,    35,   399,   210,
       0,   397,   286,   295,   296,     0,   355,     0,     0,    97,
      69,    70,    67,    68,     0,   202,     0,   225,   237,   238,
       0,   224,   259,   215,   214,   217,   218,   220,   261,     0,
       0,     0,     0,     0,     0,     0,   236,   235,   255,     0,
       0,   241,   253,     0,   223,     0,   257,   256,     0,   248,
     397,   249,     0,   271,   272,     0,   219,   201,   200,   392,
     391,     0,     0,   399,   111,   148,     0,   399,   165,   169,
     399,   154,   157,   158,   397,   121,   124,   128,     0,     0,
       0,     0,    50,     0,   402,    49,    44,     0,     0,     0,
     348,     0,     0,     0,     0,   208,     0,     0,   399,   291,
     275,   351,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   352,   353,   354,     0,     0,     0,   346,   346,     0,
     330,   331,   309,   327,   328,     0,     0,     0,     0,     0,
       0,     0,   185,   183,   192,     0,    64,    66,   226,   260,
     216,     0,   261,   242,   367,   366,   230,   228,   231,     0,
       0,     0,   234,   265,   266,   267,   268,   364,   240,   239,
     254,     0,     0,     0,   258,   246,     0,   357,   358,     0,
       0,   147,     0,     0,     0,     0,     0,     0,   129,   120,
      38,    41,   397,    51,     0,     0,   349,    47,    33,    36,
       0,   211,   207,     0,   285,   287,     0,     0,     0,     0,
     337,   338,   339,     0,   346,   301,   346,   343,   395,   344,
     396,   345,   332,   333,   341,   340,   299,   300,   399,   311,
     329,   322,     0,   410,   409,     0,   321,   313,     0,   334,
     187,   191,   188,     0,     0,   186,   262,   243,   229,   203,
     232,   365,   227,   244,   245,   399,     0,   110,   112,   164,
     166,   153,   155,   399,   126,   130,     0,    49,   350,   213,
     212,   290,   292,   336,   335,     0,     0,   399,   306,   308,
     342,   397,   310,     0,   315,     0,     0,   399,   319,     0,
     323,   189,   190,     0,   205,     0,     0,     0,     0,    60,
     399,    58,    52,   399,   302,     0,   401,   312,   399,   314,
       0,   324,   204,     0,   364,   250,     0,   125,   127,    61,
       0,     0,   304,   307,   317,   320,   206,   233,   273,    57,
      59,   305,   318,     0,   247,   274
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -572,  -572,     1,  -147,  -309,   -95,    -7,  -572,  -572,  -572,
    -572,  -572,  -572,  -572,  -572,  -280,  -572,  -572,  -572,  -572,
    -492,   389,  -572,  -572,   420,  -572,    -8,  -572,  -572,  -572,
     291,  -572,  -572,  -572,  -572,   406,   733,   301,  -572,  -572,
    -572,  -572,  -375,  -572,  -572,  -572,  -572,   447,  -572,   234,
    -572,  -571,  -157,  -572,  -572,   541,  -572,  -572,   471,  -307,
    -572,  -572,  -384,  -572,  -572,  -572,  -572,  -376,  -228,   265,
    -572,     4,   -15,  -572,  -172,  -572,  -572,  -572,  -572,   512,
    -572,  -572,  -572,  -572,  -572,  -572,  -572,  -572,  -572,  -294,
     172,   -14,  -572,  -572,  -572,  -572,  -572,  -572,  -572,  -572,
    -572,  -572,  -305,  -572,  -572,  -417,  -572,     9,    57,  -514,
    -572,  -572,  -522,    11,    48,  -534,  -572,  -572,  -572,   204,
    -494,  -572,  -120,   165,  -394,   570,    26,  -347,  -124,  -572,
    -572,  -572,   -88,  -205,  -192,  -572,  -481
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,     1,   426,    58,   656,    75,   575,    35,    36,    37,
     317,   428,    38,   305,   409,   311,    39,   220,    40,   315,
     412,   312,    41,   217,   218,   720,   721,    42,   128,   338,
     339,    43,    44,   167,   239,   240,   372,    46,    47,   141,
     202,   493,   275,   203,   298,   204,   299,   404,   405,   505,
     683,   506,   507,   205,   206,   207,   276,   277,   392,   393,
     208,   500,   296,   297,   280,   289,   497,   290,   291,   146,
     148,   327,   313,   161,   211,    48,   234,   438,   565,    49,
      50,   224,    51,   130,   242,   714,   734,   319,   524,   374,
     573,    82,   587,   140,   485,   754,    52,    53,   118,   230,
     163,   431,   227,   328,   528,   329,   550,   696,   697,   698,
     551,   648,   552,   706,   707,   708,   436,   437,   553,   554,
     423,   555,   135,   385,   189,   244,   672,   576,   386,   267,
     639,   641,   151,   419,   508,   658,   398
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      81,    65,    83,   157,   152,    57,   292,   233,   427,    60,
     190,   171,   310,   494,    89,   432,   501,    73,   529,   498,
     193,   657,   635,   613,   430,   410,   607,   649,   557,    61,
     236,   446,   237,   402,   466,   684,   558,   615,   334,   335,
     303,   574,   559,   556,   560,   561,   375,   644,   420,   321,
     215,    54,    85,   646,   647,   336,   337,    15,   531,   119,
     628,   213,   214,  -399,   399,   221,   222,   121,   306,   321,
     389,   270,   271,    59,   322,    55,    56,   323,   324,   531,
     469,   241,   571,  -325,   495,   300,    76,   136,   137,   156,
      63,   376,   216,   403,   322,   421,   422,   323,   324,   160,
     268,   470,   307,   572,    64,   629,   126,   127,   515,   308,
     396,    69,    70,   577,   578,   143,   144,   582,   159,  -325,
     143,   144,   397,    66,    77,    78,   138,    64,   139,   309,
     408,   390,   325,    91,   448,    79,    80,   391,   320,   517,
     699,   449,   700,    67,   175,   532,   177,   738,   533,   534,
     535,   536,   325,   537,    79,    80,   538,   539,   540,   556,
     238,   541,   542,   543,   566,    59,   544,   545,    64,   467,
     499,    62,   546,   447,   433,   709,   562,   440,    86,   563,
     492,   727,   541,   542,   543,   258,   388,   595,   452,   601,
     651,   547,   548,    59,   145,   722,   745,   326,   395,   453,
     454,    84,   245,   292,   511,    71,   549,   400,   246,   247,
     692,   743,    68,    59,   619,   651,    57,    77,    78,   413,
      74,   682,   625,   523,   418,   678,   527,   680,   519,   331,
     623,   611,   668,   652,   670,   371,   225,    72,   435,   651,
     226,   459,   481,   460,   461,    87,   462,   463,   248,    88,
     444,   464,    90,   455,   249,   250,   194,   195,   196,   197,
     198,   199,   254,   255,   256,   257,   251,    92,   653,   583,
     584,   585,   252,   253,    93,   425,    56,    94,   654,   655,
      95,   334,   335,   406,   406,  -399,    96,   307,   600,    98,
     586,    59,   603,   653,   308,   605,    97,   491,   336,   337,
     425,    56,   262,   654,   705,   687,   200,   201,   263,   264,
      99,   371,   307,   158,    80,  -397,   530,   653,   100,   308,
     101,   510,    57,   627,   425,    56,   514,   654,   701,    77,
      78,   702,   102,   272,   273,   308,   521,   274,   103,   465,
     522,   443,   114,   526,   228,   229,   104,    57,    57,   710,
     471,   608,   701,   456,   701,  -303,   477,  -316,   479,   308,
     105,   308,   472,   281,   282,   283,   106,   174,   598,   701,
     231,   232,   742,   285,   504,   701,   308,   719,   744,   107,
     287,   288,   308,   293,   294,    79,    80,   295,   108,   633,
     231,   232,   593,   175,   176,   177,   281,   282,   283,   109,
     731,   278,   279,   117,   284,   599,   285,   286,   110,   602,
     111,   292,   604,   287,   288,   112,   606,   113,   178,   179,
     180,   181,    79,    80,   425,    56,   182,   183,   184,   185,
     186,   187,   719,   115,   281,   282,   283,   483,   484,   116,
     626,   231,   232,   703,   285,    79,    80,   272,   273,   695,
     685,   287,   288,   122,   570,   188,   281,   282,   283,   281,
     282,   283,   588,   589,   284,    56,   285,   518,   123,   285,
     492,   293,   294,   287,   288,   594,   287,   288,   718,   502,
     503,   580,   581,   143,   144,   591,   592,   120,   124,   125,
     129,   -63,   725,   131,   340,   132,   673,   674,   341,   134,
     133,   142,   730,   147,   149,   150,   153,   155,   154,   342,
     162,   164,   165,   343,   344,   741,   168,   371,   725,   345,
     166,   634,  -193,   730,   686,   169,   170,   172,   173,   191,
     219,   192,   209,   235,   346,   347,   348,   349,   350,   351,
     352,   210,   353,   212,   223,   243,   259,   260,   261,   265,
     645,   661,   354,   355,   356,   304,   357,   358,   359,   360,
     361,   266,   314,   302,   316,   362,   363,   333,   364,   318,
     330,   332,   365,   377,   401,   378,   379,   380,   381,   382,
     411,   383,   384,   387,   414,   284,   417,   715,   215,   225,
     415,   434,   236,   450,   441,   717,   442,   445,   451,   473,
     457,   478,   458,   468,   474,   475,   366,   476,   482,   486,
     487,   367,   488,   726,   489,   490,   390,   496,   634,   620,
     509,   512,   513,   341,   368,   520,  -398,   516,   579,   568,
     569,   525,   740,   590,   342,   614,   597,   660,   343,   344,
      64,   612,   369,   610,   345,   370,   616,   617,   618,   624,
     630,   571,   631,   632,   636,   637,   638,   640,   659,   346,
     347,   348,   349,   350,   351,   352,   642,   353,   643,   662,
     663,   664,   671,   676,   669,   665,   666,   354,   355,   356,
     634,   357,   358,   359,   360,   361,   688,   677,   679,   681,
     362,   363,   689,   364,   691,   690,   693,   365,   694,   704,
     711,   712,   713,   716,   424,   739,   732,   733,   724,   729,
     634,   735,     2,     3,   736,     4,     5,     6,   737,     7,
     746,     8,     9,    10,   748,   749,    11,   634,   753,   755,
     416,   366,    12,   750,    45,   567,   367,    13,   439,   564,
      14,  -193,    15,   609,   667,    16,   407,   301,   394,   368,
     596,   751,   723,   728,   373,   752,     0,   650,   675,   269,
     747,     0,     0,     0,    17,    64,     0,   621,     0,     0,
     622,     0,     0,     0,     0,     0,     0,     0,     0,    18,
       0,     0,    19,     0,    20,    21,     0,     0,     0,     0,
       0,     0,    22,    23,    24,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      25,    26,    27,    28,     0,     0,   341,    29,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   342,     0,    30,
      31,   343,   344,     0,     0,     0,     0,   345,     0,     0,
     174,     0,    32,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   346,   347,   348,   349,   350,   351,   352,    33,
     353,    34,     0,     0,     0,     0,   175,   176,   177,     0,
     354,   355,   356,     0,   357,   358,   359,   360,   361,     0,
       0,     0,     0,   362,   363,   174,   364,     0,     0,     0,
     365,   178,   179,   180,   181,     0,     0,     0,     0,   182,
     183,   184,   185,   186,   187,     0,     0,     0,     0,     0,
       0,   175,   176,   177,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   366,     0,     0,     0,   480,   367,
       0,     0,     0,     0,     0,     0,   178,   179,   180,   181,
       0,     0,   368,     0,   182,   183,   184,   185,   186,   187,
       0,     0,     0,     0,     0,     0,     0,     0,    64,     0,
     429
};

static const yytype_int16 yycheck[] =
{
      15,     8,    16,    98,    92,     4,   198,   164,   317,     5,
     134,   131,   217,   388,    21,   320,   400,    13,   435,   395,
     140,   555,   536,   515,   318,   305,   507,   549,     1,     6,
       9,     6,    11,    26,    12,   606,     9,   518,    26,    27,
     212,    61,    15,   437,    17,    18,   102,    29,    97,     3,
     110,   149,    21,   547,   548,    43,    44,    30,     3,    58,
     102,   149,   150,   110,   292,   153,   154,    63,   215,     3,
      86,   191,   192,   147,    28,   147,   148,    31,    32,     3,
      41,   169,    48,   113,   391,   205,    98,    87,    88,    96,
       8,   147,   152,    86,    28,   144,   145,    31,    32,   114,
     188,    62,   149,    69,   147,   147,    22,    23,   417,   156,
     143,    21,    22,   460,   461,    68,    69,   464,   114,   149,
      68,    69,   155,   148,   136,   137,   126,   147,   128,   217,
     302,   147,    86,   151,    12,   147,   148,   153,   226,   419,
     634,    19,   636,   148,    89,    90,    91,   718,    93,    94,
      95,    96,    86,    98,   147,   148,   101,   102,   103,   553,
     167,   106,   107,   108,   152,   147,   111,   112,   147,   147,
     398,   148,   117,   148,   321,   656,   149,   334,   147,   152,
     385,   703,   106,   107,   108,   181,   274,   135,   345,   496,
      62,   136,   137,   147,   147,   687,   730,   151,   286,   346,
     347,   148,   148,   395,   409,   115,   151,   295,   154,   155,
     627,   725,   147,   147,   523,    62,   215,   136,   137,   307,
     147,   605,   527,   428,   312,   600,   431,   603,   420,   236,
     524,   511,   579,   105,   581,   242,   147,   147,   326,    62,
     151,    48,   366,    50,    51,   147,    53,    54,   148,   147,
     338,    58,   147,   348,   154,   155,    34,    35,    36,    37,
      38,    39,   118,   119,   120,   121,   148,   151,   140,    12,
      13,    14,   154,   155,   147,   147,   148,   147,   150,   151,
     138,    26,    27,   298,   299,   147,   105,   149,   493,   150,
      33,   147,   497,   140,   156,   500,   147,   385,    43,    44,
     147,   148,   148,   150,   151,   614,    84,    85,   154,   155,
     149,   318,   149,   147,   148,   152,   436,   140,   149,   156,
     149,   409,   321,   528,   147,   148,   414,   150,   149,   136,
     137,   152,   149,   147,   148,   156,   424,   151,   149,   353,
     428,   337,    29,   431,    84,    85,   149,   346,   347,   658,
     357,   508,   149,   349,   149,   152,   363,   152,   365,   156,
     149,   156,   358,   140,   141,   142,   149,    63,   492,   149,
     147,   148,   152,   150,   151,   149,   156,   686,   152,   149,
     157,   158,   156,   147,   148,   147,   148,   151,   149,   151,
     147,   148,   480,    89,    90,    91,   140,   141,   142,   149,
     709,   147,   148,    83,   148,   493,   150,   151,   149,   497,
     149,   603,   500,   157,   158,   149,   504,   149,   114,   115,
     116,   117,   147,   148,   147,   148,   122,   123,   124,   125,
     126,   127,   741,   149,   140,   141,   142,   132,   133,   149,
     528,   147,   148,   648,   150,   147,   148,   147,   148,   151,
     607,   157,   158,     8,   453,   151,   140,   141,   142,   140,
     141,   142,   469,   470,   148,   148,   150,   148,   147,   150,
     675,   147,   148,   157,   158,   482,   157,   158,   683,   147,
     148,    55,    56,    68,    69,    77,    78,   148,   147,    24,
     147,   151,   697,   147,     1,   153,   591,   592,     5,   113,
     153,   147,   707,    71,   151,   149,   151,   139,   151,    16,
      21,    26,   147,    20,    21,   720,   147,   524,   723,    26,
     130,   536,    29,   728,   612,   151,   151,   148,   148,   147,
     152,   148,   147,    74,    41,    42,    43,    44,    45,    46,
      47,   148,    49,   147,   147,    92,   148,   148,   147,   147,
     546,   558,    59,    60,    61,   152,    63,    64,    65,    66,
      67,   147,   152,   147,   152,    72,    73,    22,    75,   151,
     151,   148,    79,   148,    40,   148,   148,   148,   148,   148,
     104,   148,   148,   147,   149,   148,   106,   675,   110,   147,
     152,   147,     9,    22,   148,   683,   147,   149,   147,     8,
     148,    76,   148,   147,   147,   147,   113,   147,   105,    44,
     149,   118,   149,   701,   147,   147,   147,   153,   633,     1,
      26,   148,   109,     5,   131,   148,   152,   152,    50,   148,
     147,   152,   720,   147,    16,   106,   152,   149,    20,    21,
     147,   151,   149,   152,    26,   152,   148,   152,   152,   152,
     148,    48,   148,   148,   147,   147,   147,   147,   147,    41,
      42,    43,    44,    45,    46,    47,   148,    49,   148,   147,
     147,   147,    61,   134,   147,   149,   148,    59,    60,    61,
     695,    63,    64,    65,    66,    67,   148,   152,   152,   152,
      72,    73,   149,    75,   152,   149,   147,    79,   147,   147,
     147,   147,    57,   148,   315,   719,   148,   146,   152,   152,
     725,   152,     0,     1,   147,     3,     4,     5,   152,     7,
     148,     9,    10,    11,   147,   152,    14,   742,   147,   147,
     310,   113,    20,   741,     1,   444,   118,    25,   332,   438,
      28,    29,    30,   509,   572,    33,   299,   206,   277,   131,
     485,   742,   695,   705,   242,   744,    -1,   553,   593,   189,
     734,    -1,    -1,    -1,    52,   147,    -1,   149,    -1,    -1,
     152,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    67,
      -1,    -1,    70,    -1,    72,    73,    -1,    -1,    -1,    -1,
      -1,    -1,    80,    81,    82,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    99,   100,   101,    -1,    -1,     5,   105,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    16,    -1,   117,
     118,    20,    21,    -1,    -1,    -1,    -1,    26,    -1,    -1,
      63,    -1,   130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    41,    42,    43,    44,    45,    46,    47,   147,
      49,   149,    -1,    -1,    -1,    -1,    89,    90,    91,    -1,
      59,    60,    61,    -1,    63,    64,    65,    66,    67,    -1,
      -1,    -1,    -1,    72,    73,    63,    75,    -1,    -1,    -1,
      79,   114,   115,   116,   117,    -1,    -1,    -1,    -1,   122,
     123,   124,   125,   126,   127,    -1,    -1,    -1,    -1,    -1,
      -1,    89,    90,    91,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   113,    -1,    -1,    -1,   151,   118,
      -1,    -1,    -1,    -1,    -1,    -1,   114,   115,   116,   117,
      -1,    -1,   131,    -1,   122,   123,   124,   125,   126,   127,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   147,    -1,
     149
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int16 yystos[] =
{
       0,   160,     0,     1,     3,     4,     5,     7,     9,    10,
      11,    14,    20,    25,    28,    30,    33,    52,    67,    70,
      72,    73,    80,    81,    82,    98,    99,   100,   101,   105,
     117,   118,   130,   147,   149,   166,   167,   168,   171,   175,
     177,   181,   186,   190,   191,   195,   196,   197,   234,   238,
     239,   241,   255,   256,   149,   147,   148,   161,   162,   147,
     230,     6,   148,     8,   147,   165,   148,   148,   147,    21,
      22,   115,   147,   230,   147,   164,    98,   136,   137,   147,
     148,   231,   250,   250,   148,    21,   147,   147,   147,   165,
     147,   151,   151,   147,   147,   138,   105,   147,   150,   149,
     149,   149,   149,   149,   149,   149,   149,   149,   149,   149,
     149,   149,   149,   149,    29,   149,   149,    83,   257,   161,
     148,   230,     8,   147,   147,    24,    22,    23,   187,   147,
     242,   147,   153,   153,   113,   281,    87,    88,   126,   128,
     252,   198,   147,    68,    69,   147,   228,    71,   229,   151,
     149,   291,   291,   151,   151,   139,   165,   164,   147,   230,
     231,   232,    21,   259,    26,   147,   130,   192,   147,   151,
     151,   281,   148,   148,    63,    89,    90,    91,   114,   115,
     116,   117,   122,   123,   124,   125,   126,   127,   151,   283,
     287,   147,   148,   281,    34,    35,    36,    37,    38,    39,
      84,    85,   199,   202,   204,   212,   213,   214,   219,   147,
     148,   233,   147,   291,   291,   110,   152,   182,   183,   152,
     176,   291,   291,   147,   240,   147,   151,   261,    84,    85,
     258,   147,   148,   211,   235,    74,     9,    11,   165,   193,
     194,   291,   243,    92,   284,   148,   154,   155,   148,   154,
     155,   148,   154,   155,   118,   119,   120,   121,   230,   148,
     148,   147,   148,   154,   155,   147,   147,   288,   291,   284,
     281,   281,   147,   148,   151,   201,   215,   216,   147,   148,
     223,   140,   141,   142,   148,   150,   151,   157,   158,   224,
     226,   227,   293,   147,   148,   151,   221,   222,   203,   205,
     281,   214,   147,   233,   152,   172,   162,   149,   156,   291,
     292,   174,   180,   231,   152,   178,   152,   169,   151,   246,
     291,     3,    28,    31,    32,    86,   151,   230,   262,   264,
     151,   165,   148,    22,    26,    27,    43,    44,   188,   189,
       1,     5,    16,    20,    21,    26,    41,    42,    43,    44,
      45,    46,    47,    49,    59,    60,    61,    63,    64,    65,
      66,    67,    72,    73,    75,    79,   113,   118,   131,   149,
     152,   165,   195,   238,   248,   102,   147,   148,   148,   148,
     148,   148,   148,   148,   148,   282,   287,   147,   291,    86,
     147,   153,   217,   218,   217,   291,   143,   155,   295,   227,
     291,    40,    26,    86,   206,   207,   231,   206,   233,   173,
     174,   104,   179,   291,   149,   152,   183,   106,   291,   292,
      97,   144,   145,   279,   180,   147,   161,   163,   170,   149,
     248,   260,   261,   162,   147,   291,   275,   276,   236,   194,
     211,   148,   147,   230,   291,   149,     6,   148,    12,    19,
      22,   147,   211,   162,   162,   164,   230,   148,   148,    48,
      50,    51,    53,    54,    58,   250,    12,   147,   147,    41,
      62,   165,   230,     8,   147,   147,   147,   165,    76,   165,
     151,   287,   105,   132,   133,   253,    44,   149,   149,   147,
     147,   291,   292,   200,   201,   218,   153,   225,   226,   227,
     220,   221,   147,   148,   151,   208,   210,   211,   293,    26,
     291,   292,   148,   109,   291,   163,   152,   174,   148,   293,
     148,   291,   291,   292,   247,   152,   291,   292,   263,   264,
     281,     3,    90,    93,    94,    95,    96,    98,   101,   102,
     103,   106,   107,   108,   111,   112,   117,   136,   137,   151,
     265,   269,   271,   277,   278,   280,   283,     1,     9,    15,
      17,    18,   149,   152,   196,   237,   152,   189,   148,   147,
     161,    48,    69,   249,    61,   165,   286,   286,   286,    50,
      55,    56,   286,    12,    13,    14,    33,   251,   165,   165,
     147,    77,    78,   291,   165,   135,   228,   152,   287,   291,
     292,   218,   291,   292,   291,   292,   291,   295,   211,   208,
     152,   174,   151,   179,   106,   295,   148,   152,   152,   163,
       1,   149,   152,   248,   152,   261,   291,   292,   102,   147,
     148,   148,   148,   151,   231,   268,   147,   147,   147,   289,
     147,   290,   148,   148,    29,   230,   279,   279,   270,   271,
     278,    62,   105,   140,   150,   151,   163,   274,   294,   147,
     149,   165,   147,   147,   147,   149,   148,   249,   286,   147,
     286,    61,   285,   164,   164,   282,   134,   152,   201,   152,
     226,   152,   221,   209,   210,   211,   291,   163,   148,   149,
     149,   152,   264,   147,   147,   151,   266,   267,   268,   279,
     279,   149,   152,   292,   147,   151,   272,   273,   274,   295,
     163,   147,   147,    57,   244,   291,   148,   291,   292,   163,
     184,   185,   179,   267,   152,   292,   291,   271,   273,   152,
     292,   163,   148,   146,   245,   152,   147,   152,   210,   250,
     291,   292,   152,   268,   152,   274,   148,   285,   147,   152,
     185,   266,   272,   147,   254,   147
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int16 yyr1[] =
{
       0,   159,   160,   160,   160,   160,   160,   160,   160,   160,
     160,   160,   160,   160,   160,   160,   160,   160,   160,   160,
     160,   160,   161,   162,   162,   163,   163,   164,   164,   165,
     166,   167,   169,   168,   168,   170,   170,   172,   171,   171,
     173,   173,   174,   176,   175,   175,   178,   177,   177,   179,
     179,   180,   180,   181,   181,   182,   182,   183,   184,   184,
     185,   185,   186,   187,   186,   188,   188,   189,   189,   189,
     189,   190,   190,   190,   190,   190,   190,   190,   190,   190,
     190,   190,   190,   190,   190,   190,   190,   190,   190,   190,
     190,   190,   190,   190,   192,   191,   193,   193,   193,   194,
     194,   195,   196,   196,   196,   196,   196,   198,   197,   199,
     199,   200,   200,   201,   201,   203,   202,   205,   204,   206,
     206,   206,   207,   207,   208,   208,   209,   209,   210,   210,
     210,   211,   211,   212,   212,   213,   213,   214,   214,   215,
     214,   216,   214,   214,   214,   214,   214,   217,   217,   217,
     217,   218,   219,   219,   220,   220,   221,   221,   221,   222,
     222,   223,   223,   224,   224,   225,   225,   226,   226,   226,
     227,   228,   228,   229,   229,   230,   231,   231,   232,   232,
     233,   233,   235,   234,   236,   236,   236,   236,   237,   237,
     237,   237,   237,   239,   240,   238,   242,   241,   243,   243,
     243,   243,   243,   244,   244,   245,   245,   246,   246,   246,
     247,   247,   247,   247,   248,   248,   248,   248,   248,   248,
     248,   248,   248,   248,   248,   248,   248,   248,   248,   248,
     248,   248,   248,   248,   248,   248,   248,   248,   248,   248,
     248,   248,   248,   248,   248,   248,   248,   248,   248,   248,
     248,   248,   248,   248,   248,   248,   248,   248,   248,   248,
     248,   249,   249,   250,   250,   251,   251,   251,   251,   252,
     252,   253,   253,   254,   254,   255,   256,   256,   256,   257,
     257,   258,   258,   259,   259,   259,   260,   260,   261,   262,
     262,   263,   263,   264,   264,   264,   264,   264,   264,   265,
     265,   265,   265,   266,   266,   266,   267,   267,   268,   269,
     269,   270,   270,   271,   271,   271,   272,   272,   272,   273,
     273,   274,   274,   274,   274,   275,   276,   275,   277,   277,
     278,   278,   278,   278,   278,   278,   278,   278,   278,   278,
     278,   278,   278,   278,   278,   278,   279,   279,   279,   279,
     279,   280,   280,   280,   280,   281,   281,   281,   282,   282,
     283,   283,   284,   284,   285,   285,   286,   286,   287,   287,
     287,   287,   287,   287,   287,   287,   287,   287,   287,   287,
     287,   287,   287,   287,   287,   287,   287,   287,   287,   287,
     287,   287,   287,   287,   288,   289,   290,   291,   291,   292,
     292,   292,   292,   293,   293,   293,   293,   293,   293,   294,
     294,   295,   295
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     2,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     1,     1,     1,     1,     1,     2,     1,     1,
       3,     2,     0,     8,     5,     1,     3,     0,     8,     5,
       1,     3,     2,     0,     7,     4,     0,     8,     5,     0,
       2,     4,     6,     6,     4,     1,     3,     9,     1,     3,
       1,     2,     2,     0,     8,     1,     3,     2,     2,     2,
       2,     2,     3,     2,     2,     3,     3,     5,     2,     2,
       2,     3,     2,     4,     6,     3,     3,     4,     3,     5,
       4,     2,     2,     3,     0,     5,     1,     3,     2,     0,
       2,     5,     3,     4,     5,     5,     4,     0,     5,     2,
       6,     1,     3,     1,     1,     0,     3,     0,     3,     1,
       3,     2,     1,     1,     1,     5,     1,     3,     1,     2,
       3,     1,     1,     0,     1,     1,     2,     1,     1,     0,
       3,     0,     3,     1,     2,     1,     2,     3,     2,     1,
       1,     1,     2,     6,     1,     3,     1,     3,     3,     1,
       1,     1,     1,     1,     5,     1,     3,     1,     2,     3,
       1,     1,     1,     0,     1,     1,     3,     3,     1,     1,
       0,     1,     0,     8,     0,     2,     3,     3,     2,     3,
       3,     2,     1,     0,     0,     5,     0,     6,     0,     2,
       3,     3,     3,     0,     2,     0,     2,     4,     3,     0,
       0,     2,     3,     3,     2,     2,     3,     2,     2,     2,
       2,     1,     1,     2,     2,     2,     3,     4,     3,     4,
       3,     3,     4,     7,     3,     2,     2,     2,     2,     3,
       3,     2,     3,     4,     4,     4,     3,     8,     2,     2,
       6,     1,     1,     2,     3,     2,     2,     2,     3,     2,
       3,     0,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     2,     7,     1,     1,     1,     0,
       1,     1,     1,     0,     2,     6,     1,     3,     1,     1,
       5,     1,     3,     1,     1,     2,     2,     1,     1,     2,
       2,     2,     4,     1,     3,     4,     1,     3,     2,     1,
       3,     1,     3,     2,     4,     3,     1,     3,     4,     1,
       3,     1,     1,     2,     3,     0,     0,     2,     1,     2,
       1,     1,     2,     2,     2,     3,     3,     2,     2,     2,
       2,     2,     3,     2,     2,     2,     0,     1,     2,     3,
       4,     1,     1,     1,     1,     0,     2,     6,     3,     1,
       1,     1,     0,     1,     0,     1,     1,     1,     2,     3,
       3,     2,     3,     3,     2,     3,     3,     2,     3,     3,
       2,     2,     2,     2,     2,     2,     2,     1,     2,     2,
       3,     4,     4,     2,     1,     1,     1,     0,     2,     0,
       1,     2,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 21: /* grammar: grammar error '\n'  */
#line 319 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                { file->errors++; }
#line 2511 "parse.c"
    break;

  case 22: /* asnumber: NUMBER  */
#line 322 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			/*
			 * According to iana 65535 and 4294967295 are reserved
			 * but enforcing this is not duty of the parser.
			 */
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > UINT_MAX) {
				yyerror("AS too big: max %u", UINT_MAX);
				YYERROR;
			}
		}
#line 2526 "parse.c"
    break;

  case 23: /* as4number: STRING  */
#line 333 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			const char	*errstr;
			char		*dot;
			uint32_t	 uvalh = 0, uval;

			if ((dot = strchr((yyvsp[0].v.string),'.')) != NULL) {
				*dot++ = '\0';
				uvalh = strtonum((yyvsp[0].v.string), 0, USHRT_MAX, &errstr);
				if (errstr) {
					yyerror("number %s is %s", (yyvsp[0].v.string), errstr);
					free((yyvsp[0].v.string));
					YYERROR;
				}
				uval = strtonum(dot, 0, USHRT_MAX, &errstr);
				if (errstr) {
					yyerror("number %s is %s", dot, errstr);
					free((yyvsp[0].v.string));
					YYERROR;
				}
				free((yyvsp[0].v.string));
			} else {
				yyerror("AS %s is bad", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			if (uvalh == 0 && (uval == AS_TRANS || uval == 0)) {
				yyerror("AS %u is reserved and may not be used",
				    uval);
				YYERROR;
			}
			(yyval.v.number) = uval | (uvalh << 16);
		}
#line 2563 "parse.c"
    break;

  case 24: /* as4number: asnumber  */
#line 365 "../../../openbgpd-portable/src/bgpd/parse.y"
                           {
			if ((yyvsp[0].v.number) == AS_TRANS || (yyvsp[0].v.number) == 0) {
				yyerror("AS %u is reserved and may not be used",
				    (uint32_t)(yyvsp[0].v.number));
				YYERROR;
			}
			(yyval.v.number) = (yyvsp[0].v.number);
		}
#line 2576 "parse.c"
    break;

  case 25: /* as4number_any: STRING  */
#line 375 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			const char	*errstr;
			char		*dot;
			uint32_t	 uvalh = 0, uval;

			if ((dot = strchr((yyvsp[0].v.string),'.')) != NULL) {
				*dot++ = '\0';
				uvalh = strtonum((yyvsp[0].v.string), 0, USHRT_MAX, &errstr);
				if (errstr) {
					yyerror("number %s is %s", (yyvsp[0].v.string), errstr);
					free((yyvsp[0].v.string));
					YYERROR;
				}
				uval = strtonum(dot, 0, USHRT_MAX, &errstr);
				if (errstr) {
					yyerror("number %s is %s", dot, errstr);
					free((yyvsp[0].v.string));
					YYERROR;
				}
				free((yyvsp[0].v.string));
			} else {
				yyerror("AS %s is bad", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			(yyval.v.number) = uval | (uvalh << 16);
		}
#line 2608 "parse.c"
    break;

  case 26: /* as4number_any: asnumber  */
#line 402 "../../../openbgpd-portable/src/bgpd/parse.y"
                           {
			(yyval.v.number) = (yyvsp[0].v.number);
		}
#line 2616 "parse.c"
    break;

  case 27: /* string: string STRING  */
#line 407 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (asprintf(&(yyval.v.string), "%s %s", (yyvsp[-1].v.string), (yyvsp[0].v.string)) == -1)
				fatal("string: asprintf");
			free((yyvsp[-1].v.string));
			free((yyvsp[0].v.string));
		}
#line 2627 "parse.c"
    break;

  case 29: /* yesno: STRING  */
#line 416 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (!strcmp((yyvsp[0].v.string), "yes"))
				(yyval.v.number) = 1;
			else if (!strcmp((yyvsp[0].v.string), "no"))
				(yyval.v.number) = 0;
			else {
				yyerror("syntax error, "
				    "either yes or no expected");
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 2645 "parse.c"
    break;

  case 30: /* varset: STRING '=' string  */
#line 431 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			char *s = (yyvsp[-2].v.string);
			if (strlen((yyvsp[-2].v.string)) >= MACRO_NAME_LEN) {
				yyerror("macro name to long, max %d characters",
				    MACRO_NAME_LEN - 1);
				free((yyvsp[-2].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			do {
				if (isalnum((unsigned char)*s) || *s == '_')
					continue;
				yyerror("macro name can only contain "
					    "alphanumerics and '_'");
				free((yyvsp[-2].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			} while (*++s);

			if (cmd_opts & BGPD_OPT_VERBOSE)
				printf("%s = \"%s\"\n", (yyvsp[-2].v.string), (yyvsp[0].v.string));
			if (symset((yyvsp[-2].v.string), (yyvsp[0].v.string), 0) == -1)
				fatal("cannot store variable");
			free((yyvsp[-2].v.string));
			free((yyvsp[0].v.string));
		}
#line 2676 "parse.c"
    break;

  case 31: /* include: INCLUDE STRING  */
#line 459 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			struct file	*nfile;

			if ((nfile = pushfile((yyvsp[0].v.string), 1)) == NULL) {
				yyerror("failed to include file %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));

			file = nfile;
			lungetc('\n');
		}
#line 2694 "parse.c"
    break;

  case 32: /* $@1: %empty  */
#line 474 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (strlen((yyvsp[-2].v.string)) >= SET_NAME_LEN) {
				yyerror("as-set name %s too long", (yyvsp[-2].v.string));
				free((yyvsp[-2].v.string));
				YYERROR;
			}
			if (new_as_set((yyvsp[-2].v.string)) != 0) {
				free((yyvsp[-2].v.string));
				YYERROR;
			}
			free((yyvsp[-2].v.string));
		}
#line 2711 "parse.c"
    break;

  case 33: /* as_set: ASSET STRING '{' optnl $@1 as_set_l optnl '}'  */
#line 485 "../../../openbgpd-portable/src/bgpd/parse.y"
                                     {
			done_as_set();
		}
#line 2719 "parse.c"
    break;

  case 34: /* as_set: ASSET STRING '{' optnl '}'  */
#line 488 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (new_as_set((yyvsp[-3].v.string)) != 0) {
				free((yyvsp[-3].v.string));
				YYERROR;
			}
			free((yyvsp[-3].v.string));
		}
#line 2731 "parse.c"
    break;

  case 35: /* as_set_l: as4number_any  */
#line 496 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                { add_as_set((yyvsp[0].v.number)); }
#line 2737 "parse.c"
    break;

  case 36: /* as_set_l: as_set_l comma as4number_any  */
#line 497 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                { add_as_set((yyvsp[0].v.number)); }
#line 2743 "parse.c"
    break;

  case 37: /* $@2: %empty  */
#line 499 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			if ((curpset = new_prefix_set((yyvsp[-2].v.string), 0)) == NULL) {
				free((yyvsp[-2].v.string));
				YYERROR;
			}
			free((yyvsp[-2].v.string));
		}
#line 2755 "parse.c"
    break;

  case 38: /* prefixset: PREFIXSET STRING '{' optnl $@2 prefixset_l optnl '}'  */
#line 505 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			SIMPLEQ_INSERT_TAIL(&conf->prefixsets, curpset, entry);
			curpset = NULL;
		}
#line 2764 "parse.c"
    break;

  case 39: /* prefixset: PREFIXSET STRING '{' optnl '}'  */
#line 509 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			if ((curpset = new_prefix_set((yyvsp[-3].v.string), 0)) == NULL) {
				free((yyvsp[-3].v.string));
				YYERROR;
			}
			free((yyvsp[-3].v.string));
			SIMPLEQ_INSERT_TAIL(&conf->prefixsets, curpset, entry);
			curpset = NULL;
		}
#line 2778 "parse.c"
    break;

  case 40: /* prefixset_l: prefixset_item  */
#line 519 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			struct prefixset_item	*psi;
			if ((yyvsp[0].v.prefixset_item)->p.op != OP_NONE)
				curpset->sflags |= PREFIXSET_FLAG_OPS;
			psi = RB_INSERT(prefixset_tree, &curpset->psitems, (yyvsp[0].v.prefixset_item));
			if (psi != NULL) {
				if (cmd_opts & BGPD_OPT_VERBOSE2)
					log_warnx("warning: duplicate entry in "
					    "prefixset \"%s\" for %s/%u",
					    curpset->name,
					    log_addr(&(yyvsp[0].v.prefixset_item)->p.addr), (yyvsp[0].v.prefixset_item)->p.len);
				free((yyvsp[0].v.prefixset_item));
			}
		}
#line 2797 "parse.c"
    break;

  case 41: /* prefixset_l: prefixset_l comma prefixset_item  */
#line 533 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			struct prefixset_item	*psi;
			if ((yyvsp[0].v.prefixset_item)->p.op != OP_NONE)
				curpset->sflags |= PREFIXSET_FLAG_OPS;
			psi = RB_INSERT(prefixset_tree, &curpset->psitems, (yyvsp[0].v.prefixset_item));
			if (psi != NULL) {
				if (cmd_opts & BGPD_OPT_VERBOSE2)
					log_warnx("warning: duplicate entry in "
					    "prefixset \"%s\" for %s/%u",
					    curpset->name,
					    log_addr(&(yyvsp[0].v.prefixset_item)->p.addr), (yyvsp[0].v.prefixset_item)->p.len);
				free((yyvsp[0].v.prefixset_item));
			}
		}
#line 2816 "parse.c"
    break;

  case 42: /* prefixset_item: prefix prefixlenop  */
#line 549 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			if ((yyvsp[0].v.prefixlen).op != OP_NONE && (yyvsp[0].v.prefixlen).op != OP_RANGE) {
				yyerror("unsupported prefixlen operation in "
				    "prefix-set");
				YYERROR;
			}
			if (((yyval.v.prefixset_item) = calloc(1, sizeof(*(yyval.v.prefixset_item)))) == NULL)
				fatal(NULL);
			memcpy(&(yyval.v.prefixset_item)->p.addr, &(yyvsp[-1].v.prefix).prefix, sizeof((yyval.v.prefixset_item)->p.addr));
			(yyval.v.prefixset_item)->p.len = (yyvsp[-1].v.prefix).len;
			if (merge_prefixspec(&(yyval.v.prefixset_item)->p, &(yyvsp[0].v.prefixlen)) == -1) {
				free((yyval.v.prefixset_item));
				YYERROR;
			}
		}
#line 2836 "parse.c"
    break;

  case 43: /* $@3: %empty  */
#line 566 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			curroatree = &conf->roa;
		}
#line 2844 "parse.c"
    break;

  case 44: /* roa_set: ROASET '{' optnl $@3 roa_set_l optnl '}'  */
#line 568 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			curroatree = NULL;
		}
#line 2852 "parse.c"
    break;

  case 46: /* $@4: %empty  */
#line 574 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			if ((curoset = new_prefix_set((yyvsp[-2].v.string), 1)) == NULL) {
				free((yyvsp[-2].v.string));
				YYERROR;
			}
			curroatree = &curoset->roaitems;
			noexpires = 1;
			free((yyvsp[-2].v.string));
		}
#line 2866 "parse.c"
    break;

  case 47: /* origin_set: ORIGINSET STRING '{' optnl $@4 roa_set_l optnl '}'  */
#line 582 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			SIMPLEQ_INSERT_TAIL(&conf->originsets, curoset, entry);
			curoset = NULL;
			curroatree = NULL;
			noexpires = 0;
		}
#line 2877 "parse.c"
    break;

  case 48: /* origin_set: ORIGINSET STRING '{' optnl '}'  */
#line 588 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                                {
			if ((curoset = new_prefix_set((yyvsp[-3].v.string), 1)) == NULL) {
				free((yyvsp[-3].v.string));
				YYERROR;
			}
			free((yyvsp[-3].v.string));
			SIMPLEQ_INSERT_TAIL(&conf->originsets, curoset, entry);
			curoset = NULL;
			curroatree = NULL;
		}
#line 2892 "parse.c"
    break;

  case 49: /* expires: %empty  */
#line 600 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			(yyval.v.number) = 0;
		}
#line 2900 "parse.c"
    break;

  case 50: /* expires: EXPIRES NUMBER  */
#line 603 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (noexpires) {
				yyerror("syntax error, expires not allowed");
				YYERROR;
			}
			(yyval.v.number) = (yyvsp[0].v.number);
		}
#line 2912 "parse.c"
    break;

  case 51: /* roa_set_l: prefixset_item SOURCEAS as4number_any expires  */
#line 611 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                                        {
			if ((yyvsp[-3].v.prefixset_item)->p.len_min != (yyvsp[-3].v.prefixset_item)->p.len) {
				yyerror("unsupported prefixlen operation in "
				    "roa-set");
				free((yyvsp[-3].v.prefixset_item));
				YYERROR;
			}
			add_roa_set((yyvsp[-3].v.prefixset_item), (yyvsp[-1].v.number), (yyvsp[-3].v.prefixset_item)->p.len_max, (yyvsp[0].v.number));
			free((yyvsp[-3].v.prefixset_item));
		}
#line 2927 "parse.c"
    break;

  case 52: /* roa_set_l: roa_set_l comma prefixset_item SOURCEAS as4number_any expires  */
#line 621 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                                                {
			if ((yyvsp[-3].v.prefixset_item)->p.len_min != (yyvsp[-3].v.prefixset_item)->p.len) {
				yyerror("unsupported prefixlen operation in "
				    "roa-set");
				free((yyvsp[-3].v.prefixset_item));
				YYERROR;
			}
			add_roa_set((yyvsp[-3].v.prefixset_item), (yyvsp[-1].v.number), (yyvsp[-3].v.prefixset_item)->p.len_max, (yyvsp[0].v.number));
			free((yyvsp[-3].v.prefixset_item));
		}
#line 2942 "parse.c"
    break;

  case 57: /* aspa_elm: CUSTOMERAS as4number expires PROVIDERAS '{' optnl aspa_tas_l optnl '}'  */
#line 642 "../../../openbgpd-portable/src/bgpd/parse.y"
                                         {
			int rv;
			struct aspa_tas_l *a, *n;

			rv = merge_aspa_set((yyvsp[-7].v.number), (yyvsp[-2].v.aspa_elm), (yyvsp[-6].v.number));

			for (a = (yyvsp[-2].v.aspa_elm); a != NULL; a = n) {
				n = a->next;
				free(a);
			}

			if (rv == -1)
				YYERROR;
		}
#line 2961 "parse.c"
    break;

  case 58: /* aspa_tas_l: aspa_tas  */
#line 658 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                { (yyval.v.aspa_elm) = (yyvsp[0].v.aspa_elm); }
#line 2967 "parse.c"
    break;

  case 59: /* aspa_tas_l: aspa_tas_l comma aspa_tas  */
#line 659 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			(yyvsp[0].v.aspa_elm)->next = (yyvsp[-2].v.aspa_elm);
			(yyvsp[0].v.aspa_elm)->num = (yyvsp[-2].v.aspa_elm)->num + 1;
			(yyval.v.aspa_elm) = (yyvsp[0].v.aspa_elm);
		}
#line 2977 "parse.c"
    break;

  case 60: /* aspa_tas: as4number_any  */
#line 666 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			if (((yyval.v.aspa_elm) = calloc(1, sizeof(*(yyval.v.aspa_elm)))) == NULL)
				fatal(NULL);
			(yyval.v.aspa_elm)->as = (yyvsp[0].v.number);
			(yyval.v.aspa_elm)->num = 1;
		}
#line 2988 "parse.c"
    break;

  case 61: /* aspa_tas: as4number_any af  */
#line 672 "../../../openbgpd-portable/src/bgpd/parse.y"
                                   {
			if (((yyval.v.aspa_elm) = calloc(1, sizeof(*(yyval.v.aspa_elm)))) == NULL)
				fatal(NULL);
			(yyval.v.aspa_elm)->as = (yyvsp[-1].v.number);
			(yyval.v.aspa_elm)->num = 1;
		}
#line 2999 "parse.c"
    break;

  case 62: /* rtr: RTR address  */
#line 680 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			currtr = get_rtr(&(yyvsp[0].v.addr));
			currtr->remote_port = RTR_PORT;
			if (insert_rtr(currtr) == -1) {
				free(currtr);
				YYERROR;
			}
			currtr = NULL;
		}
#line 3013 "parse.c"
    break;

  case 63: /* $@5: %empty  */
#line 689 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			currtr = get_rtr(&(yyvsp[0].v.addr));
			currtr->remote_port = RTR_PORT;
		}
#line 3022 "parse.c"
    break;

  case 64: /* rtr: RTR address $@5 '{' optnl rtropt_l optnl '}'  */
#line 692 "../../../openbgpd-portable/src/bgpd/parse.y"
                                               {
			if (insert_rtr(currtr) == -1) {
				free(currtr);
				YYERROR;
			}
			currtr = NULL;
		}
#line 3034 "parse.c"
    break;

  case 67: /* rtropt: DESCR STRING  */
#line 705 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (strlcpy(currtr->descr, (yyvsp[0].v.string),
			    sizeof(currtr->descr)) >=
			    sizeof(currtr->descr)) {
				yyerror("descr \"%s\" too long: max %zu",
				    (yyvsp[0].v.string), sizeof(currtr->descr) - 1);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 3050 "parse.c"
    break;

  case 68: /* rtropt: LOCALADDR address  */
#line 716 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.addr).aid != currtr->remote_addr.aid) {
				yyerror("Bad address family %s for "
				    "local-addr", aid2str((yyvsp[0].v.addr).aid));
				YYERROR;
			}
			currtr->local_addr = (yyvsp[0].v.addr);
		}
#line 3063 "parse.c"
    break;

  case 69: /* rtropt: PORT port  */
#line 724 "../../../openbgpd-portable/src/bgpd/parse.y"
                            {
			currtr->remote_port = (yyvsp[0].v.number);
		}
#line 3071 "parse.c"
    break;

  case 70: /* rtropt: MINVERSION NUMBER  */
#line 727 "../../../openbgpd-portable/src/bgpd/parse.y"
                                    {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > RTR_MAX_VERSION) {
				yyerror("min-version must be between %u and %u",
				    0, RTR_MAX_VERSION);
				YYERROR;
			}
			currtr->min_version = (yyvsp[0].v.number);
		}
#line 3084 "parse.c"
    break;

  case 71: /* conf_main: AS as4number  */
#line 737 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			conf->as = (yyvsp[0].v.number);
			if ((yyvsp[0].v.number) > USHRT_MAX)
				conf->short_as = AS_TRANS;
			else
				conf->short_as = (yyvsp[0].v.number);
		}
#line 3096 "parse.c"
    break;

  case 72: /* conf_main: AS as4number asnumber  */
#line 744 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			conf->as = (yyvsp[-1].v.number);
			conf->short_as = (yyvsp[0].v.number);
		}
#line 3105 "parse.c"
    break;

  case 73: /* conf_main: ROUTERID address  */
#line 748 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if ((yyvsp[0].v.addr).aid != AID_INET) {
				yyerror("router-id must be an IPv4 address");
				YYERROR;
			}
			conf->bgpid = ntohl((yyvsp[0].v.addr).v4.s_addr);
		}
#line 3117 "parse.c"
    break;

  case 74: /* conf_main: HOLDTIME NUMBER  */
#line 755 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.number) < MIN_HOLDTIME || (yyvsp[0].v.number) > USHRT_MAX) {
				yyerror("holdtime must be between %u and %u",
				    MIN_HOLDTIME, USHRT_MAX);
				YYERROR;
			}
			conf->holdtime = (yyvsp[0].v.number);
		}
#line 3130 "parse.c"
    break;

  case 75: /* conf_main: HOLDTIME YMIN NUMBER  */
#line 763 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.number) < MIN_HOLDTIME || (yyvsp[0].v.number) > USHRT_MAX) {
				yyerror("holdtime must be between %u and %u",
				    MIN_HOLDTIME, USHRT_MAX);
				YYERROR;
			}
			conf->min_holdtime = (yyvsp[0].v.number);
		}
#line 3143 "parse.c"
    break;

  case 76: /* conf_main: LISTEN ON address  */
#line 771 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			struct listen_addr	*la;
			struct sockaddr		*sa;

			if ((la = calloc(1, sizeof(struct listen_addr))) ==
			    NULL)
				fatal("parse conf_main listen on calloc");

			la->fd = -1;
			la->reconf = RECONF_REINIT;
			sa = addr2sa(&(yyvsp[0].v.addr), BGP_PORT, &la->sa_len);
			memcpy(&la->sa, sa, la->sa_len);
			TAILQ_INSERT_TAIL(conf->listen_addrs, la, entry);
		}
#line 3162 "parse.c"
    break;

  case 77: /* conf_main: LISTEN ON address PORT port  */
#line 785 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			struct listen_addr	*la;
			struct sockaddr		*sa;

			if ((la = calloc(1, sizeof(struct listen_addr))) ==
			    NULL)
				fatal("parse conf_main listen on calloc");

			la->fd = -1;
			la->reconf = RECONF_REINIT;
			sa = addr2sa(&(yyvsp[-2].v.addr), (yyvsp[0].v.number), &la->sa_len);
			memcpy(&la->sa, sa, la->sa_len);
			TAILQ_INSERT_TAIL(conf->listen_addrs, la, entry);
		}
#line 3181 "parse.c"
    break;

  case 78: /* conf_main: FIBPRIORITY NUMBER  */
#line 799 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (!kr_check_prio((yyvsp[0].v.number))) {
				yyerror("fib-priority %lld out of range", (yyvsp[0].v.number));
				YYERROR;
			}
			conf->fib_priority = (yyvsp[0].v.number);
		}
#line 3193 "parse.c"
    break;

  case 79: /* conf_main: FIBUPDATE yesno  */
#line 806 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			struct rde_rib *rr;
			rr = find_rib("Loc-RIB");
			if (rr == NULL)
				fatalx("RTABLE cannot find the main RIB!");

			if ((yyvsp[0].v.number) == 0)
				rr->flags |= F_RIB_NOFIBSYNC;
			else
				rr->flags &= ~F_RIB_NOFIBSYNC;
		}
#line 3209 "parse.c"
    break;

  case 80: /* conf_main: TRANSPARENT yesno  */
#line 817 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.number) == 1)
				conf->flags |= BGPD_FLAG_DECISION_TRANS_AS;
			else
				conf->flags &= ~BGPD_FLAG_DECISION_TRANS_AS;
		}
#line 3220 "parse.c"
    break;

  case 81: /* conf_main: REJECT ASSET yesno  */
#line 823 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.number) == 1)
				conf->flags |= BGPD_FLAG_NO_AS_SET;
			else
				conf->flags &= ~BGPD_FLAG_NO_AS_SET;
		}
#line 3231 "parse.c"
    break;

  case 82: /* conf_main: LOG STRING  */
#line 829 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (!strcmp((yyvsp[0].v.string), "updates"))
				conf->log |= BGPD_LOG_UPDATES;
			else {
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 3245 "parse.c"
    break;

  case 83: /* conf_main: DUMP STRING STRING optnumber  */
#line 838 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			int action;

			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > INT_MAX) {
				yyerror("bad timeout");
				free((yyvsp[-2].v.string));
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			if (!strcmp((yyvsp[-2].v.string), "table"))
				action = MRT_TABLE_DUMP;
			else if (!strcmp((yyvsp[-2].v.string), "table-mp"))
				action = MRT_TABLE_DUMP_MP;
			else if (!strcmp((yyvsp[-2].v.string), "table-v2"))
				action = MRT_TABLE_DUMP_V2;
			else {
				yyerror("unknown mrt dump type");
				free((yyvsp[-2].v.string));
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			free((yyvsp[-2].v.string));
			if (add_mrtconfig(action, (yyvsp[-1].v.string), (yyvsp[0].v.number), NULL, NULL) == -1) {
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			free((yyvsp[-1].v.string));
		}
#line 3278 "parse.c"
    break;

  case 84: /* conf_main: DUMP RIB STRING STRING STRING optnumber  */
#line 866 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                                        {
			int action;

			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > INT_MAX) {
				yyerror("bad timeout");
				free((yyvsp[-3].v.string));
				free((yyvsp[-2].v.string));
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			if (!strcmp((yyvsp[-2].v.string), "table"))
				action = MRT_TABLE_DUMP;
			else if (!strcmp((yyvsp[-2].v.string), "table-mp"))
				action = MRT_TABLE_DUMP_MP;
			else if (!strcmp((yyvsp[-2].v.string), "table-v2"))
				action = MRT_TABLE_DUMP_V2;
			else {
				yyerror("unknown mrt dump type");
				free((yyvsp[-3].v.string));
				free((yyvsp[-2].v.string));
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			free((yyvsp[-2].v.string));
			if (add_mrtconfig(action, (yyvsp[-1].v.string), (yyvsp[0].v.number), NULL, (yyvsp[-3].v.string)) == -1) {
				free((yyvsp[-3].v.string));
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			free((yyvsp[-3].v.string));
			free((yyvsp[-1].v.string));
		}
#line 3315 "parse.c"
    break;

  case 85: /* conf_main: RDE STRING EVALUATE  */
#line 898 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (!strcmp((yyvsp[-1].v.string), "route-age"))
				conf->flags |= BGPD_FLAG_DECISION_ROUTEAGE;
			else {
				yyerror("unknown route decision type");
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			free((yyvsp[-1].v.string));
		}
#line 3330 "parse.c"
    break;

  case 86: /* conf_main: RDE STRING IGNORE  */
#line 908 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (!strcmp((yyvsp[-1].v.string), "route-age"))
				conf->flags &= ~BGPD_FLAG_DECISION_ROUTEAGE;
			else {
				yyerror("unknown route decision type");
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			free((yyvsp[-1].v.string));
		}
#line 3345 "parse.c"
    break;

  case 87: /* conf_main: RDE MED COMPARE STRING  */
#line 918 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (!strcmp((yyvsp[0].v.string), "always"))
				conf->flags |= BGPD_FLAG_DECISION_MED_ALWAYS;
			else if (!strcmp((yyvsp[0].v.string), "strict"))
				conf->flags &= ~BGPD_FLAG_DECISION_MED_ALWAYS;
			else {
				yyerror("rde med compare: "
				    "unknown setting \"%s\"", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 3363 "parse.c"
    break;

  case 88: /* conf_main: RDE EVALUATE STRING  */
#line 931 "../../../openbgpd-portable/src/bgpd/parse.y"
                                      {
			if (!strcmp((yyvsp[0].v.string), "all"))
				conf->flags |= BGPD_FLAG_DECISION_ALL_PATHS;
			else if (!strcmp((yyvsp[0].v.string), "default"))
				conf->flags &= ~BGPD_FLAG_DECISION_ALL_PATHS;
			else {
				yyerror("rde evaluate: "
				    "unknown setting \"%s\"", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 3381 "parse.c"
    break;

  case 89: /* conf_main: RDE RIB STRING INCLUDE FILTERED  */
#line 944 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                  {
			if (strcmp((yyvsp[-2].v.string), "Loc-RIB") != 0) {
				yyerror("include filtered only supported in "
				    "Loc-RIB");
				YYERROR;
			}
			conf->filtered_in_locrib = 1;
		}
#line 3394 "parse.c"
    break;

  case 90: /* conf_main: NEXTHOP QUALIFY VIA STRING  */
#line 952 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (!strcmp((yyvsp[0].v.string), "bgp"))
				conf->flags |= BGPD_FLAG_NEXTHOP_BGP;
			else if (!strcmp((yyvsp[0].v.string), "default"))
				conf->flags |= BGPD_FLAG_NEXTHOP_DEFAULT;
			else {
				yyerror("nexthop depend on: "
				    "unknown setting \"%s\"", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 3412 "parse.c"
    break;

  case 91: /* conf_main: RTABLE NUMBER  */
#line 965 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			struct rde_rib *rr;
			if ((yyvsp[0].v.number) > RT_TABLEID_MAX) {
				yyerror("rtable %llu too big: max %u", (yyvsp[0].v.number),
				    RT_TABLEID_MAX);
				YYERROR;
			}
			if (!ktable_exists((yyvsp[0].v.number), NULL)) {
				yyerror("rtable id %lld does not exist", (yyvsp[0].v.number));
				YYERROR;
			}
			rr = find_rib("Loc-RIB");
			if (rr == NULL)
				fatalx("RTABLE cannot find the main RIB!");
			rr->rtableid = (yyvsp[0].v.number);
		}
#line 3433 "parse.c"
    break;

  case 92: /* conf_main: CONNECTRETRY NUMBER  */
#line 981 "../../../openbgpd-portable/src/bgpd/parse.y"
                                      {
			if ((yyvsp[0].v.number) > USHRT_MAX || (yyvsp[0].v.number) < 1) {
				yyerror("invalid connect-retry");
				YYERROR;
			}
			conf->connectretry = (yyvsp[0].v.number);
		}
#line 3445 "parse.c"
    break;

  case 93: /* conf_main: SOCKET STRING restricted  */
#line 988 "../../../openbgpd-portable/src/bgpd/parse.y"
                                           {
			if (strlen((yyvsp[-1].v.string)) >=
			    sizeof(((struct sockaddr_un *)0)->sun_path)) {
				yyerror("socket path too long");
				YYERROR;
			}
			if ((yyvsp[0].v.number)) {
				free(conf->rcsock);
				conf->rcsock = (yyvsp[-1].v.string);
			} else {
				free(conf->csock);
				conf->csock = (yyvsp[-1].v.string);
			}
		}
#line 3464 "parse.c"
    break;

  case 94: /* $@6: %empty  */
#line 1004 "../../../openbgpd-portable/src/bgpd/parse.y"
                                 {
			if ((currib = add_rib((yyvsp[0].v.string))) == NULL) {
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 3476 "parse.c"
    break;

  case 95: /* rib: RDE RIB STRING $@6 ribopts  */
#line 1010 "../../../openbgpd-portable/src/bgpd/parse.y"
                          {
			currib = NULL;
		}
#line 3484 "parse.c"
    break;

  case 97: /* ribopts: RTABLE NUMBER fibupdate  */
#line 1015 "../../../openbgpd-portable/src/bgpd/parse.y"
                                          {
			if ((yyvsp[-1].v.number) > RT_TABLEID_MAX) {
				yyerror("rtable %llu too big: max %u", (yyvsp[-1].v.number),
				    RT_TABLEID_MAX);
				YYERROR;
			}
			if (rib_add_fib(currib, (yyvsp[-1].v.number)) == -1)
				YYERROR;
		}
#line 3498 "parse.c"
    break;

  case 98: /* ribopts: yesno EVALUATE  */
#line 1024 "../../../openbgpd-portable/src/bgpd/parse.y"
                                 {
			if ((yyvsp[-1].v.number)) {
				yyerror("bad rde rib definition");
				YYERROR;
			}
			currib->flags |= F_RIB_NOEVALUATE;
		}
#line 3510 "parse.c"
    break;

  case 100: /* fibupdate: FIBUPDATE yesno  */
#line 1034 "../../../openbgpd-portable/src/bgpd/parse.y"
                                  {
			if ((yyvsp[0].v.number) == 0)
				currib->flags |= F_RIB_NOFIBSYNC;
			else
				currib->flags &= ~F_RIB_NOFIBSYNC;
		}
#line 3521 "parse.c"
    break;

  case 101: /* mrtdump: DUMP STRING inout STRING optnumber  */
#line 1042 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			int action;

			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > INT_MAX) {
				yyerror("bad timeout");
				free((yyvsp[-3].v.string));
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			if (!strcmp((yyvsp[-3].v.string), "all"))
				action = (yyvsp[-2].v.number) ? MRT_ALL_IN : MRT_ALL_OUT;
			else if (!strcmp((yyvsp[-3].v.string), "updates"))
				action = (yyvsp[-2].v.number) ? MRT_UPDATE_IN : MRT_UPDATE_OUT;
			else {
				yyerror("unknown mrt msg dump type");
				free((yyvsp[-3].v.string));
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			if (add_mrtconfig(action, (yyvsp[-1].v.string), (yyvsp[0].v.number), curpeer, NULL) ==
			    -1) {
				free((yyvsp[-3].v.string));
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			free((yyvsp[-3].v.string));
			free((yyvsp[-1].v.string));
		}
#line 3554 "parse.c"
    break;

  case 102: /* network: NETWORK prefix filter_set  */
#line 1072 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			struct network	*n, *m;

			if ((n = calloc(1, sizeof(struct network))) == NULL)
				fatal("new_network");
			memcpy(&n->net.prefix, &(yyvsp[-1].v.prefix).prefix,
			    sizeof(n->net.prefix));
			n->net.prefixlen = (yyvsp[-1].v.prefix).len;
			filterset_move((yyvsp[0].v.filter_set_head), &n->net.attrset);
			free((yyvsp[0].v.filter_set_head));
			TAILQ_FOREACH(m, netconf, entry) {
				if (n->net.type == m->net.type &&
				    n->net.prefixlen == m->net.prefixlen &&
				    prefix_compare(&n->net.prefix,
				    &m->net.prefix, n->net.prefixlen) == 0)
					yyerror("duplicate prefix "
					    "in network statement");
			}

			TAILQ_INSERT_TAIL(netconf, n, entry);
		}
#line 3580 "parse.c"
    break;

  case 103: /* network: NETWORK PREFIXSET STRING filter_set  */
#line 1093 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			struct prefixset *ps;
			struct network	*n;
			if ((ps = find_prefixset((yyvsp[-1].v.string), &conf->prefixsets))
			    == NULL) {
				yyerror("prefix-set '%s' not defined", (yyvsp[-1].v.string));
				free((yyvsp[-1].v.string));
				filterset_free((yyvsp[0].v.filter_set_head));
				free((yyvsp[0].v.filter_set_head));
				YYERROR;
			}
			if (ps->sflags & PREFIXSET_FLAG_OPS) {
				yyerror("prefix-set %s has prefixlen operators "
				    "and cannot be used in network statements.",
				    ps->name);
				free((yyvsp[-1].v.string));
				filterset_free((yyvsp[0].v.filter_set_head));
				free((yyvsp[0].v.filter_set_head));
				YYERROR;
			}
			if ((n = calloc(1, sizeof(struct network))) == NULL)
				fatal("new_network");
			strlcpy(n->net.psname, ps->name, sizeof(n->net.psname));
			filterset_move((yyvsp[0].v.filter_set_head), &n->net.attrset);
			n->net.type = NETWORK_PREFIXSET;
			TAILQ_INSERT_TAIL(netconf, n, entry);
			free((yyvsp[-1].v.string));
			free((yyvsp[0].v.filter_set_head));
		}
#line 3614 "parse.c"
    break;

  case 104: /* network: NETWORK af RTLABEL STRING filter_set  */
#line 1122 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			struct network	*n;

			if ((n = calloc(1, sizeof(struct network))) == NULL)
				fatal("new_network");
			if (afi2aid((yyvsp[-3].v.number), SAFI_UNICAST, &n->net.prefix.aid) ==
			    -1) {
				yyerror("unknown address family");
				filterset_free((yyvsp[0].v.filter_set_head));
				free((yyvsp[0].v.filter_set_head));
				YYERROR;
			}
			n->net.type = NETWORK_RTLABEL;
			n->net.rtlabel = rtlabel_name2id((yyvsp[-1].v.string));
			filterset_move((yyvsp[0].v.filter_set_head), &n->net.attrset);
			free((yyvsp[0].v.filter_set_head));

			TAILQ_INSERT_TAIL(netconf, n, entry);
		}
#line 3638 "parse.c"
    break;

  case 105: /* network: NETWORK af PRIORITY NUMBER filter_set  */
#line 1141 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			struct network	*n;
			if (!kr_check_prio((yyvsp[-1].v.number))) {
				yyerror("priority %lld out of range", (yyvsp[-1].v.number));
				YYERROR;
			}

			if ((n = calloc(1, sizeof(struct network))) == NULL)
				fatal("new_network");
			if (afi2aid((yyvsp[-3].v.number), SAFI_UNICAST, &n->net.prefix.aid) ==
			    -1) {
				yyerror("unknown address family");
				filterset_free((yyvsp[0].v.filter_set_head));
				free((yyvsp[0].v.filter_set_head));
				YYERROR;
			}
			n->net.type = NETWORK_PRIORITY;
			n->net.priority = (yyvsp[-1].v.number);
			filterset_move((yyvsp[0].v.filter_set_head), &n->net.attrset);
			free((yyvsp[0].v.filter_set_head));

			TAILQ_INSERT_TAIL(netconf, n, entry);
		}
#line 3666 "parse.c"
    break;

  case 106: /* network: NETWORK af nettype filter_set  */
#line 1164 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			struct network	*n;

			if ((n = calloc(1, sizeof(struct network))) == NULL)
				fatal("new_network");
			if (afi2aid((yyvsp[-2].v.number), SAFI_UNICAST, &n->net.prefix.aid) ==
			    -1) {
				yyerror("unknown address family");
				filterset_free((yyvsp[0].v.filter_set_head));
				free((yyvsp[0].v.filter_set_head));
				YYERROR;
			}
			n->net.type = (yyvsp[-1].v.number) ? NETWORK_STATIC : NETWORK_CONNECTED;
			filterset_move((yyvsp[0].v.filter_set_head), &n->net.attrset);
			free((yyvsp[0].v.filter_set_head));

			TAILQ_INSERT_TAIL(netconf, n, entry);
		}
#line 3689 "parse.c"
    break;

  case 107: /* $@7: %empty  */
#line 1184 "../../../openbgpd-portable/src/bgpd/parse.y"
                              {
			if ((curflow = calloc(1, sizeof(*curflow))) == NULL)
				fatal("new_flowspec");
			curflow->aid = (yyvsp[0].v.number);
		}
#line 3699 "parse.c"
    break;

  case 108: /* flowspec: FLOWSPEC af $@7 flow_rules filter_set  */
#line 1188 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			struct flowspec_config *f;

			f = flow_to_flowspec(curflow);
			if (f == NULL) {
				yyerror("out of memory");
				free((yyvsp[0].v.filter_set_head));
				flow_free(curflow);
				curflow = NULL;
				YYERROR;
			}
			filterset_move((yyvsp[0].v.filter_set_head), &f->attrset);
			free((yyvsp[0].v.filter_set_head));
			flow_free(curflow);
			curflow = NULL;

			if (RB_INSERT(flowspec_tree, &conf->flowspecs, f) !=
			    NULL) {
				yyerror("duplicate flowspec definition");
				flowspec_free(f);
				YYERROR;
			}
		}
#line 3727 "parse.c"
    break;

  case 111: /* proto_list: proto_item  */
#line 1217 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			curflow->type = FLOWSPEC_TYPE_PROTO;
			if (push_unary_numop(OP_EQ, (yyvsp[0].v.number)) == -1)
				YYERROR;
		}
#line 3737 "parse.c"
    break;

  case 112: /* proto_list: proto_list comma proto_item  */
#line 1222 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			curflow->type = FLOWSPEC_TYPE_PROTO;
			if (push_unary_numop(OP_EQ, (yyvsp[0].v.number)) == -1)
				YYERROR;
		}
#line 3747 "parse.c"
    break;

  case 113: /* proto_item: STRING  */
#line 1229 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			struct protoent *p;

			p = getprotobyname((yyvsp[0].v.string));
			if (p == NULL) {
				yyerror("unknown protocol %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			(yyval.v.number) = p->p_proto;
			free((yyvsp[0].v.string));
		}
#line 3764 "parse.c"
    break;

  case 114: /* proto_item: NUMBER  */
#line 1241 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > 255) {
				yyerror("protocol outside range");
				YYERROR;
			}
			(yyval.v.number) = (yyvsp[0].v.number);
		}
#line 3776 "parse.c"
    break;

  case 115: /* $@8: %empty  */
#line 1250 "../../../openbgpd-portable/src/bgpd/parse.y"
                       {
			curflow->type = FLOWSPEC_TYPE_SRC_PORT;
			curflow->addr_type = FLOWSPEC_TYPE_SOURCE;
		}
#line 3785 "parse.c"
    break;

  case 117: /* $@9: %empty  */
#line 1256 "../../../openbgpd-portable/src/bgpd/parse.y"
                     {
			curflow->type = FLOWSPEC_TYPE_DST_PORT;
			curflow->addr_type = FLOWSPEC_TYPE_DEST;
		}
#line 3794 "parse.c"
    break;

  case 123: /* ipspec: prefix  */
#line 1268 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (push_prefix(&(yyvsp[0].v.prefix).prefix, (yyvsp[0].v.prefix).len) == -1)
				YYERROR;
		}
#line 3803 "parse.c"
    break;

  case 128: /* port_item: port  */
#line 1282 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (push_unary_numop(OP_EQ, (yyvsp[0].v.number)) == -1)
				YYERROR;
		}
#line 3812 "parse.c"
    break;

  case 129: /* port_item: unaryop port  */
#line 1286 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (push_unary_numop((yyvsp[-1].v.u8), (yyvsp[0].v.number)) == -1)
				YYERROR;
		}
#line 3821 "parse.c"
    break;

  case 130: /* port_item: port binaryop port  */
#line 1290 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (push_binary_numop((yyvsp[-1].v.u8), (yyvsp[-2].v.number), (yyvsp[0].v.number)))
				YYERROR;
		}
#line 3830 "parse.c"
    break;

  case 131: /* port: NUMBER  */
#line 1296 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if ((yyvsp[0].v.number) < 1 || (yyvsp[0].v.number) > USHRT_MAX) {
				yyerror("port must be between %u and %u",
				    1, USHRT_MAX);
				YYERROR;
			}
			(yyval.v.number) = (yyvsp[0].v.number);
		}
#line 3843 "parse.c"
    break;

  case 132: /* port: STRING  */
#line 1304 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (((yyval.v.number) = getservice((yyvsp[0].v.string))) == -1) {
				yyerror("unknown port '%s'", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 3856 "parse.c"
    break;

  case 139: /* $@10: %empty  */
#line 1324 "../../../openbgpd-portable/src/bgpd/parse.y"
                        {
			curflow->type = FLOWSPEC_TYPE_TCP_FLAGS;
		}
#line 3864 "parse.c"
    break;

  case 141: /* $@11: %empty  */
#line 1327 "../../../openbgpd-portable/src/bgpd/parse.y"
                           {
			curflow->type = FLOWSPEC_TYPE_FRAG;
		}
#line 3872 "parse.c"
    break;

  case 144: /* flowrule: LENGTH lengthspec  */
#line 1331 "../../../openbgpd-portable/src/bgpd/parse.y"
                                    {
			curflow->type = FLOWSPEC_TYPE_PKT_LEN;
		}
#line 3880 "parse.c"
    break;

  case 146: /* flowrule: TOS tos  */
#line 1335 "../../../openbgpd-portable/src/bgpd/parse.y"
                          {
			curflow->type = FLOWSPEC_TYPE_DSCP;
			if (push_unary_numop(OP_EQ, (yyvsp[0].v.number) >> 2) == -1)
				YYERROR;
		}
#line 3890 "parse.c"
    break;

  case 147: /* flags: flag '/' flag  */
#line 1342 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (((yyvsp[-2].v.number) & (yyvsp[0].v.number)) != (yyvsp[-2].v.number)) {
				yyerror("bad flag combination, "
				    "check bit not in mask");
				YYERROR;
			}
			if (push_binop(FLOWSPEC_OP_BIT_MATCH, (yyvsp[-2].v.number)) == -1)
				YYERROR;
			/* check if extra mask op is needed */
			if ((yyvsp[0].v.number) & ~(yyvsp[-2].v.number)) {
				if (push_binop(FLOWSPEC_OP_BIT_NOT |
				    FLOWSPEC_OP_AND, (yyvsp[0].v.number) & ~(yyvsp[-2].v.number)) == -1)
					YYERROR;
			}
		}
#line 3910 "parse.c"
    break;

  case 148: /* flags: '/' flag  */
#line 1357 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (push_binop(FLOWSPEC_OP_BIT_NOT, (yyvsp[0].v.number)) == -1)
				YYERROR;
		}
#line 3919 "parse.c"
    break;

  case 149: /* flags: flag  */
#line 1361 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (push_binop(0, (yyvsp[0].v.number)) == -1)
				YYERROR;
		}
#line 3928 "parse.c"
    break;

  case 151: /* flag: STRING  */
#line 1368 "../../../openbgpd-portable/src/bgpd/parse.y"
                         {
			if (((yyval.v.number) = parse_flags((yyvsp[0].v.string))) < 0) {
				yyerror("bad flags %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 3941 "parse.c"
    break;

  case 156: /* icmp_item: icmptype  */
#line 1386 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			curflow->type = FLOWSPEC_TYPE_ICMP_TYPE;
			if (push_unary_numop(OP_EQ, (yyvsp[0].v.number)) == -1)
				YYERROR;
		}
#line 3951 "parse.c"
    break;

  case 157: /* icmp_item: icmptype CODE STRING  */
#line 1391 "../../../openbgpd-portable/src/bgpd/parse.y"
                                       {
			int code;

			if ((code = geticmpcodebyname((yyvsp[-2].v.number), (yyvsp[0].v.string), curflow->aid)) ==
			    -1) {
				yyerror("unknown icmp-code %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));

			curflow->type = FLOWSPEC_TYPE_ICMP_TYPE;
			if (push_unary_numop(OP_EQ, (yyvsp[-2].v.number)) == -1)
				YYERROR;
			curflow->type = FLOWSPEC_TYPE_ICMP_CODE;
			if (push_unary_numop(OP_EQ, code) == -1)
				YYERROR;
		}
#line 3974 "parse.c"
    break;

  case 158: /* icmp_item: icmptype CODE NUMBER  */
#line 1409 "../../../openbgpd-portable/src/bgpd/parse.y"
                                       {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > 255) {
				yyerror("illegal icmp-code %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			curflow->type = FLOWSPEC_TYPE_ICMP_TYPE;
			if (push_unary_numop(OP_EQ, (yyvsp[-2].v.number)) == -1)
				YYERROR;
			curflow->type = FLOWSPEC_TYPE_ICMP_CODE;
			if (push_unary_numop(OP_EQ, (yyvsp[0].v.number)) == -1)
				YYERROR;
		}
#line 3991 "parse.c"
    break;

  case 159: /* icmptype: STRING  */
#line 1423 "../../../openbgpd-portable/src/bgpd/parse.y"
                         {
			int type;

			if ((type = geticmptypebyname((yyvsp[0].v.string), curflow->aid)) ==
			    -1) {
				yyerror("unknown icmp-type %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			(yyval.v.number) = type;
			free((yyvsp[0].v.string));
		}
#line 4008 "parse.c"
    break;

  case 160: /* icmptype: NUMBER  */
#line 1435 "../../../openbgpd-portable/src/bgpd/parse.y"
                         {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > 255) {
				yyerror("illegal icmp-type %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			(yyval.v.number) = (yyvsp[0].v.number);
		}
#line 4020 "parse.c"
    break;

  case 161: /* tos: STRING  */
#line 1444 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			int val;
			char *end;

			if (map_tos((yyvsp[0].v.string), &val))
				(yyval.v.number) = val;
			else if ((yyvsp[0].v.string)[0] == '0' && (yyvsp[0].v.string)[1] == 'x') {
				errno = 0;
				(yyval.v.number) = strtoul((yyvsp[0].v.string), &end, 16);
				if (errno || *end != '\0')
					(yyval.v.number) = 256;
			} else
				(yyval.v.number) = 256;
			if ((yyval.v.number) < 0 || (yyval.v.number) > 255) {
				yyerror("illegal tos value %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 4045 "parse.c"
    break;

  case 162: /* tos: NUMBER  */
#line 1464 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyval.v.number) < 0 || (yyval.v.number) > 255) {
				yyerror("illegal tos value %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			(yyval.v.number) = (yyvsp[0].v.number);
		}
#line 4057 "parse.c"
    break;

  case 167: /* length_item: length  */
#line 1481 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (push_unary_numop(OP_EQ, (yyvsp[0].v.number)) == -1)
				YYERROR;
		}
#line 4066 "parse.c"
    break;

  case 168: /* length_item: unaryop length  */
#line 1485 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (push_unary_numop((yyvsp[-1].v.u8), (yyvsp[0].v.number)) == -1)
				YYERROR;
		}
#line 4075 "parse.c"
    break;

  case 169: /* length_item: length binaryop length  */
#line 1489 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (push_binary_numop((yyvsp[-1].v.u8), (yyvsp[-2].v.number), (yyvsp[0].v.number)) == -1)
				YYERROR;
		}
#line 4084 "parse.c"
    break;

  case 170: /* length: NUMBER  */
#line 1495 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if ((yyval.v.number) < 0 || (yyval.v.number) > USHRT_MAX) {
				yyerror("illegal ptk length value %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			(yyval.v.number) = (yyvsp[0].v.number);
		}
#line 4096 "parse.c"
    break;

  case 171: /* inout: IN  */
#line 1503 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.number) = 1; }
#line 4102 "parse.c"
    break;

  case 172: /* inout: OUT  */
#line 1504 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.number) = 0; }
#line 4108 "parse.c"
    break;

  case 173: /* restricted: %empty  */
#line 1507 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.number) = 0; }
#line 4114 "parse.c"
    break;

  case 174: /* restricted: RESTRICTED  */
#line 1508 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.number) = 1; }
#line 4120 "parse.c"
    break;

  case 175: /* address: STRING  */
#line 1511 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			uint8_t	len;

			if (!host((yyvsp[0].v.string), &(yyval.v.addr), &len)) {
				yyerror("could not parse address spec \"%s\"",
				    (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));

			if (((yyval.v.addr).aid == AID_INET && len != 32) ||
			    ((yyval.v.addr).aid == AID_INET6 && len != 128)) {
				/* unreachable */
				yyerror("got prefixlen %u, expected %u",
				    len, (yyval.v.addr).aid == AID_INET ? 32 : 128);
				YYERROR;
			}
		}
#line 4144 "parse.c"
    break;

  case 176: /* prefix: STRING '/' NUMBER  */
#line 1532 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			char	*s;
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > 128) {
				yyerror("bad prefixlen %lld", (yyvsp[0].v.number));
				free((yyvsp[-2].v.string));
				YYERROR;
			}
			if (asprintf(&s, "%s/%lld", (yyvsp[-2].v.string), (yyvsp[0].v.number)) == -1)
				fatal(NULL);
			free((yyvsp[-2].v.string));

			if (!host(s, &(yyval.v.prefix).prefix, &(yyval.v.prefix).len)) {
				yyerror("could not parse address \"%s\"", s);
				free(s);
				YYERROR;
			}
			free(s);
		}
#line 4167 "parse.c"
    break;

  case 177: /* prefix: NUMBER '/' NUMBER  */
#line 1550 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			char	*s;

			/* does not match IPv6 */
			if ((yyvsp[-2].v.number) < 0 || (yyvsp[-2].v.number) > 255 || (yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > 32) {
				yyerror("bad prefix %lld/%lld", (yyvsp[-2].v.number), (yyvsp[0].v.number));
				YYERROR;
			}
			if (asprintf(&s, "%lld/%lld", (yyvsp[-2].v.number), (yyvsp[0].v.number)) == -1)
				fatal(NULL);

			if (!host(s, &(yyval.v.prefix).prefix, &(yyval.v.prefix).len)) {
				yyerror("could not parse address \"%s\"", s);
				free(s);
				YYERROR;
			}
			free(s);
		}
#line 4190 "parse.c"
    break;

  case 178: /* addrspec: address  */
#line 1570 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			memcpy(&(yyval.v.prefix).prefix, &(yyvsp[0].v.addr), sizeof(struct bgpd_addr));
			if ((yyval.v.prefix).prefix.aid == AID_INET)
				(yyval.v.prefix).len = 32;
			else
				(yyval.v.prefix).len = 128;
		}
#line 4202 "parse.c"
    break;

  case 180: /* optnumber: %empty  */
#line 1580 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        { (yyval.v.number) = 0; }
#line 4208 "parse.c"
    break;

  case 182: /* $@12: %empty  */
#line 1584 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			u_int rdomain, label;

			if (get_mpe_config((yyvsp[0].v.string), &rdomain, &label) == -1) {
				if ((cmd_opts & BGPD_OPT_NOACTION) == 0) {
					yyerror("troubles getting config of %s",
					    (yyvsp[0].v.string));
					free((yyvsp[0].v.string));
					free((yyvsp[-2].v.string));
					YYERROR;
				}
			}

			if (!(curvpn = calloc(1, sizeof(struct l3vpn))))
				fatal(NULL);
			strlcpy(curvpn->ifmpe, (yyvsp[0].v.string), IFNAMSIZ);

			if (strlcpy(curvpn->descr, (yyvsp[-2].v.string),
			    sizeof(curvpn->descr)) >=
			    sizeof(curvpn->descr)) {
				yyerror("descr \"%s\" too long: max %zu",
				    (yyvsp[-2].v.string), sizeof(curvpn->descr) - 1);
				free((yyvsp[-2].v.string));
				free((yyvsp[0].v.string));
				free(curvpn);
				curvpn = NULL;
				YYERROR;
			}
			free((yyvsp[-2].v.string));
			free((yyvsp[0].v.string));

			TAILQ_INIT(&curvpn->import);
			TAILQ_INIT(&curvpn->export);
			TAILQ_INIT(&curvpn->net_l);
			curvpn->label = label;
			curvpn->rtableid = rdomain;
			netconf = &curvpn->net_l;
		}
#line 4251 "parse.c"
    break;

  case 183: /* l3vpn: VPN STRING ON STRING $@12 '{' l3vpnopts_l '}'  */
#line 1621 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			/* insert into list */
			SIMPLEQ_INSERT_TAIL(&conf->l3vpns, curvpn, entry);
			curvpn = NULL;
			netconf = &conf->networks;
		}
#line 4262 "parse.c"
    break;

  case 188: /* l3vpnopts: RD STRING  */
#line 1635 "../../../openbgpd-portable/src/bgpd/parse.y"
                            {
			struct community	ext;

			memset(&ext, 0, sizeof(ext));
			if (parseextcommunity(&ext, "rt", (yyvsp[0].v.string)) == -1) {
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
			/*
			 * RD is almost encoded like an ext-community,
			 * but only almost so convert here.
			 */
			if (community_to_rd(&ext, &curvpn->rd) == -1) {
				yyerror("bad encoding of rd");
				YYERROR;
			}
		}
#line 4285 "parse.c"
    break;

  case 189: /* l3vpnopts: EXPORTTRGT STRING STRING  */
#line 1653 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			struct filter_set	*set;

			if ((set = calloc(1, sizeof(struct filter_set))) ==
			    NULL)
				fatal(NULL);
			set->type = ACTION_SET_COMMUNITY;
			if (parseextcommunity(&set->action.community,
			    (yyvsp[-1].v.string), (yyvsp[0].v.string)) == -1) {
				free((yyvsp[0].v.string));
				free((yyvsp[-1].v.string));
				free(set);
				YYERROR;
			}
			free((yyvsp[0].v.string));
			free((yyvsp[-1].v.string));
			TAILQ_INSERT_TAIL(&curvpn->export, set, entry);
		}
#line 4308 "parse.c"
    break;

  case 190: /* l3vpnopts: IMPORTTRGT STRING STRING  */
#line 1671 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			struct filter_set	*set;

			if ((set = calloc(1, sizeof(struct filter_set))) ==
			    NULL)
				fatal(NULL);
			set->type = ACTION_SET_COMMUNITY;
			if (parseextcommunity(&set->action.community,
			    (yyvsp[-1].v.string), (yyvsp[0].v.string)) == -1) {
				free((yyvsp[0].v.string));
				free((yyvsp[-1].v.string));
				free(set);
				YYERROR;
			}
			free((yyvsp[0].v.string));
			free((yyvsp[-1].v.string));
			TAILQ_INSERT_TAIL(&curvpn->import, set, entry);
		}
#line 4331 "parse.c"
    break;

  case 191: /* l3vpnopts: FIBUPDATE yesno  */
#line 1689 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if ((yyvsp[0].v.number) == 0)
				curvpn->flags |= F_RIB_NOFIBSYNC;
			else
				curvpn->flags &= ~F_RIB_NOFIBSYNC;
		}
#line 4342 "parse.c"
    break;

  case 193: /* $@13: %empty  */
#line 1698 "../../../openbgpd-portable/src/bgpd/parse.y"
                  {	curpeer = new_peer(); }
#line 4348 "parse.c"
    break;

  case 194: /* $@14: %empty  */
#line 1699 "../../../openbgpd-portable/src/bgpd/parse.y"
                                      {
			memcpy(&curpeer->conf.remote_addr, &(yyvsp[0].v.prefix).prefix,
			    sizeof(curpeer->conf.remote_addr));
			curpeer->conf.remote_masklen = (yyvsp[0].v.prefix).len;
			if (((yyvsp[0].v.prefix).prefix.aid == AID_INET && (yyvsp[0].v.prefix).len != 32) ||
			    ((yyvsp[0].v.prefix).prefix.aid == AID_INET6 && (yyvsp[0].v.prefix).len != 128))
				curpeer->conf.template = 1;
			curpeer->conf.capabilities.mp[
			    curpeer->conf.remote_addr.aid] = 1;
			if (get_id(curpeer)) {
				yyerror("get_id failed");
				YYERROR;
			}
		}
#line 4367 "parse.c"
    break;

  case 195: /* neighbor: $@13 NEIGHBOR addrspec $@14 peeropts_h  */
#line 1713 "../../../openbgpd-portable/src/bgpd/parse.y"
                               {
			if (curpeer_filter[0] != NULL)
				TAILQ_INSERT_TAIL(peerfilter_l,
				    curpeer_filter[0], entry);
			if (curpeer_filter[1] != NULL)
				TAILQ_INSERT_TAIL(peerfilter_l,
				    curpeer_filter[1], entry);
			curpeer_filter[0] = NULL;
			curpeer_filter[1] = NULL;

			if (neighbor_consistent(curpeer) == -1) {
				free(curpeer);
				YYERROR;
			}
			if (RB_INSERT(peer_head, new_peers, curpeer) != NULL)
				fatalx("%s: peer tree is corrupt", __func__);
			curpeer = curgroup;
		}
#line 4390 "parse.c"
    break;

  case 196: /* $@15: %empty  */
#line 1733 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			curgroup = curpeer = new_group();
			if (strlcpy(curgroup->conf.group, (yyvsp[0].v.string),
			    sizeof(curgroup->conf.group)) >=
			    sizeof(curgroup->conf.group)) {
				yyerror("group name \"%s\" too long: max %zu",
				    (yyvsp[0].v.string), sizeof(curgroup->conf.group) - 1);
				free((yyvsp[0].v.string));
				free(curgroup);
				YYERROR;
			}
			free((yyvsp[0].v.string));
			if (get_id(curgroup)) {
				yyerror("get_id failed");
				free(curgroup);
				YYERROR;
			}
		}
#line 4413 "parse.c"
    break;

  case 197: /* group: GROUP string $@15 '{' groupopts_l '}'  */
#line 1750 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (curgroup_filter[0] != NULL)
				TAILQ_INSERT_TAIL(groupfilter_l,
				    curgroup_filter[0], entry);
			if (curgroup_filter[1] != NULL)
				TAILQ_INSERT_TAIL(groupfilter_l,
				    curgroup_filter[1], entry);
			curgroup_filter[0] = NULL;
			curgroup_filter[1] = NULL;

			free(curgroup);
			curgroup = NULL;
		}
#line 4431 "parse.c"
    break;

  case 203: /* addpathextra: %empty  */
#line 1772 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        { (yyval.v.number) = 0;	}
#line 4437 "parse.c"
    break;

  case 204: /* addpathextra: PLUS NUMBER  */
#line 1773 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.number) < 1 || (yyvsp[0].v.number) > USHRT_MAX) {
				yyerror("additional paths must be between "
				    "%u and %u", 1, USHRT_MAX);
				YYERROR;
			}
			(yyval.v.number) = (yyvsp[0].v.number);
		}
#line 4450 "parse.c"
    break;

  case 205: /* addpathmax: %empty  */
#line 1783 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        { (yyval.v.number) = 0;	}
#line 4456 "parse.c"
    break;

  case 206: /* addpathmax: MAX NUMBER  */
#line 1784 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.number) < 1 || (yyvsp[0].v.number) > USHRT_MAX) {
				yyerror("maximum additional paths must be "
				    "between %u and %u", 1, USHRT_MAX);
				YYERROR;
			}
			(yyval.v.number) = (yyvsp[0].v.number);
		}
#line 4469 "parse.c"
    break;

  case 214: /* peeropts: REMOTEAS as4number  */
#line 1805 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			curpeer->conf.remote_as = (yyvsp[0].v.number);
		}
#line 4477 "parse.c"
    break;

  case 215: /* peeropts: LOCALAS as4number  */
#line 1808 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			curpeer->conf.local_as = (yyvsp[0].v.number);
			if ((yyvsp[0].v.number) > USHRT_MAX)
				curpeer->conf.local_short_as = AS_TRANS;
			else
				curpeer->conf.local_short_as = (yyvsp[0].v.number);
		}
#line 4489 "parse.c"
    break;

  case 216: /* peeropts: LOCALAS as4number asnumber  */
#line 1815 "../../../openbgpd-portable/src/bgpd/parse.y"
                                             {
			curpeer->conf.local_as = (yyvsp[-1].v.number);
			curpeer->conf.local_short_as = (yyvsp[0].v.number);
		}
#line 4498 "parse.c"
    break;

  case 217: /* peeropts: DESCR string  */
#line 1819 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (strlcpy(curpeer->conf.descr, (yyvsp[0].v.string),
			    sizeof(curpeer->conf.descr)) >=
			    sizeof(curpeer->conf.descr)) {
				yyerror("descr \"%s\" too long: max %zu",
				    (yyvsp[0].v.string), sizeof(curpeer->conf.descr) - 1);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 4514 "parse.c"
    break;

  case 218: /* peeropts: LOCALADDR address  */
#line 1830 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.addr).aid == AID_INET)
				memcpy(&curpeer->conf.local_addr_v4, &(yyvsp[0].v.addr),
				    sizeof(curpeer->conf.local_addr_v4));
			else if ((yyvsp[0].v.addr).aid == AID_INET6)
				memcpy(&curpeer->conf.local_addr_v6, &(yyvsp[0].v.addr),
				    sizeof(curpeer->conf.local_addr_v6));
			else {
				yyerror("Unsupported address family %s for "
				    "local-addr", aid2str((yyvsp[0].v.addr).aid));
				YYERROR;
			}
		}
#line 4532 "parse.c"
    break;

  case 219: /* peeropts: yesno LOCALADDR  */
#line 1843 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[-1].v.number)) {
				yyerror("bad local-address definition");
				YYERROR;
			}
			memset(&curpeer->conf.local_addr_v4, 0,
			    sizeof(curpeer->conf.local_addr_v4));
			memset(&curpeer->conf.local_addr_v6, 0,
			    sizeof(curpeer->conf.local_addr_v6));
		}
#line 4547 "parse.c"
    break;

  case 220: /* peeropts: MULTIHOP NUMBER  */
#line 1853 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.number) < 2 || (yyvsp[0].v.number) > 255) {
				yyerror("invalid multihop distance %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			curpeer->conf.distance = (yyvsp[0].v.number);
		}
#line 4559 "parse.c"
    break;

  case 221: /* peeropts: PASSIVE  */
#line 1860 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			curpeer->conf.passive = 1;
		}
#line 4567 "parse.c"
    break;

  case 222: /* peeropts: DOWN  */
#line 1863 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			curpeer->conf.down = 1;
		}
#line 4575 "parse.c"
    break;

  case 223: /* peeropts: DOWN STRING  */
#line 1866 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			curpeer->conf.down = 1;
			if (strlcpy(curpeer->conf.reason, (yyvsp[0].v.string),
				sizeof(curpeer->conf.reason)) >=
				sizeof(curpeer->conf.reason)) {
				    yyerror("shutdown reason too long");
				    free((yyvsp[0].v.string));
				    YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 4591 "parse.c"
    break;

  case 224: /* peeropts: RIB STRING  */
#line 1877 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			if (!find_rib((yyvsp[0].v.string))) {
				yyerror("rib \"%s\" does not exist.", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			if (strlcpy(curpeer->conf.rib, (yyvsp[0].v.string),
			    sizeof(curpeer->conf.rib)) >=
			    sizeof(curpeer->conf.rib)) {
				yyerror("rib name \"%s\" too long: max %zu",
				    (yyvsp[0].v.string), sizeof(curpeer->conf.rib) - 1);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 4612 "parse.c"
    break;

  case 225: /* peeropts: HOLDTIME NUMBER  */
#line 1893 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.number) < MIN_HOLDTIME || (yyvsp[0].v.number) > USHRT_MAX) {
				yyerror("holdtime must be between %u and %u",
				    MIN_HOLDTIME, USHRT_MAX);
				YYERROR;
			}
			curpeer->conf.holdtime = (yyvsp[0].v.number);
		}
#line 4625 "parse.c"
    break;

  case 226: /* peeropts: HOLDTIME YMIN NUMBER  */
#line 1901 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.number) < MIN_HOLDTIME || (yyvsp[0].v.number) > USHRT_MAX) {
				yyerror("holdtime must be between %u and %u",
				    MIN_HOLDTIME, USHRT_MAX);
				YYERROR;
			}
			curpeer->conf.min_holdtime = (yyvsp[0].v.number);
		}
#line 4638 "parse.c"
    break;

  case 227: /* peeropts: ANNOUNCE af safi enforce  */
#line 1909 "../../../openbgpd-portable/src/bgpd/parse.y"
                                           {
			uint8_t		aid, safi;
			uint16_t	afi;

			if ((yyvsp[-1].v.number) == SAFI_NONE) {
				for (aid = AID_MIN; aid < AID_MAX; aid++) {
					if (aid2afi(aid, &afi, &safi) == -1 ||
					    afi != (yyvsp[-2].v.number))
						continue;
					curpeer->conf.capabilities.mp[aid] = 0;
				}
			} else {
				if (afi2aid((yyvsp[-2].v.number), (yyvsp[-1].v.number), &aid) == -1) {
					yyerror("unknown AFI/SAFI pair");
					YYERROR;
				}
				if ((yyvsp[0].v.number))
					curpeer->conf.capabilities.mp[aid] = 2;
				else
					curpeer->conf.capabilities.mp[aid] = 1;
			}
		}
#line 4665 "parse.c"
    break;

  case 228: /* peeropts: ANNOUNCE REFRESH yesnoenforce  */
#line 1931 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			curpeer->conf.capabilities.refresh = (yyvsp[0].v.number);
		}
#line 4673 "parse.c"
    break;

  case 229: /* peeropts: ANNOUNCE ENHANCED REFRESH yesnoenforce  */
#line 1934 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                         {
			curpeer->conf.capabilities.enhanced_rr = (yyvsp[0].v.number);
		}
#line 4681 "parse.c"
    break;

  case 230: /* peeropts: ANNOUNCE RESTART yesnoenforce  */
#line 1937 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			curpeer->conf.capabilities.grestart.restart = (yyvsp[0].v.number);
		}
#line 4689 "parse.c"
    break;

  case 231: /* peeropts: ANNOUNCE AS4BYTE yesnoenforce  */
#line 1940 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			curpeer->conf.capabilities.as4byte = (yyvsp[0].v.number);
		}
#line 4697 "parse.c"
    break;

  case 232: /* peeropts: ANNOUNCE ADDPATH RECV yesnoenforce  */
#line 1943 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                     {
			int8_t *ap = curpeer->conf.capabilities.add_path;
			uint8_t i;

			for (i = AID_MIN; i < AID_MAX; i++) {
				if ((yyvsp[0].v.number)) {
					if ((yyvsp[0].v.number) == 2)
						ap[i] |= CAPA_AP_RECV_ENFORCE;
					ap[i] |= CAPA_AP_RECV;
				} else
					ap[i] &= ~CAPA_AP_RECV;
			}
		}
#line 4715 "parse.c"
    break;

  case 233: /* peeropts: ANNOUNCE ADDPATH SEND STRING addpathextra addpathmax enforce  */
#line 1956 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                                               {
			int8_t *ap = curpeer->conf.capabilities.add_path;
			enum addpath_mode mode;
			u_int8_t i;

			if (!strcmp((yyvsp[-3].v.string), "no")) {
				free((yyvsp[-3].v.string));
				if ((yyvsp[-2].v.number) != 0 || (yyvsp[-1].v.number) != 0 || (yyvsp[0].v.number) != 0) {
					yyerror("no additional option allowed "
					    "for 'add-path send no'");
					YYERROR;
				}
				mode = ADDPATH_EVAL_NONE;
			} else if (!strcmp((yyvsp[-3].v.string), "all")) {
				free((yyvsp[-3].v.string));
				if ((yyvsp[-2].v.number) != 0 || (yyvsp[-1].v.number) != 0) {
					yyerror("no additional option allowed "
					    "for 'add-path send all'");
					YYERROR;
				}
				mode = ADDPATH_EVAL_ALL;
			} else if (!strcmp((yyvsp[-3].v.string), "best")) {
				free((yyvsp[-3].v.string));
				mode = ADDPATH_EVAL_BEST;
			} else if (!strcmp((yyvsp[-3].v.string), "ecmp")) {
				free((yyvsp[-3].v.string));
				mode = ADDPATH_EVAL_ECMP;
			} else if (!strcmp((yyvsp[-3].v.string), "as-wide-best")) {
				free((yyvsp[-3].v.string));
				mode = ADDPATH_EVAL_AS_WIDE;
			} else {
				yyerror("announce add-path send: "
				    "unknown mode \"%s\"", (yyvsp[-3].v.string));
				free((yyvsp[-3].v.string));
				YYERROR;
			}
			for (i = AID_MIN; i < AID_MAX; i++) {
				if (mode != ADDPATH_EVAL_NONE) {
					if ((yyvsp[0].v.number))
						ap[i] |= CAPA_AP_SEND_ENFORCE;
					ap[i] |= CAPA_AP_SEND;
				} else
					ap[i] &= ~CAPA_AP_SEND;
			}
			curpeer->conf.eval.mode = mode;
			curpeer->conf.eval.extrapaths = (yyvsp[-2].v.number);
			curpeer->conf.eval.maxpaths = (yyvsp[-1].v.number);
		}
#line 4768 "parse.c"
    break;

  case 234: /* peeropts: ANNOUNCE POLICY yesnoenforce  */
#line 2004 "../../../openbgpd-portable/src/bgpd/parse.y"
                                               {
			curpeer->conf.capabilities.policy = (yyvsp[0].v.number);
		}
#line 4776 "parse.c"
    break;

  case 235: /* peeropts: ROLE STRING  */
#line 2007 "../../../openbgpd-portable/src/bgpd/parse.y"
                              {
			if (strcmp((yyvsp[0].v.string), "provider") == 0) {
				curpeer->conf.role = ROLE_PROVIDER;
			} else if (strcmp((yyvsp[0].v.string), "rs") == 0) {
				curpeer->conf.role = ROLE_RS;
			} else if (strcmp((yyvsp[0].v.string), "rs-client") == 0) {
				curpeer->conf.role = ROLE_RS_CLIENT;
			} else if (strcmp((yyvsp[0].v.string), "customer") == 0) {
				curpeer->conf.role = ROLE_CUSTOMER;
			} else if (strcmp((yyvsp[0].v.string), "peer") == 0) {
				curpeer->conf.role = ROLE_PEER;
			} else {
				yyerror("syntax error, one of none, provider, "
				    "rs, rs-client, customer, peer expected");
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 4800 "parse.c"
    break;

  case 236: /* peeropts: ROLE NONE  */
#line 2026 "../../../openbgpd-portable/src/bgpd/parse.y"
                            {
			curpeer->conf.role = ROLE_NONE;
		}
#line 4808 "parse.c"
    break;

  case 237: /* peeropts: EXPORT NONE  */
#line 2029 "../../../openbgpd-portable/src/bgpd/parse.y"
                              {
			curpeer->conf.export_type = EXPORT_NONE;
		}
#line 4816 "parse.c"
    break;

  case 238: /* peeropts: EXPORT DEFAULTROUTE  */
#line 2032 "../../../openbgpd-portable/src/bgpd/parse.y"
                                      {
			curpeer->conf.export_type = EXPORT_DEFAULT_ROUTE;
		}
#line 4824 "parse.c"
    break;

  case 239: /* peeropts: ENFORCE NEIGHBORAS yesno  */
#line 2035 "../../../openbgpd-portable/src/bgpd/parse.y"
                                           {
			if ((yyvsp[0].v.number))
				curpeer->conf.enforce_as = ENFORCE_AS_ON;
			else
				curpeer->conf.enforce_as = ENFORCE_AS_OFF;
		}
#line 4835 "parse.c"
    break;

  case 240: /* peeropts: ENFORCE LOCALAS yesno  */
#line 2041 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.number))
				curpeer->conf.enforce_local_as = ENFORCE_AS_ON;
			else
				curpeer->conf.enforce_local_as = ENFORCE_AS_OFF;
		}
#line 4846 "parse.c"
    break;

  case 241: /* peeropts: ASOVERRIDE yesno  */
#line 2047 "../../../openbgpd-portable/src/bgpd/parse.y"
                                   {
			if ((yyvsp[0].v.number)) {
				struct filter_rule	*r;
				struct filter_set	*s;

				if ((s = calloc(1, sizeof(struct filter_set)))
				    == NULL)
					fatal(NULL);
				s->type = ACTION_SET_AS_OVERRIDE;

				r = get_rule(s->type);
				if (merge_filterset(&r->set, s) == -1)
					YYERROR;
			}
		}
#line 4866 "parse.c"
    break;

  case 242: /* peeropts: MAXPREFIX NUMBER restart  */
#line 2062 "../../../openbgpd-portable/src/bgpd/parse.y"
                                           {
			if ((yyvsp[-1].v.number) < 0 || (yyvsp[-1].v.number) > UINT_MAX) {
				yyerror("bad maximum number of prefixes");
				YYERROR;
			}
			curpeer->conf.max_prefix = (yyvsp[-1].v.number);
			curpeer->conf.max_prefix_restart = (yyvsp[0].v.number);
		}
#line 4879 "parse.c"
    break;

  case 243: /* peeropts: MAXPREFIX NUMBER OUT restart  */
#line 2070 "../../../openbgpd-portable/src/bgpd/parse.y"
                                               {
			if ((yyvsp[-2].v.number) < 0 || (yyvsp[-2].v.number) > UINT_MAX) {
				yyerror("bad maximum number of prefixes");
				YYERROR;
			}
			curpeer->conf.max_out_prefix = (yyvsp[-2].v.number);
			curpeer->conf.max_out_prefix_restart = (yyvsp[0].v.number);
		}
#line 4892 "parse.c"
    break;

  case 244: /* peeropts: TCP MD5SIG PASSWORD string  */
#line 2078 "../../../openbgpd-portable/src/bgpd/parse.y"
                                             {
			if (curpeer->conf.auth.method) {
				yyerror("auth method cannot be redefined");
				free((yyvsp[0].v.string));
				YYERROR;
			}
			if (strlcpy(curpeer->conf.auth.md5key, (yyvsp[0].v.string),
			    sizeof(curpeer->conf.auth.md5key)) >=
			    sizeof(curpeer->conf.auth.md5key)) {
				yyerror("tcp md5sig password too long: max %zu",
				    sizeof(curpeer->conf.auth.md5key) - 1);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			curpeer->conf.auth.method = AUTH_MD5SIG;
			curpeer->conf.auth.md5key_len = strlen((yyvsp[0].v.string));
			free((yyvsp[0].v.string));
		}
#line 4915 "parse.c"
    break;

  case 245: /* peeropts: TCP MD5SIG KEY string  */
#line 2096 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (curpeer->conf.auth.method) {
				yyerror("auth method cannot be redefined");
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (str2key((yyvsp[0].v.string), curpeer->conf.auth.md5key,
			    sizeof(curpeer->conf.auth.md5key)) == -1) {
				free((yyvsp[0].v.string));
				YYERROR;
			}
			curpeer->conf.auth.method = AUTH_MD5SIG;
			curpeer->conf.auth.md5key_len = strlen((yyvsp[0].v.string)) / 2;
			free((yyvsp[0].v.string));
		}
#line 4936 "parse.c"
    break;

  case 246: /* peeropts: IPSEC espah IKE  */
#line 2112 "../../../openbgpd-portable/src/bgpd/parse.y"
                                  {
			if (curpeer->conf.auth.method) {
				yyerror("auth method cannot be redefined");
				YYERROR;
			}
			if ((yyvsp[-1].v.number))
				curpeer->conf.auth.method = AUTH_IPSEC_IKE_ESP;
			else
				curpeer->conf.auth.method = AUTH_IPSEC_IKE_AH;
		}
#line 4951 "parse.c"
    break;

  case 247: /* peeropts: IPSEC espah inout SPI NUMBER STRING STRING encspec  */
#line 2122 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                                     {
			enum auth_alg	auth_alg;
			uint8_t		keylen;

			if (curpeer->conf.auth.method &&
			    (((curpeer->conf.auth.spi_in && (yyvsp[-5].v.number) == 1) ||
			    (curpeer->conf.auth.spi_out && (yyvsp[-5].v.number) == 0)) ||
			    ((yyvsp[-6].v.number) == 1 && curpeer->conf.auth.method !=
			    AUTH_IPSEC_MANUAL_ESP) ||
			    ((yyvsp[-6].v.number) == 0 && curpeer->conf.auth.method !=
			    AUTH_IPSEC_MANUAL_AH))) {
				yyerror("auth method cannot be redefined");
				free((yyvsp[-2].v.string));
				free((yyvsp[-1].v.string));
				YYERROR;
			}

			if (!strcmp((yyvsp[-2].v.string), "sha1")) {
				auth_alg = AUTH_AALG_SHA1HMAC;
				keylen = 20;
			} else if (!strcmp((yyvsp[-2].v.string), "md5")) {
				auth_alg = AUTH_AALG_MD5HMAC;
				keylen = 16;
			} else {
				yyerror("unknown auth algorithm \"%s\"", (yyvsp[-2].v.string));
				free((yyvsp[-2].v.string));
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			free((yyvsp[-2].v.string));

			if (strlen((yyvsp[-1].v.string)) / 2 != keylen) {
				yyerror("auth key len: must be %u bytes, "
				    "is %zu bytes", keylen, strlen((yyvsp[-1].v.string)) / 2);
				free((yyvsp[-1].v.string));
				YYERROR;
			}

			if ((yyvsp[-6].v.number))
				curpeer->conf.auth.method =
				    AUTH_IPSEC_MANUAL_ESP;
			else {
				if ((yyvsp[0].v.encspec).enc_alg) {
					yyerror("\"ipsec ah\" doesn't take "
					    "encryption keys");
					free((yyvsp[-1].v.string));
					YYERROR;
				}
				curpeer->conf.auth.method =
				    AUTH_IPSEC_MANUAL_AH;
			}

			if ((yyvsp[-3].v.number) <= SPI_RESERVED_MAX || (yyvsp[-3].v.number) > UINT_MAX) {
				yyerror("bad spi number %lld", (yyvsp[-3].v.number));
				free((yyvsp[-1].v.string));
				YYERROR;
			}

			if ((yyvsp[-5].v.number) == 1) {
				if (str2key((yyvsp[-1].v.string), curpeer->conf.auth.auth_key_in,
				    sizeof(curpeer->conf.auth.auth_key_in)) ==
				    -1) {
					free((yyvsp[-1].v.string));
					YYERROR;
				}
				curpeer->conf.auth.spi_in = (yyvsp[-3].v.number);
				curpeer->conf.auth.auth_alg_in = auth_alg;
				curpeer->conf.auth.enc_alg_in = (yyvsp[0].v.encspec).enc_alg;
				memcpy(&curpeer->conf.auth.enc_key_in,
				    &(yyvsp[0].v.encspec).enc_key,
				    sizeof(curpeer->conf.auth.enc_key_in));
				curpeer->conf.auth.enc_keylen_in =
				    (yyvsp[0].v.encspec).enc_key_len;
				curpeer->conf.auth.auth_keylen_in = keylen;
			} else {
				if (str2key((yyvsp[-1].v.string), curpeer->conf.auth.auth_key_out,
				    sizeof(curpeer->conf.auth.auth_key_out)) ==
				    -1) {
					free((yyvsp[-1].v.string));
					YYERROR;
				}
				curpeer->conf.auth.spi_out = (yyvsp[-3].v.number);
				curpeer->conf.auth.auth_alg_out = auth_alg;
				curpeer->conf.auth.enc_alg_out = (yyvsp[0].v.encspec).enc_alg;
				memcpy(&curpeer->conf.auth.enc_key_out,
				    &(yyvsp[0].v.encspec).enc_key,
				    sizeof(curpeer->conf.auth.enc_key_out));
				curpeer->conf.auth.enc_keylen_out =
				    (yyvsp[0].v.encspec).enc_key_len;
				curpeer->conf.auth.auth_keylen_out = keylen;
			}
			free((yyvsp[-1].v.string));
		}
#line 5049 "parse.c"
    break;

  case 248: /* peeropts: TTLSECURITY yesno  */
#line 2215 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			curpeer->conf.ttlsec = (yyvsp[0].v.number);
		}
#line 5057 "parse.c"
    break;

  case 249: /* peeropts: SET filter_set_opt  */
#line 2218 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			struct filter_rule	*r;

			r = get_rule((yyvsp[0].v.filter_set)->type);
			if (merge_filterset(&r->set, (yyvsp[0].v.filter_set)) == -1)
				YYERROR;
		}
#line 5069 "parse.c"
    break;

  case 250: /* peeropts: SET '{' optnl filter_set_l optnl '}'  */
#line 2225 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			struct filter_rule	*r;
			struct filter_set	*s;

			while ((s = TAILQ_FIRST((yyvsp[-2].v.filter_set_head))) != NULL) {
				TAILQ_REMOVE((yyvsp[-2].v.filter_set_head), s, entry);
				r = get_rule(s->type);
				if (merge_filterset(&r->set, s) == -1)
					YYERROR;
			}
			free((yyvsp[-2].v.filter_set_head));
		}
#line 5086 "parse.c"
    break;

  case 252: /* peeropts: REFLECTOR  */
#line 2238 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((conf->flags & BGPD_FLAG_REFLECTOR) &&
			    conf->clusterid != 0) {
				yyerror("only one route reflector "
				    "cluster allowed");
				YYERROR;
			}
			conf->flags |= BGPD_FLAG_REFLECTOR;
			curpeer->conf.reflector_client = 1;
		}
#line 5101 "parse.c"
    break;

  case 253: /* peeropts: REFLECTOR address  */
#line 2248 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.addr).aid != AID_INET) {
				yyerror("route reflector cluster-id must be "
				    "an IPv4 address");
				YYERROR;
			}
			if ((conf->flags & BGPD_FLAG_REFLECTOR) &&
			    conf->clusterid != ntohl((yyvsp[0].v.addr).v4.s_addr)) {
				yyerror("only one route reflector "
				    "cluster allowed");
				YYERROR;
			}
			conf->flags |= BGPD_FLAG_REFLECTOR;
			curpeer->conf.reflector_client = 1;
			conf->clusterid = ntohl((yyvsp[0].v.addr).v4.s_addr);
		}
#line 5122 "parse.c"
    break;

  case 254: /* peeropts: DEPEND ON STRING  */
#line 2264 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (strlcpy(curpeer->conf.if_depend, (yyvsp[0].v.string),
			    sizeof(curpeer->conf.if_depend)) >=
			    sizeof(curpeer->conf.if_depend)) {
				yyerror("interface name \"%s\" too long: "
				    "max %zu", (yyvsp[0].v.string),
				    sizeof(curpeer->conf.if_depend) - 1);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 5139 "parse.c"
    break;

  case 255: /* peeropts: DEMOTE STRING  */
#line 2276 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
#ifdef HAVE_CARP
			if (strlcpy(curpeer->conf.demote_group, (yyvsp[0].v.string),
			    sizeof(curpeer->conf.demote_group)) >=
			    sizeof(curpeer->conf.demote_group)) {
				yyerror("demote group name \"%s\" too long: "
				    "max %zu", (yyvsp[0].v.string),
				    sizeof(curpeer->conf.demote_group) - 1);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
			if (carp_demote_init(curpeer->conf.demote_group,
			    cmd_opts & BGPD_OPT_FORCE_DEMOTE) == -1) {
				yyerror("error initializing group \"%s\"",
				    curpeer->conf.demote_group);
				YYERROR;
			}
#else
			yyerror("carp demote not supported");
			free((yyvsp[0].v.string));
			YYERROR;
#endif
		}
#line 5168 "parse.c"
    break;

  case 256: /* peeropts: TRANSPARENT yesno  */
#line 2300 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.number) == 1)
				curpeer->conf.flags |= PEERFLAG_TRANS_AS;
			else
				curpeer->conf.flags &= ~PEERFLAG_TRANS_AS;
		}
#line 5179 "parse.c"
    break;

  case 257: /* peeropts: LOG STRING  */
#line 2306 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (!strcmp((yyvsp[0].v.string), "updates"))
				curpeer->conf.flags |= PEERFLAG_LOG_UPDATES;
			else if (!strcmp((yyvsp[0].v.string), "no"))
				curpeer->conf.flags &= ~PEERFLAG_LOG_UPDATES;
			else {
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 5195 "parse.c"
    break;

  case 258: /* peeropts: REJECT ASSET yesno  */
#line 2317 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.number) == 1)
				curpeer->conf.flags |= PEERFLAG_NO_AS_SET;
			else
				curpeer->conf.flags &= ~PEERFLAG_NO_AS_SET;
		}
#line 5206 "parse.c"
    break;

  case 259: /* peeropts: PORT port  */
#line 2323 "../../../openbgpd-portable/src/bgpd/parse.y"
                            {
			curpeer->conf.remote_port = (yyvsp[0].v.number);
		}
#line 5214 "parse.c"
    break;

  case 260: /* peeropts: RDE EVALUATE STRING  */
#line 2326 "../../../openbgpd-portable/src/bgpd/parse.y"
                                      {
			if (!strcmp((yyvsp[0].v.string), "all"))
				curpeer->conf.flags |= PEERFLAG_EVALUATE_ALL;
			else if (!strcmp((yyvsp[0].v.string), "default"))
				curpeer->conf.flags &= ~PEERFLAG_EVALUATE_ALL;
			else {
				yyerror("rde evaluate: "
				    "unknown setting \"%s\"", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 5232 "parse.c"
    break;

  case 261: /* restart: %empty  */
#line 2341 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        { (yyval.v.number) = 0; }
#line 5238 "parse.c"
    break;

  case 262: /* restart: RESTART NUMBER  */
#line 2342 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.number) < 1 || (yyvsp[0].v.number) > USHRT_MAX) {
				yyerror("restart out of range. 1 to %u minutes",
				    USHRT_MAX);
				YYERROR;
			}
			(yyval.v.number) = (yyvsp[0].v.number);
		}
#line 5251 "parse.c"
    break;

  case 263: /* af: IPV4  */
#line 2352 "../../../openbgpd-portable/src/bgpd/parse.y"
                        { (yyval.v.number) = AFI_IPv4; }
#line 5257 "parse.c"
    break;

  case 264: /* af: IPV6  */
#line 2353 "../../../openbgpd-portable/src/bgpd/parse.y"
                        { (yyval.v.number) = AFI_IPv6; }
#line 5263 "parse.c"
    break;

  case 265: /* safi: NONE  */
#line 2356 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.number) = SAFI_NONE; }
#line 5269 "parse.c"
    break;

  case 266: /* safi: UNICAST  */
#line 2357 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.number) = SAFI_UNICAST; }
#line 5275 "parse.c"
    break;

  case 267: /* safi: VPN  */
#line 2358 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.number) = SAFI_MPLSVPN; }
#line 5281 "parse.c"
    break;

  case 268: /* safi: FLOWSPEC  */
#line 2359 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.number) = SAFI_FLOWSPEC; }
#line 5287 "parse.c"
    break;

  case 269: /* nettype: STATIC  */
#line 2362 "../../../openbgpd-portable/src/bgpd/parse.y"
                         { (yyval.v.number) = 1; }
#line 5293 "parse.c"
    break;

  case 270: /* nettype: CONNECTED  */
#line 2363 "../../../openbgpd-portable/src/bgpd/parse.y"
                            { (yyval.v.number) = 0; }
#line 5299 "parse.c"
    break;

  case 271: /* espah: ESP  */
#line 2366 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.number) = 1; }
#line 5305 "parse.c"
    break;

  case 272: /* espah: AH  */
#line 2367 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.number) = 0; }
#line 5311 "parse.c"
    break;

  case 273: /* encspec: %empty  */
#line 2370 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			memset(&(yyval.v.encspec), 0, sizeof((yyval.v.encspec)));
		}
#line 5319 "parse.c"
    break;

  case 274: /* encspec: STRING STRING  */
#line 2373 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			memset(&(yyval.v.encspec), 0, sizeof((yyval.v.encspec)));
			if (!strcmp((yyvsp[-1].v.string), "3des") || !strcmp((yyvsp[-1].v.string), "3des-cbc")) {
				(yyval.v.encspec).enc_alg = AUTH_EALG_3DESCBC;
				(yyval.v.encspec).enc_key_len = 21; /* XXX verify */
			} else if (!strcmp((yyvsp[-1].v.string), "aes") ||
			    !strcmp((yyvsp[-1].v.string), "aes-128-cbc")) {
				(yyval.v.encspec).enc_alg = AUTH_EALG_AES;
				(yyval.v.encspec).enc_key_len = 16;
			} else {
				yyerror("unknown enc algorithm \"%s\"", (yyvsp[-1].v.string));
				free((yyvsp[-1].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[-1].v.string));

			if (strlen((yyvsp[0].v.string)) / 2 != (yyval.v.encspec).enc_key_len) {
				yyerror("enc key length wrong: should be %u "
				    "bytes, is %zu bytes",
				    (yyval.v.encspec).enc_key_len * 2, strlen((yyvsp[0].v.string)));
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (str2key((yyvsp[0].v.string), (yyval.v.encspec).enc_key, sizeof((yyval.v.encspec).enc_key)) == -1) {
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 5355 "parse.c"
    break;

  case 275: /* filterrule: action quick filter_rib_h direction filter_peer_h filter_match_h filter_set  */
#line 2408 "../../../openbgpd-portable/src/bgpd/parse.y"
                {
			struct filter_rule	 r;
			struct filter_rib_l	 *rb, *rbnext;

			memset(&r, 0, sizeof(r));
			r.action = (yyvsp[-6].v.u8);
			r.quick = (yyvsp[-5].v.u8);
			r.dir = (yyvsp[-3].v.u8);
			if ((yyvsp[-4].v.filter_rib)) {
				if (r.dir != DIR_IN) {
					yyerror("rib only allowed on \"from\" "
					    "rules.");

					for (rb = (yyvsp[-4].v.filter_rib); rb != NULL; rb = rbnext) {
						rbnext = rb->next;
						free(rb);
					}
					YYERROR;
				}
			}
			if (expand_rule(&r, (yyvsp[-4].v.filter_rib), (yyvsp[-2].v.filter_peers), &(yyvsp[-1].v.filter_match), (yyvsp[0].v.filter_set_head)) == -1)
				YYERROR;
		}
#line 5383 "parse.c"
    break;

  case 276: /* action: ALLOW  */
#line 2433 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = ACTION_ALLOW; }
#line 5389 "parse.c"
    break;

  case 277: /* action: DENY  */
#line 2434 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = ACTION_DENY; }
#line 5395 "parse.c"
    break;

  case 278: /* action: MATCH  */
#line 2435 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = ACTION_NONE; }
#line 5401 "parse.c"
    break;

  case 279: /* quick: %empty  */
#line 2438 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = 0; }
#line 5407 "parse.c"
    break;

  case 280: /* quick: QUICK  */
#line 2439 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = 1; }
#line 5413 "parse.c"
    break;

  case 281: /* direction: FROM  */
#line 2442 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = DIR_IN; }
#line 5419 "parse.c"
    break;

  case 282: /* direction: TO  */
#line 2443 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = DIR_OUT; }
#line 5425 "parse.c"
    break;

  case 283: /* filter_rib_h: %empty  */
#line 2446 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                { (yyval.v.filter_rib) = NULL; }
#line 5431 "parse.c"
    break;

  case 284: /* filter_rib_h: RIB filter_rib  */
#line 2447 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                { (yyval.v.filter_rib) = (yyvsp[0].v.filter_rib); }
#line 5437 "parse.c"
    break;

  case 285: /* filter_rib_h: RIB '{' optnl filter_rib_l optnl '}'  */
#line 2448 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        { (yyval.v.filter_rib) = (yyvsp[-2].v.filter_rib); }
#line 5443 "parse.c"
    break;

  case 286: /* filter_rib_l: filter_rib  */
#line 2450 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                { (yyval.v.filter_rib) = (yyvsp[0].v.filter_rib); }
#line 5449 "parse.c"
    break;

  case 287: /* filter_rib_l: filter_rib_l comma filter_rib  */
#line 2451 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			(yyvsp[0].v.filter_rib)->next = (yyvsp[-2].v.filter_rib);
			(yyval.v.filter_rib) = (yyvsp[0].v.filter_rib);
		}
#line 5458 "parse.c"
    break;

  case 288: /* filter_rib: STRING  */
#line 2457 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			if (!find_rib((yyvsp[0].v.string))) {
				yyerror("rib \"%s\" does not exist.", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			if (((yyval.v.filter_rib) = calloc(1, sizeof(struct filter_rib_l))) ==
			    NULL)
				fatal(NULL);
			(yyval.v.filter_rib)->next = NULL;
			if (strlcpy((yyval.v.filter_rib)->name, (yyvsp[0].v.string), sizeof((yyval.v.filter_rib)->name)) >=
			    sizeof((yyval.v.filter_rib)->name)) {
				yyerror("rib name \"%s\" too long: "
				    "max %zu", (yyvsp[0].v.string), sizeof((yyval.v.filter_rib)->name) - 1);
				free((yyvsp[0].v.string));
				free((yyval.v.filter_rib));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 5483 "parse.c"
    break;

  case 290: /* filter_peer_h: '{' optnl filter_peer_l optnl '}'  */
#line 2480 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        { (yyval.v.filter_peers) = (yyvsp[-2].v.filter_peers); }
#line 5489 "parse.c"
    break;

  case 291: /* filter_peer_l: filter_peer  */
#line 2483 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        { (yyval.v.filter_peers) = (yyvsp[0].v.filter_peers); }
#line 5495 "parse.c"
    break;

  case 292: /* filter_peer_l: filter_peer_l comma filter_peer  */
#line 2484 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			(yyvsp[0].v.filter_peers)->next = (yyvsp[-2].v.filter_peers);
			(yyval.v.filter_peers) = (yyvsp[0].v.filter_peers);
		}
#line 5504 "parse.c"
    break;

  case 293: /* filter_peer: ANY  */
#line 2490 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			if (((yyval.v.filter_peers) = calloc(1, sizeof(struct filter_peers_l))) ==
			    NULL)
				fatal(NULL);
			(yyval.v.filter_peers)->p.peerid = (yyval.v.filter_peers)->p.groupid = 0;
			(yyval.v.filter_peers)->next = NULL;
		}
#line 5516 "parse.c"
    break;

  case 294: /* filter_peer: address  */
#line 2497 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			struct peer *p;

			if (((yyval.v.filter_peers) = calloc(1, sizeof(struct filter_peers_l))) ==
			    NULL)
				fatal(NULL);
			(yyval.v.filter_peers)->p.remote_as = (yyval.v.filter_peers)->p.groupid = (yyval.v.filter_peers)->p.peerid = 0;
			(yyval.v.filter_peers)->next = NULL;
			RB_FOREACH(p, peer_head, new_peers)
				if (!memcmp(&p->conf.remote_addr,
				    &(yyvsp[0].v.addr), sizeof(p->conf.remote_addr))) {
					(yyval.v.filter_peers)->p.peerid = p->conf.id;
					break;
				}
			if ((yyval.v.filter_peers)->p.peerid == 0) {
				yyerror("no such peer: %s", log_addr(&(yyvsp[0].v.addr)));
				free((yyval.v.filter_peers));
				YYERROR;
			}
		}
#line 5541 "parse.c"
    break;

  case 295: /* filter_peer: AS as4number  */
#line 2517 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			if (((yyval.v.filter_peers) = calloc(1, sizeof(struct filter_peers_l))) ==
			    NULL)
				fatal(NULL);
			(yyval.v.filter_peers)->p.groupid = (yyval.v.filter_peers)->p.peerid = 0;
			(yyval.v.filter_peers)->p.remote_as = (yyvsp[0].v.number);
		}
#line 5553 "parse.c"
    break;

  case 296: /* filter_peer: GROUP STRING  */
#line 2524 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			struct peer *p;

			if (((yyval.v.filter_peers) = calloc(1, sizeof(struct filter_peers_l))) ==
			    NULL)
				fatal(NULL);
			(yyval.v.filter_peers)->p.remote_as = (yyval.v.filter_peers)->p.peerid = 0;
			(yyval.v.filter_peers)->next = NULL;
			RB_FOREACH(p, peer_head, new_peers)
				if (!strcmp(p->conf.group, (yyvsp[0].v.string))) {
					(yyval.v.filter_peers)->p.groupid = p->conf.groupid;
					break;
				}
			if ((yyval.v.filter_peers)->p.groupid == 0) {
				yyerror("no such group: \"%s\"", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				free((yyval.v.filter_peers));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 5579 "parse.c"
    break;

  case 297: /* filter_peer: EBGP  */
#line 2545 "../../../openbgpd-portable/src/bgpd/parse.y"
                       {
			if (((yyval.v.filter_peers) = calloc(1, sizeof(struct filter_peers_l))) ==
			    NULL)
				fatal(NULL);
			(yyval.v.filter_peers)->p.ebgp = 1;
		}
#line 5590 "parse.c"
    break;

  case 298: /* filter_peer: IBGP  */
#line 2551 "../../../openbgpd-portable/src/bgpd/parse.y"
                       {
			if (((yyval.v.filter_peers) = calloc(1, sizeof(struct filter_peers_l))) ==
			    NULL)
				fatal(NULL);
			(yyval.v.filter_peers)->p.ibgp = 1;
		}
#line 5601 "parse.c"
    break;

  case 299: /* filter_prefix_h: IPV4 prefixlenop  */
#line 2559 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                         {
			if ((yyvsp[0].v.prefixlen).op == OP_NONE) {
				(yyvsp[0].v.prefixlen).op = OP_RANGE;
				(yyvsp[0].v.prefixlen).len_min = 0;
				(yyvsp[0].v.prefixlen).len_max = -1;
			}
			if (((yyval.v.filter_prefix) = calloc(1, sizeof(struct filter_prefix_l))) ==
			    NULL)
				fatal(NULL);
			(yyval.v.filter_prefix)->p.addr.aid = AID_INET;
			if (merge_prefixspec(&(yyval.v.filter_prefix)->p, &(yyvsp[0].v.prefixlen)) == -1) {
				free((yyval.v.filter_prefix));
				YYERROR;
			}
		}
#line 5621 "parse.c"
    break;

  case 300: /* filter_prefix_h: IPV6 prefixlenop  */
#line 2574 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			if ((yyvsp[0].v.prefixlen).op == OP_NONE) {
				(yyvsp[0].v.prefixlen).op = OP_RANGE;
				(yyvsp[0].v.prefixlen).len_min = 0;
				(yyvsp[0].v.prefixlen).len_max = -1;
			}
			if (((yyval.v.filter_prefix) = calloc(1, sizeof(struct filter_prefix_l))) ==
			    NULL)
				fatal(NULL);
			(yyval.v.filter_prefix)->p.addr.aid = AID_INET6;
			if (merge_prefixspec(&(yyval.v.filter_prefix)->p, &(yyvsp[0].v.prefixlen)) == -1) {
				free((yyval.v.filter_prefix));
				YYERROR;
			}
		}
#line 5641 "parse.c"
    break;

  case 301: /* filter_prefix_h: PREFIX filter_prefix  */
#line 2589 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        { (yyval.v.filter_prefix) = (yyvsp[0].v.filter_prefix); }
#line 5647 "parse.c"
    break;

  case 302: /* filter_prefix_h: PREFIX '{' filter_prefix_m '}'  */
#line 2590 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        { (yyval.v.filter_prefix) = (yyvsp[-1].v.filter_prefix); }
#line 5653 "parse.c"
    break;

  case 304: /* filter_prefix_m: '{' filter_prefix_l '}'  */
#line 2594 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        { (yyval.v.filter_prefix) = (yyvsp[-1].v.filter_prefix); }
#line 5659 "parse.c"
    break;

  case 305: /* filter_prefix_m: '{' filter_prefix_l '}' filter_prefix_m  */
#line 2596 "../../../openbgpd-portable/src/bgpd/parse.y"
                {
			struct filter_prefix_l	*p;

			/* merge, both can be lists */
			for (p = (yyvsp[-2].v.filter_prefix); p != NULL && p->next != NULL; p = p->next)
				;	/* nothing */
			if (p != NULL)
				p->next = (yyvsp[0].v.filter_prefix);
			(yyval.v.filter_prefix) = (yyvsp[-2].v.filter_prefix);
		}
#line 5674 "parse.c"
    break;

  case 306: /* filter_prefix_l: filter_prefix  */
#line 2607 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                { (yyval.v.filter_prefix) = (yyvsp[0].v.filter_prefix); }
#line 5680 "parse.c"
    break;

  case 307: /* filter_prefix_l: filter_prefix_l comma filter_prefix  */
#line 2608 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			(yyvsp[0].v.filter_prefix)->next = (yyvsp[-2].v.filter_prefix);
			(yyval.v.filter_prefix) = (yyvsp[0].v.filter_prefix);
		}
#line 5689 "parse.c"
    break;

  case 308: /* filter_prefix: prefix prefixlenop  */
#line 2614 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			if (((yyval.v.filter_prefix) = calloc(1, sizeof(struct filter_prefix_l))) ==
			    NULL)
				fatal(NULL);
			memcpy(&(yyval.v.filter_prefix)->p.addr, &(yyvsp[-1].v.prefix).prefix,
			    sizeof((yyval.v.filter_prefix)->p.addr));
			(yyval.v.filter_prefix)->p.len = (yyvsp[-1].v.prefix).len;

			if (merge_prefixspec(&(yyval.v.filter_prefix)->p, &(yyvsp[0].v.prefixlen)) == -1) {
				free((yyval.v.filter_prefix));
				YYERROR;
			}
		}
#line 5707 "parse.c"
    break;

  case 310: /* filter_as_h: '{' filter_as_t_l '}'  */
#line 2630 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                { (yyval.v.filter_as) = (yyvsp[-1].v.filter_as); }
#line 5713 "parse.c"
    break;

  case 312: /* filter_as_t_l: filter_as_t_l comma filter_as_t  */
#line 2634 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                                {
			struct filter_as_l	*a;

			/* merge, both can be lists */
			for (a = (yyvsp[-2].v.filter_as); a != NULL && a->next != NULL; a = a->next)
				;	/* nothing */
			if (a != NULL)
				a->next = (yyvsp[0].v.filter_as);
			(yyval.v.filter_as) = (yyvsp[-2].v.filter_as);
		}
#line 5728 "parse.c"
    break;

  case 313: /* filter_as_t: filter_as_type filter_as  */
#line 2646 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                                {
			(yyval.v.filter_as) = (yyvsp[0].v.filter_as);
			(yyval.v.filter_as)->a.type = (yyvsp[-1].v.u8);
		}
#line 5737 "parse.c"
    break;

  case 314: /* filter_as_t: filter_as_type '{' filter_as_l_h '}'  */
#line 2650 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			struct filter_as_l	*a;

			(yyval.v.filter_as) = (yyvsp[-1].v.filter_as);
			for (a = (yyval.v.filter_as); a != NULL; a = a->next)
				a->a.type = (yyvsp[-3].v.u8);
		}
#line 5749 "parse.c"
    break;

  case 315: /* filter_as_t: filter_as_type ASSET STRING  */
#line 2657 "../../../openbgpd-portable/src/bgpd/parse.y"
                                              {
			if (as_sets_lookup(&conf->as_sets, (yyvsp[0].v.string)) == NULL) {
				yyerror("as-set \"%s\" not defined", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			if (((yyval.v.filter_as) = calloc(1, sizeof(struct filter_as_l))) ==
			    NULL)
				fatal(NULL);
			(yyval.v.filter_as)->a.type = (yyvsp[-2].v.u8);
			(yyval.v.filter_as)->a.flags = AS_FLAG_AS_SET_NAME;
			if (strlcpy((yyval.v.filter_as)->a.name, (yyvsp[0].v.string), sizeof((yyval.v.filter_as)->a.name)) >=
			    sizeof((yyval.v.filter_as)->a.name)) {
				yyerror("as-set name \"%s\" too long: "
				    "max %zu", (yyvsp[0].v.string), sizeof((yyval.v.filter_as)->a.name) - 1);
				free((yyvsp[0].v.string));
				free((yyval.v.filter_as));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 5775 "parse.c"
    break;

  case 317: /* filter_as_l_h: '{' filter_as_l '}'  */
#line 2681 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        { (yyval.v.filter_as) = (yyvsp[-1].v.filter_as); }
#line 5781 "parse.c"
    break;

  case 318: /* filter_as_l_h: '{' filter_as_l '}' filter_as_l_h  */
#line 2683 "../../../openbgpd-portable/src/bgpd/parse.y"
                {
			struct filter_as_l	*a;

			/* merge, both can be lists */
			for (a = (yyvsp[-2].v.filter_as); a != NULL && a->next != NULL; a = a->next)
				;	/* nothing */
			if (a != NULL)
				a->next = (yyvsp[0].v.filter_as);
			(yyval.v.filter_as) = (yyvsp[-2].v.filter_as);
		}
#line 5796 "parse.c"
    break;

  case 320: /* filter_as_l: filter_as_l comma filter_as  */
#line 2696 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			(yyvsp[0].v.filter_as)->next = (yyvsp[-2].v.filter_as);
			(yyval.v.filter_as) = (yyvsp[0].v.filter_as);
		}
#line 5805 "parse.c"
    break;

  case 321: /* filter_as: as4number_any  */
#line 2702 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (((yyval.v.filter_as) = calloc(1, sizeof(struct filter_as_l))) ==
			    NULL)
				fatal(NULL);
			(yyval.v.filter_as)->a.as_min = (yyvsp[0].v.number);
			(yyval.v.filter_as)->a.as_max = (yyvsp[0].v.number);
			(yyval.v.filter_as)->a.op = OP_EQ;
		}
#line 5818 "parse.c"
    break;

  case 322: /* filter_as: NEIGHBORAS  */
#line 2710 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (((yyval.v.filter_as) = calloc(1, sizeof(struct filter_as_l))) ==
			    NULL)
				fatal(NULL);
			(yyval.v.filter_as)->a.flags = AS_FLAG_NEIGHBORAS;
		}
#line 5829 "parse.c"
    break;

  case 323: /* filter_as: equalityop as4number_any  */
#line 2716 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (((yyval.v.filter_as) = calloc(1, sizeof(struct filter_as_l))) ==
			    NULL)
				fatal(NULL);
			(yyval.v.filter_as)->a.op = (yyvsp[-1].v.u8);
			(yyval.v.filter_as)->a.as_min = (yyvsp[0].v.number);
			(yyval.v.filter_as)->a.as_max = (yyvsp[0].v.number);
		}
#line 5842 "parse.c"
    break;

  case 324: /* filter_as: as4number_any binaryop as4number_any  */
#line 2724 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                       {
			if (((yyval.v.filter_as) = calloc(1, sizeof(struct filter_as_l))) ==
			    NULL)
				fatal(NULL);
			if ((yyvsp[-2].v.number) >= (yyvsp[0].v.number)) {
				yyerror("start AS is bigger than end");
				YYERROR;
			}
			(yyval.v.filter_as)->a.op = (yyvsp[-1].v.u8);
			(yyval.v.filter_as)->a.as_min = (yyvsp[-2].v.number);
			(yyval.v.filter_as)->a.as_max = (yyvsp[0].v.number);
		}
#line 5859 "parse.c"
    break;

  case 325: /* filter_match_h: %empty  */
#line 2738 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			memset(&(yyval.v.filter_match), 0, sizeof((yyval.v.filter_match)));
		}
#line 5867 "parse.c"
    break;

  case 326: /* $@16: %empty  */
#line 2741 "../../../openbgpd-portable/src/bgpd/parse.y"
                  {
			memset(&fmopts, 0, sizeof(fmopts));
		}
#line 5875 "parse.c"
    break;

  case 327: /* filter_match_h: $@16 filter_match  */
#line 2744 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			memcpy(&(yyval.v.filter_match), &fmopts, sizeof((yyval.v.filter_match)));
		}
#line 5883 "parse.c"
    break;

  case 330: /* filter_elm: filter_prefix_h  */
#line 2753 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (fmopts.prefix_l != NULL) {
				yyerror("\"prefix\" already specified");
				YYERROR;
			}
			if (fmopts.m.prefixset.name[0] != '\0') {
				yyerror("\"prefix-set\" already specified, "
				    "cannot be used with \"prefix\" in the "
				    "same filter rule");
				YYERROR;
			}
			fmopts.prefix_l = (yyvsp[0].v.filter_prefix);
		}
#line 5901 "parse.c"
    break;

  case 331: /* filter_elm: filter_as_h  */
#line 2766 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (fmopts.as_l != NULL) {
				yyerror("AS filters already specified");
				YYERROR;
			}
			fmopts.as_l = (yyvsp[0].v.filter_as);
		}
#line 5913 "parse.c"
    break;

  case 332: /* filter_elm: MAXASLEN NUMBER  */
#line 2773 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (fmopts.m.aslen.type != ASLEN_NONE) {
				yyerror("AS length filters already specified");
				YYERROR;
			}
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > UINT_MAX) {
				yyerror("bad max-as-len %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			fmopts.m.aslen.type = ASLEN_MAX;
			fmopts.m.aslen.aslen = (yyvsp[0].v.number);
		}
#line 5930 "parse.c"
    break;

  case 333: /* filter_elm: MAXASSEQ NUMBER  */
#line 2785 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (fmopts.m.aslen.type != ASLEN_NONE) {
				yyerror("AS length filters already specified");
				YYERROR;
			}
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > UINT_MAX) {
				yyerror("bad max-as-seq %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			fmopts.m.aslen.type = ASLEN_SEQ;
			fmopts.m.aslen.aslen = (yyvsp[0].v.number);
		}
#line 5947 "parse.c"
    break;

  case 334: /* filter_elm: community STRING  */
#line 2797 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			int i;
			for (i = 0; i < MAX_COMM_MATCH; i++) {
				if (fmopts.m.community[i].flags == 0)
					break;
			}
			if (i >= MAX_COMM_MATCH) {
				yyerror("too many \"community\" filters "
				    "specified");
				free((yyvsp[0].v.string));
				YYERROR;
			}
			if (parsecommunity(&fmopts.m.community[i], (yyvsp[-1].v.u8), (yyvsp[0].v.string)) == -1) {
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 5970 "parse.c"
    break;

  case 335: /* filter_elm: EXTCOMMUNITY STRING STRING  */
#line 2815 "../../../openbgpd-portable/src/bgpd/parse.y"
                                             {
			int i;
			for (i = 0; i < MAX_COMM_MATCH; i++) {
				if (fmopts.m.community[i].flags == 0)
					break;
			}
			if (i >= MAX_COMM_MATCH) {
				yyerror("too many \"community\" filters "
				    "specified");
				free((yyvsp[-1].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			if (parseextcommunity(&fmopts.m.community[i],
			    (yyvsp[-1].v.string), (yyvsp[0].v.string)) == -1) {
				free((yyvsp[-1].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[-1].v.string));
			free((yyvsp[0].v.string));
		}
#line 5997 "parse.c"
    break;

  case 336: /* filter_elm: EXTCOMMUNITY OVS STRING  */
#line 2837 "../../../openbgpd-portable/src/bgpd/parse.y"
                                          {
			int i;
			for (i = 0; i < MAX_COMM_MATCH; i++) {
				if (fmopts.m.community[i].flags == 0)
					break;
			}
			if (i >= MAX_COMM_MATCH) {
				yyerror("too many \"community\" filters "
				    "specified");
				free((yyvsp[0].v.string));
				YYERROR;
			}
			if (parseextcommunity(&fmopts.m.community[i],
			    "ovs", (yyvsp[0].v.string)) == -1) {
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 6021 "parse.c"
    break;

  case 337: /* filter_elm: MAXCOMMUNITIES NUMBER  */
#line 2856 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > INT16_MAX) {
				yyerror("bad max-comunities %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			if (fmopts.m.maxcomm != 0) {
				yyerror("%s already specified",
				    "max-communities");
				YYERROR;
			}
			/*
			 * Offset by 1 since 0 means not used.
			 * The match function then uses >= to compensate.
			 */
			fmopts.m.maxcomm = (yyvsp[0].v.number) + 1;
		}
#line 6042 "parse.c"
    break;

  case 338: /* filter_elm: MAXEXTCOMMUNITIES NUMBER  */
#line 2872 "../../../openbgpd-portable/src/bgpd/parse.y"
                                           {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > INT16_MAX) {
				yyerror("bad max-ext-communities %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			if (fmopts.m.maxextcomm != 0) {
				yyerror("%s already specified",
				    "max-ext-communities");
				YYERROR;
			}
			fmopts.m.maxextcomm = (yyvsp[0].v.number) + 1;
		}
#line 6059 "parse.c"
    break;

  case 339: /* filter_elm: MAXLARGECOMMUNITIES NUMBER  */
#line 2884 "../../../openbgpd-portable/src/bgpd/parse.y"
                                             {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > INT16_MAX) {
				yyerror("bad max-large-communities %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			if (fmopts.m.maxlargecomm != 0) {
				yyerror("%s already specified",
				    "max-large-communities");
				YYERROR;
			}
			fmopts.m.maxlargecomm = (yyvsp[0].v.number) + 1;
		}
#line 6076 "parse.c"
    break;

  case 340: /* filter_elm: NEXTHOP address  */
#line 2896 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (fmopts.m.nexthop.flags) {
				yyerror("nexthop already specified");
				YYERROR;
			}
			fmopts.m.nexthop.addr = (yyvsp[0].v.addr);
			fmopts.m.nexthop.flags = FILTER_NEXTHOP_ADDR;
		}
#line 6089 "parse.c"
    break;

  case 341: /* filter_elm: NEXTHOP NEIGHBOR  */
#line 2904 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (fmopts.m.nexthop.flags) {
				yyerror("nexthop already specified");
				YYERROR;
			}
			fmopts.m.nexthop.flags = FILTER_NEXTHOP_NEIGHBOR;
		}
#line 6101 "parse.c"
    break;

  case 342: /* filter_elm: PREFIXSET STRING prefixlenop  */
#line 2911 "../../../openbgpd-portable/src/bgpd/parse.y"
                                               {
			struct prefixset *ps;
			if (fmopts.prefix_l != NULL) {
				yyerror("\"prefix\" already specified, cannot "
				    "be used with \"prefix-set\" in the same "
				    "filter rule");
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			if (fmopts.m.prefixset.name[0] != '\0') {
				yyerror("prefix-set filter already specified");
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			if ((ps = find_prefixset((yyvsp[-1].v.string), &conf->prefixsets))
			    == NULL) {
				yyerror("prefix-set '%s' not defined", (yyvsp[-1].v.string));
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			if (strlcpy(fmopts.m.prefixset.name, (yyvsp[-1].v.string),
			    sizeof(fmopts.m.prefixset.name)) >=
			    sizeof(fmopts.m.prefixset.name)) {
				yyerror("prefix-set name too long");
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			if (!((yyvsp[0].v.prefixlen).op == OP_NONE ||
			    ((yyvsp[0].v.prefixlen).op == OP_RANGE &&
			     (yyvsp[0].v.prefixlen).len_min == -1 && (yyvsp[0].v.prefixlen).len_max == -1))) {
				yyerror("prefix-sets can only use option "
				    "or-longer");
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			if ((yyvsp[0].v.prefixlen).op == OP_RANGE && ps->sflags & PREFIXSET_FLAG_OPS) {
				yyerror("prefix-set %s contains prefixlen "
				    "operators and cannot be used with an "
				    "or-longer filter", (yyvsp[-1].v.string));
				free((yyvsp[-1].v.string));
				YYERROR;
			}
			if ((yyvsp[0].v.prefixlen).op == OP_RANGE && (yyvsp[0].v.prefixlen).len_min == -1 &&
			    (yyvsp[0].v.prefixlen).len_min == -1)
				fmopts.m.prefixset.flags |=
				    PREFIXSET_FLAG_LONGER;
			fmopts.m.prefixset.flags |= PREFIXSET_FLAG_FILTER;
			free((yyvsp[-1].v.string));
		}
#line 6155 "parse.c"
    break;

  case 343: /* filter_elm: ORIGINSET STRING  */
#line 2960 "../../../openbgpd-portable/src/bgpd/parse.y"
                                   {
			if (fmopts.m.originset.name[0] != '\0') {
				yyerror("origin-set filter already specified");
				free((yyvsp[0].v.string));
				YYERROR;
			}
			if (find_prefixset((yyvsp[0].v.string), &conf->originsets) == NULL) {
				yyerror("origin-set '%s' not defined", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			if (strlcpy(fmopts.m.originset.name, (yyvsp[0].v.string),
			    sizeof(fmopts.m.originset.name)) >=
			    sizeof(fmopts.m.originset.name)) {
				yyerror("origin-set name too long");
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 6180 "parse.c"
    break;

  case 344: /* filter_elm: OVS validity  */
#line 2980 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (fmopts.m.ovs.is_set) {
				yyerror("ovs filter already specified");
				YYERROR;
			}
			fmopts.m.ovs.validity = (yyvsp[0].v.number);
			fmopts.m.ovs.is_set = 1;
		}
#line 6193 "parse.c"
    break;

  case 345: /* filter_elm: AVS aspa_validity  */
#line 2988 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (fmopts.m.avs.is_set) {
				yyerror("avs filter already specified");
				YYERROR;
			}
			fmopts.m.avs.validity = (yyvsp[0].v.number);
			fmopts.m.avs.is_set = 1;
		}
#line 6206 "parse.c"
    break;

  case 346: /* prefixlenop: %empty  */
#line 2998 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                { memset(&(yyval.v.prefixlen), 0, sizeof((yyval.v.prefixlen))); }
#line 6212 "parse.c"
    break;

  case 347: /* prefixlenop: LONGER  */
#line 2999 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			memset(&(yyval.v.prefixlen), 0, sizeof((yyval.v.prefixlen)));
			(yyval.v.prefixlen).op = OP_RANGE;
			(yyval.v.prefixlen).len_min = -1;
			(yyval.v.prefixlen).len_max = -1;
		}
#line 6223 "parse.c"
    break;

  case 348: /* prefixlenop: MAXLEN NUMBER  */
#line 3005 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			memset(&(yyval.v.prefixlen), 0, sizeof((yyval.v.prefixlen)));
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > 128) {
				yyerror("prefixlen must be >= 0 and <= 128");
				YYERROR;
			}

			(yyval.v.prefixlen).op = OP_RANGE;
			(yyval.v.prefixlen).len_min = -1;
			(yyval.v.prefixlen).len_max = (yyvsp[0].v.number);
		}
#line 6239 "parse.c"
    break;

  case 349: /* prefixlenop: PREFIXLEN unaryop NUMBER  */
#line 3016 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			int min, max;

			memset(&(yyval.v.prefixlen), 0, sizeof((yyval.v.prefixlen)));
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > 128) {
				yyerror("prefixlen must be >= 0 and <= 128");
				YYERROR;
			}
			/*
			 * convert the unary operation into the equivalent
			 * range check
			 */
			(yyval.v.prefixlen).op = OP_RANGE;

			switch ((yyvsp[-1].v.u8)) {
			case OP_NE:
				(yyval.v.prefixlen).op = (yyvsp[-1].v.u8);
			case OP_EQ:
				min = max = (yyvsp[0].v.number);
				break;
			case OP_LT:
				if ((yyvsp[0].v.number) == 0) {
					yyerror("prefixlen must be > 0");
					YYERROR;
				}
				(yyvsp[0].v.number) -= 1;
			case OP_LE:
				min = -1;
				max = (yyvsp[0].v.number);
				break;
			case OP_GT:
				(yyvsp[0].v.number) += 1;
			case OP_GE:
				min = (yyvsp[0].v.number);
				max = -1;
				break;
			default:
				yyerror("unknown prefixlen operation");
				YYERROR;
			}
			(yyval.v.prefixlen).len_min = min;
			(yyval.v.prefixlen).len_max = max;
		}
#line 6287 "parse.c"
    break;

  case 350: /* prefixlenop: PREFIXLEN NUMBER binaryop NUMBER  */
#line 3059 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			memset(&(yyval.v.prefixlen), 0, sizeof((yyval.v.prefixlen)));
			if ((yyvsp[-2].v.number) < 0 || (yyvsp[-2].v.number) > 128 || (yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > 128) {
				yyerror("prefixlen must be < 128");
				YYERROR;
			}
			if ((yyvsp[-2].v.number) > (yyvsp[0].v.number)) {
				yyerror("start prefixlen is bigger than end");
				YYERROR;
			}
			(yyval.v.prefixlen).op = (yyvsp[-1].v.u8);
			(yyval.v.prefixlen).len_min = (yyvsp[-2].v.number);
			(yyval.v.prefixlen).len_max = (yyvsp[0].v.number);
		}
#line 6306 "parse.c"
    break;

  case 351: /* filter_as_type: AS  */
#line 3075 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = AS_ALL; }
#line 6312 "parse.c"
    break;

  case 352: /* filter_as_type: SOURCEAS  */
#line 3076 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = AS_SOURCE; }
#line 6318 "parse.c"
    break;

  case 353: /* filter_as_type: TRANSITAS  */
#line 3077 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = AS_TRANSIT; }
#line 6324 "parse.c"
    break;

  case 354: /* filter_as_type: PEERAS  */
#line 3078 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = AS_PEER; }
#line 6330 "parse.c"
    break;

  case 355: /* filter_set: %empty  */
#line 3081 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                                { (yyval.v.filter_set_head) = NULL; }
#line 6336 "parse.c"
    break;

  case 356: /* filter_set: SET filter_set_opt  */
#line 3082 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                                {
			if (((yyval.v.filter_set_head) = calloc(1, sizeof(struct filter_set_head))) ==
			    NULL)
				fatal(NULL);
			TAILQ_INIT((yyval.v.filter_set_head));
			TAILQ_INSERT_TAIL((yyval.v.filter_set_head), (yyvsp[0].v.filter_set), entry);
		}
#line 6348 "parse.c"
    break;

  case 357: /* filter_set: SET '{' optnl filter_set_l optnl '}'  */
#line 3089 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        { (yyval.v.filter_set_head) = (yyvsp[-2].v.filter_set_head); }
#line 6354 "parse.c"
    break;

  case 358: /* filter_set_l: filter_set_l comma filter_set_opt  */
#line 3092 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			(yyval.v.filter_set_head) = (yyvsp[-2].v.filter_set_head);
			if (merge_filterset((yyval.v.filter_set_head), (yyvsp[0].v.filter_set)) == 1)
				YYERROR;
		}
#line 6364 "parse.c"
    break;

  case 359: /* filter_set_l: filter_set_opt  */
#line 3097 "../../../openbgpd-portable/src/bgpd/parse.y"
                                 {
			if (((yyval.v.filter_set_head) = calloc(1, sizeof(struct filter_set_head))) ==
			    NULL)
				fatal(NULL);
			TAILQ_INIT((yyval.v.filter_set_head));
			TAILQ_INSERT_TAIL((yyval.v.filter_set_head), (yyvsp[0].v.filter_set), entry);
		}
#line 6376 "parse.c"
    break;

  case 360: /* community: COMMUNITY  */
#line 3106 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        { (yyval.v.u8) = COMMUNITY_TYPE_BASIC; }
#line 6382 "parse.c"
    break;

  case 361: /* community: LARGECOMMUNITY  */
#line 3107 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        { (yyval.v.u8) = COMMUNITY_TYPE_LARGE; }
#line 6388 "parse.c"
    break;

  case 362: /* delete: %empty  */
#line 3110 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = 0; }
#line 6394 "parse.c"
    break;

  case 363: /* delete: DELETE  */
#line 3111 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = 1; }
#line 6400 "parse.c"
    break;

  case 364: /* enforce: %empty  */
#line 3114 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.number) = 0; }
#line 6406 "parse.c"
    break;

  case 365: /* enforce: ENFORCE  */
#line 3115 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.number) = 2; }
#line 6412 "parse.c"
    break;

  case 366: /* yesnoenforce: yesno  */
#line 3118 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.number) = (yyvsp[0].v.number); }
#line 6418 "parse.c"
    break;

  case 367: /* yesnoenforce: ENFORCE  */
#line 3119 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.number) = 2; }
#line 6424 "parse.c"
    break;

  case 368: /* filter_set_opt: LOCALPREF NUMBER  */
#line 3122 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if ((yyvsp[0].v.number) < -INT_MAX || (yyvsp[0].v.number) > UINT_MAX) {
				yyerror("bad localpref %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			if ((yyvsp[0].v.number) >= 0) {
				(yyval.v.filter_set)->type = ACTION_SET_LOCALPREF;
				(yyval.v.filter_set)->action.metric = (yyvsp[0].v.number);
			} else {
				(yyval.v.filter_set)->type = ACTION_SET_RELATIVE_LOCALPREF;
				(yyval.v.filter_set)->action.relative = (yyvsp[0].v.number);
			}
		}
#line 6444 "parse.c"
    break;

  case 369: /* filter_set_opt: LOCALPREF '+' NUMBER  */
#line 3137 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > INT_MAX) {
				yyerror("bad localpref +%lld", (yyvsp[0].v.number));
				YYERROR;
			}
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_RELATIVE_LOCALPREF;
			(yyval.v.filter_set)->action.relative = (yyvsp[0].v.number);
		}
#line 6459 "parse.c"
    break;

  case 370: /* filter_set_opt: LOCALPREF '-' NUMBER  */
#line 3147 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > INT_MAX) {
				yyerror("bad localpref -%lld", (yyvsp[0].v.number));
				YYERROR;
			}
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_RELATIVE_LOCALPREF;
			(yyval.v.filter_set)->action.relative = -(yyvsp[0].v.number);
		}
#line 6474 "parse.c"
    break;

  case 371: /* filter_set_opt: MED NUMBER  */
#line 3157 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if ((yyvsp[0].v.number) < -INT_MAX || (yyvsp[0].v.number) > UINT_MAX) {
				yyerror("bad metric %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			if ((yyvsp[0].v.number) >= 0) {
				(yyval.v.filter_set)->type = ACTION_SET_MED;
				(yyval.v.filter_set)->action.metric = (yyvsp[0].v.number);
			} else {
				(yyval.v.filter_set)->type = ACTION_SET_RELATIVE_MED;
				(yyval.v.filter_set)->action.relative = (yyvsp[0].v.number);
			}
		}
#line 6494 "parse.c"
    break;

  case 372: /* filter_set_opt: MED '+' NUMBER  */
#line 3172 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > INT_MAX) {
				yyerror("bad metric +%lld", (yyvsp[0].v.number));
				YYERROR;
			}
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_RELATIVE_MED;
			(yyval.v.filter_set)->action.relative = (yyvsp[0].v.number);
		}
#line 6509 "parse.c"
    break;

  case 373: /* filter_set_opt: MED '-' NUMBER  */
#line 3182 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > INT_MAX) {
				yyerror("bad metric -%lld", (yyvsp[0].v.number));
				YYERROR;
			}
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_RELATIVE_MED;
			(yyval.v.filter_set)->action.relative = -(yyvsp[0].v.number);
		}
#line 6524 "parse.c"
    break;

  case 374: /* filter_set_opt: METRIC NUMBER  */
#line 3192 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {	/* alias for MED */
			if ((yyvsp[0].v.number) < -INT_MAX || (yyvsp[0].v.number) > UINT_MAX) {
				yyerror("bad metric %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			if ((yyvsp[0].v.number) >= 0) {
				(yyval.v.filter_set)->type = ACTION_SET_MED;
				(yyval.v.filter_set)->action.metric = (yyvsp[0].v.number);
			} else {
				(yyval.v.filter_set)->type = ACTION_SET_RELATIVE_MED;
				(yyval.v.filter_set)->action.relative = (yyvsp[0].v.number);
			}
		}
#line 6544 "parse.c"
    break;

  case 375: /* filter_set_opt: METRIC '+' NUMBER  */
#line 3207 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > INT_MAX) {
				yyerror("bad metric +%lld", (yyvsp[0].v.number));
				YYERROR;
			}
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_RELATIVE_MED;
			(yyval.v.filter_set)->action.metric = (yyvsp[0].v.number);
		}
#line 6559 "parse.c"
    break;

  case 376: /* filter_set_opt: METRIC '-' NUMBER  */
#line 3217 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > INT_MAX) {
				yyerror("bad metric -%lld", (yyvsp[0].v.number));
				YYERROR;
			}
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_RELATIVE_MED;
			(yyval.v.filter_set)->action.relative = -(yyvsp[0].v.number);
		}
#line 6574 "parse.c"
    break;

  case 377: /* filter_set_opt: WEIGHT NUMBER  */
#line 3227 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			if ((yyvsp[0].v.number) < -INT_MAX || (yyvsp[0].v.number) > UINT_MAX) {
				yyerror("bad weight %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			if ((yyvsp[0].v.number) > 0) {
				(yyval.v.filter_set)->type = ACTION_SET_WEIGHT;
				(yyval.v.filter_set)->action.metric = (yyvsp[0].v.number);
			} else {
				(yyval.v.filter_set)->type = ACTION_SET_RELATIVE_WEIGHT;
				(yyval.v.filter_set)->action.relative = (yyvsp[0].v.number);
			}
		}
#line 6594 "parse.c"
    break;

  case 378: /* filter_set_opt: WEIGHT '+' NUMBER  */
#line 3242 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > INT_MAX) {
				yyerror("bad weight +%lld", (yyvsp[0].v.number));
				YYERROR;
			}
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_RELATIVE_WEIGHT;
			(yyval.v.filter_set)->action.relative = (yyvsp[0].v.number);
		}
#line 6609 "parse.c"
    break;

  case 379: /* filter_set_opt: WEIGHT '-' NUMBER  */
#line 3252 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                        {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > INT_MAX) {
				yyerror("bad weight -%lld", (yyvsp[0].v.number));
				YYERROR;
			}
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_RELATIVE_WEIGHT;
			(yyval.v.filter_set)->action.relative = -(yyvsp[0].v.number);
		}
#line 6624 "parse.c"
    break;

  case 380: /* filter_set_opt: NEXTHOP address  */
#line 3262 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_NEXTHOP;
			memcpy(&(yyval.v.filter_set)->action.nexthop, &(yyvsp[0].v.addr),
			    sizeof((yyval.v.filter_set)->action.nexthop));
		}
#line 6636 "parse.c"
    break;

  case 381: /* filter_set_opt: NEXTHOP BLACKHOLE  */
#line 3269 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_NEXTHOP_BLACKHOLE;
		}
#line 6646 "parse.c"
    break;

  case 382: /* filter_set_opt: NEXTHOP REJECT  */
#line 3274 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_NEXTHOP_REJECT;
		}
#line 6656 "parse.c"
    break;

  case 383: /* filter_set_opt: NEXTHOP NOMODIFY  */
#line 3279 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_NEXTHOP_NOMODIFY;
		}
#line 6666 "parse.c"
    break;

  case 384: /* filter_set_opt: NEXTHOP SELF  */
#line 3284 "../../../openbgpd-portable/src/bgpd/parse.y"
                                        {
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_NEXTHOP_SELF;
		}
#line 6676 "parse.c"
    break;

  case 385: /* filter_set_opt: PREPEND_SELF NUMBER  */
#line 3289 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > 128) {
				yyerror("bad number of prepends");
				YYERROR;
			}
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_PREPEND_SELF;
			(yyval.v.filter_set)->action.prepend = (yyvsp[0].v.number);
		}
#line 6691 "parse.c"
    break;

  case 386: /* filter_set_opt: PREPEND_PEER NUMBER  */
#line 3299 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if ((yyvsp[0].v.number) < 0 || (yyvsp[0].v.number) > 128) {
				yyerror("bad number of prepends");
				YYERROR;
			}
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_PREPEND_PEER;
			(yyval.v.filter_set)->action.prepend = (yyvsp[0].v.number);
		}
#line 6706 "parse.c"
    break;

  case 387: /* filter_set_opt: ASOVERRIDE  */
#line 3309 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_AS_OVERRIDE;
		}
#line 6716 "parse.c"
    break;

  case 388: /* filter_set_opt: PFTABLE STRING  */
#line 3314 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_PFTABLE;
			if (!(cmd_opts & BGPD_OPT_NOACTION) &&
			    pftable_exists((yyvsp[0].v.string)) != 0) {
				yyerror("pftable name does not exist");
				free((yyvsp[0].v.string));
				free((yyval.v.filter_set));
				YYERROR;
			}
			if (strlcpy((yyval.v.filter_set)->action.pftable, (yyvsp[0].v.string),
			    sizeof((yyval.v.filter_set)->action.pftable)) >=
			    sizeof((yyval.v.filter_set)->action.pftable)) {
				yyerror("pftable name too long");
				free((yyvsp[0].v.string));
				free((yyval.v.filter_set));
				YYERROR;
			}
			if (pftable_add((yyvsp[0].v.string)) != 0) {
				yyerror("Couldn't register table");
				free((yyvsp[0].v.string));
				free((yyval.v.filter_set));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 6748 "parse.c"
    break;

  case 389: /* filter_set_opt: RTLABEL STRING  */
#line 3341 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_RTLABEL;
			if (strlcpy((yyval.v.filter_set)->action.rtlabel, (yyvsp[0].v.string),
			    sizeof((yyval.v.filter_set)->action.rtlabel)) >=
			    sizeof((yyval.v.filter_set)->action.rtlabel)) {
				yyerror("rtlabel name too long");
				free((yyvsp[0].v.string));
				free((yyval.v.filter_set));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 6767 "parse.c"
    break;

  case 390: /* filter_set_opt: community delete STRING  */
#line 3355 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                {
			uint8_t f1, f2, f3;

			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			if ((yyvsp[-1].v.u8))
				(yyval.v.filter_set)->type = ACTION_DEL_COMMUNITY;
			else
				(yyval.v.filter_set)->type = ACTION_SET_COMMUNITY;

			if (parsecommunity(&(yyval.v.filter_set)->action.community, (yyvsp[-2].v.u8), (yyvsp[0].v.string)) ==
			    -1) {
				free((yyvsp[0].v.string));
				free((yyval.v.filter_set));
				YYERROR;
			}
			free((yyvsp[0].v.string));
			/* Don't allow setting of any match */
			f1 = (yyval.v.filter_set)->action.community.flags >> 8;
			f2 = (yyval.v.filter_set)->action.community.flags >> 16;
			f3 = (yyval.v.filter_set)->action.community.flags >> 24;
			if (!(yyvsp[-1].v.u8) && (f1 == COMMUNITY_ANY ||
			    f2 == COMMUNITY_ANY || f3 == COMMUNITY_ANY)) {
				yyerror("'*' is not allowed in set community");
				free((yyval.v.filter_set));
				YYERROR;
			}
		}
#line 6800 "parse.c"
    break;

  case 391: /* filter_set_opt: EXTCOMMUNITY delete STRING STRING  */
#line 3383 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                    {
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			if ((yyvsp[-2].v.u8))
				(yyval.v.filter_set)->type = ACTION_DEL_COMMUNITY;
			else
				(yyval.v.filter_set)->type = ACTION_SET_COMMUNITY;

			if (parseextcommunity(&(yyval.v.filter_set)->action.community,
			    (yyvsp[-1].v.string), (yyvsp[0].v.string)) == -1) {
				free((yyvsp[-1].v.string));
				free((yyvsp[0].v.string));
				free((yyval.v.filter_set));
				YYERROR;
			}
			free((yyvsp[-1].v.string));
			free((yyvsp[0].v.string));
		}
#line 6823 "parse.c"
    break;

  case 392: /* filter_set_opt: EXTCOMMUNITY delete OVS STRING  */
#line 3401 "../../../openbgpd-portable/src/bgpd/parse.y"
                                                 {
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			if ((yyvsp[-2].v.u8))
				(yyval.v.filter_set)->type = ACTION_DEL_COMMUNITY;
			else
				(yyval.v.filter_set)->type = ACTION_SET_COMMUNITY;

			if (parseextcommunity(&(yyval.v.filter_set)->action.community,
			    "ovs", (yyvsp[0].v.string)) == -1) {
				free((yyvsp[0].v.string));
				free((yyval.v.filter_set));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 6844 "parse.c"
    break;

  case 393: /* filter_set_opt: ORIGIN origincode  */
#line 3417 "../../../openbgpd-portable/src/bgpd/parse.y"
                                    {
			if (((yyval.v.filter_set) = calloc(1, sizeof(struct filter_set))) == NULL)
				fatal(NULL);
			(yyval.v.filter_set)->type = ACTION_SET_ORIGIN;
			(yyval.v.filter_set)->action.origin = (yyvsp[0].v.number);
		}
#line 6855 "parse.c"
    break;

  case 394: /* origincode: STRING  */
#line 3425 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			if (!strcmp((yyvsp[0].v.string), "egp"))
				(yyval.v.number) = ORIGIN_EGP;
			else if (!strcmp((yyvsp[0].v.string), "igp"))
				(yyval.v.number) = ORIGIN_IGP;
			else if (!strcmp((yyvsp[0].v.string), "incomplete"))
				(yyval.v.number) = ORIGIN_INCOMPLETE;
			else {
				yyerror("unknown origin \"%s\"", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 6874 "parse.c"
    break;

  case 395: /* validity: STRING  */
#line 3440 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			if (!strcmp((yyvsp[0].v.string), "not-found"))
				(yyval.v.number) = ROA_NOTFOUND;
			else if (!strcmp((yyvsp[0].v.string), "invalid"))
				(yyval.v.number) = ROA_INVALID;
			else if (!strcmp((yyvsp[0].v.string), "valid"))
				(yyval.v.number) = ROA_VALID;
			else {
				yyerror("unknown roa validity \"%s\"", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 6893 "parse.c"
    break;

  case 396: /* aspa_validity: STRING  */
#line 3455 "../../../openbgpd-portable/src/bgpd/parse.y"
                                {
			if (!strcmp((yyvsp[0].v.string), "unknown"))
				(yyval.v.number) = ASPA_UNKNOWN;
			else if (!strcmp((yyvsp[0].v.string), "invalid"))
				(yyval.v.number) = ASPA_INVALID;
			else if (!strcmp((yyvsp[0].v.string), "valid"))
				(yyval.v.number) = ASPA_VALID;
			else {
				yyerror("unknown aspa validity \"%s\"", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 6912 "parse.c"
    break;

  case 403: /* unaryop: '='  */
#line 3480 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = OP_EQ; }
#line 6918 "parse.c"
    break;

  case 404: /* unaryop: NE  */
#line 3481 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = OP_NE; }
#line 6924 "parse.c"
    break;

  case 405: /* unaryop: LE  */
#line 3482 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = OP_LE; }
#line 6930 "parse.c"
    break;

  case 406: /* unaryop: '<'  */
#line 3483 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = OP_LT; }
#line 6936 "parse.c"
    break;

  case 407: /* unaryop: GE  */
#line 3484 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = OP_GE; }
#line 6942 "parse.c"
    break;

  case 408: /* unaryop: '>'  */
#line 3485 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = OP_GT; }
#line 6948 "parse.c"
    break;

  case 409: /* equalityop: '='  */
#line 3488 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = OP_EQ; }
#line 6954 "parse.c"
    break;

  case 410: /* equalityop: NE  */
#line 3489 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = OP_NE; }
#line 6960 "parse.c"
    break;

  case 411: /* binaryop: '-'  */
#line 3492 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = OP_RANGE; }
#line 6966 "parse.c"
    break;

  case 412: /* binaryop: XRANGE  */
#line 3493 "../../../openbgpd-portable/src/bgpd/parse.y"
                                { (yyval.v.u8) = OP_XRANGE; }
#line 6972 "parse.c"
    break;


#line 6976 "parse.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 3496 "../../../openbgpd-portable/src/bgpd/parse.y"


struct keywords {
	const char	*k_name;
	int		 k_val;
};

int
yyerror(const char *fmt, ...)
{
	va_list		 ap;
	char		*msg;

	file->errors++;
	va_start(ap, fmt);
	if (vasprintf(&msg, fmt, ap) == -1)
		fatalx("yyerror vasprintf");
	va_end(ap);
	logit(LOG_CRIT, "%s:%d: %s", file->name, yylval.lineno, msg);
	free(msg);
	return (0);
}

int
kw_cmp(const void *k, const void *e)
{
	return (strcmp(k, ((const struct keywords *)e)->k_name));
}

int
lookup(char *s)
{
	/* this has to be sorted always */
	static const struct keywords keywords[] = {
		{ "AS",			AS},
		{ "IPv4",		IPV4},
		{ "IPv6",		IPV6},
		{ "add-path",		ADDPATH},
		{ "ah",			AH},
		{ "allow",		ALLOW},
		{ "announce",		ANNOUNCE},
		{ "any",		ANY},
		{ "as-4byte",		AS4BYTE },
		{ "as-override",	ASOVERRIDE},
		{ "as-set",		ASSET },
		{ "aspa-set",		ASPASET},
		{ "avs",		AVS},
		{ "blackhole",		BLACKHOLE},
		{ "community",		COMMUNITY},
		{ "compare",		COMPARE},
		{ "connect-retry",	CONNECTRETRY},
		{ "connected",		CONNECTED},
		{ "customer-as",	CUSTOMERAS},
		{ "default-route",	DEFAULTROUTE},
		{ "delete",		DELETE},
		{ "demote",		DEMOTE},
		{ "deny",		DENY},
		{ "depend",		DEPEND},
		{ "descr",		DESCR},
		{ "down",		DOWN},
		{ "dump",		DUMP},
		{ "ebgp",		EBGP},
		{ "enforce",		ENFORCE},
		{ "enhanced",		ENHANCED },
		{ "esp",		ESP},
		{ "evaluate",		EVALUATE},
		{ "expires",		EXPIRES},
		{ "export",		EXPORT},
		{ "export-target",	EXPORTTRGT},
		{ "ext-community",	EXTCOMMUNITY},
		{ "fib-priority",	FIBPRIORITY},
		{ "fib-update",		FIBUPDATE},
		{ "filtered",		FILTERED},
		{ "flags",		FLAGS},
		{ "flowspec",		FLOWSPEC},
		{ "fragment",		FRAGMENT},
		{ "from",		FROM},
		{ "group",		GROUP},
		{ "holdtime",		HOLDTIME},
		{ "ibgp",		IBGP},
		{ "ignore",		IGNORE},
		{ "ike",		IKE},
		{ "import-target",	IMPORTTRGT},
		{ "in",			IN},
		{ "include",		INCLUDE},
		{ "inet",		IPV4},
		{ "inet6",		IPV6},
		{ "ipsec",		IPSEC},
		{ "key",		KEY},
		{ "large-community",	LARGECOMMUNITY},
		{ "listen",		LISTEN},
		{ "local-address",	LOCALADDR},
		{ "local-as",		LOCALAS},
		{ "localpref",		LOCALPREF},
		{ "log",		LOG},
		{ "match",		MATCH},
		{ "max",		MAX},
		{ "max-as-len",		MAXASLEN},
		{ "max-as-seq",		MAXASSEQ},
		{ "max-communities",	MAXCOMMUNITIES},
		{ "max-ext-communities",	MAXEXTCOMMUNITIES},
		{ "max-large-communities",	MAXLARGECOMMUNITIES},
		{ "max-prefix",		MAXPREFIX},
		{ "maxlen",		MAXLEN},
		{ "md5sig",		MD5SIG},
		{ "med",		MED},
		{ "metric",		METRIC},
		{ "min",		YMIN},
		{ "min-version",	MINVERSION},
		{ "multihop",		MULTIHOP},
		{ "neighbor",		NEIGHBOR},
		{ "neighbor-as",	NEIGHBORAS},
		{ "network",		NETWORK},
		{ "nexthop",		NEXTHOP},
		{ "no-modify",		NOMODIFY},
		{ "none",		NONE},
		{ "on",			ON},
		{ "or-longer",		LONGER},
		{ "origin",		ORIGIN},
		{ "origin-set",		ORIGINSET},
		{ "out",		OUT},
		{ "ovs",		OVS},
		{ "passive",		PASSIVE},
		{ "password",		PASSWORD},
		{ "peer-as",		PEERAS},
		{ "pftable",		PFTABLE},
		{ "plus",		PLUS},
		{ "policy",		POLICY},
		{ "port",		PORT},
		{ "prefix",		PREFIX},
		{ "prefix-set",		PREFIXSET},
		{ "prefixlen",		PREFIXLEN},
		{ "prepend-neighbor",	PREPEND_PEER},
		{ "prepend-self",	PREPEND_SELF},
		{ "priority",		PRIORITY},
		{ "proto",		PROTO},
		{ "provider-as",	PROVIDERAS},
		{ "qualify",		QUALIFY},
		{ "quick",		QUICK},
		{ "rd",			RD},
		{ "rde",		RDE},
		{ "recv",		RECV},
		{ "refresh",		REFRESH },
		{ "reject",		REJECT},
		{ "remote-as",		REMOTEAS},
		{ "restart",		RESTART},
		{ "restricted",		RESTRICTED},
		{ "rib",		RIB},
		{ "roa-set",		ROASET },
		{ "role",		ROLE},
		{ "route-reflector",	REFLECTOR},
		{ "router-id",		ROUTERID},
		{ "rtable",		RTABLE},
		{ "rtlabel",		RTLABEL},
		{ "rtr",		RTR},
		{ "self",		SELF},
		{ "send",		SEND},
		{ "set",		SET},
		{ "socket",		SOCKET },
		{ "source-as",		SOURCEAS},
		{ "spi",		SPI},
		{ "static",		STATIC},
		{ "tcp",		TCP},
		{ "to",			TO},
		{ "tos",		TOS},
		{ "transit-as",		TRANSITAS},
		{ "transparent-as",	TRANSPARENT},
		{ "ttl-security",	TTLSECURITY},
		{ "unicast",		UNICAST},
		{ "via",		VIA},
		{ "vpn",		VPN},
		{ "weight",		WEIGHT}
	};
	const struct keywords	*p;

	p = bsearch(s, keywords, nitems(keywords), sizeof(keywords[0]), kw_cmp);

	if (p)
		return (p->k_val);
	else
		return (STRING);
}

#define START_EXPAND	1
#define DONE_EXPAND	2

static int	expanding;

int
igetc(void)
{
	int	c;

	while (1) {
		if (file->ungetpos > 0)
			c = file->ungetbuf[--file->ungetpos];
		else
			c = getc(file->stream);

		if (c == START_EXPAND)
			expanding = 1;
		else if (c == DONE_EXPAND)
			expanding = 0;
		else
			break;
	}
	return (c);
}

int
lgetc(int quotec)
{
	int		c, next;

	if (quotec) {
		if ((c = igetc()) == EOF) {
			yyerror("reached end of file while parsing "
			    "quoted string");
			if (file == topfile || popfile() == EOF)
				return (EOF);
			return (quotec);
		}
		return (c);
	}

	while ((c = igetc()) == '\\') {
		next = igetc();
		if (next != '\n') {
			c = next;
			break;
		}
		yylval.lineno = file->lineno;
		file->lineno++;
	}

	if (c == EOF) {
		/*
		 * Fake EOL when hit EOF for the first time. This gets line
		 * count right if last line in included file is syntactically
		 * invalid and has no newline.
		 */
		if (file->eof_reached == 0) {
			file->eof_reached = 1;
			return ('\n');
		}
		while (c == EOF) {
			if (file == topfile || popfile() == EOF)
				return (EOF);
			c = igetc();
		}
	}
	return (c);
}

void
lungetc(int c)
{
	if (c == EOF)
		return;

	if (file->ungetpos >= file->ungetsize) {
		void *p = reallocarray(file->ungetbuf, file->ungetsize, 2);
		if (p == NULL)
			err(1, "lungetc");
		file->ungetbuf = p;
		file->ungetsize *= 2;
	}
	file->ungetbuf[file->ungetpos++] = c;
}

int
findeol(void)
{
	int	c;

	/* skip to either EOF or the first real EOL */
	while (1) {
		c = lgetc(0);
		if (c == '\n') {
			file->lineno++;
			break;
		}
		if (c == EOF)
			break;
	}
	return (ERROR);
}

int
expand_macro(void)
{
	char	 buf[MACRO_NAME_LEN];
	char	*p, *val;
	int	 c;

	p = buf;
	while (1) {
		if ((c = lgetc('$')) == EOF)
			return (ERROR);
		if (p + 1 >= buf + sizeof(buf) - 1) {
			yyerror("macro name too long");
			return (ERROR);
		}
		if (isalnum(c) || c == '_') {
			*p++ = c;
			continue;
		}
		*p = '\0';
		lungetc(c);
		break;
	}
	val = symget(buf);
	if (val == NULL) {
		yyerror("macro '%s' not defined", buf);
		return (ERROR);
	}
	p = val + strlen(val) - 1;
	lungetc(DONE_EXPAND);
	while (p >= val) {
		lungetc((unsigned char)*p);
		p--;
	}
	lungetc(START_EXPAND);
	return (0);
}

int
yylex(void)
{
	char	 buf[8096];
	char	*p;
	int	 quotec, next, c;
	int	 token;

top:
	p = buf;
	while ((c = lgetc(0)) == ' ' || c == '\t')
		; /* nothing */

	yylval.lineno = file->lineno;
	if (c == '#')
		while ((c = lgetc(0)) != '\n' && c != EOF)
			; /* nothing */
	if (c == '$' && !expanding) {
		c = expand_macro();
		if (c != 0)
			return (c);
		goto top;
	}

	switch (c) {
	case '\'':
	case '"':
		quotec = c;
		while (1) {
			if ((c = lgetc(quotec)) == EOF)
				return (0);
			if (c == '\n') {
				file->lineno++;
				continue;
			} else if (c == '\\') {
				if ((next = lgetc(quotec)) == EOF)
					return (0);
				if (next == quotec || next == ' ' ||
				    next == '\t')
					c = next;
				else if (next == '\n') {
					file->lineno++;
					continue;
				} else
					lungetc(next);
			} else if (c == quotec) {
				*p = '\0';
				break;
			} else if (c == '\0') {
				yyerror("syntax error: unterminated quote");
				return (findeol());
			}
			if (p + 1 >= buf + sizeof(buf) - 1) {
				yyerror("string too long");
				return (findeol());
			}
			*p++ = c;
		}
		yylval.v.string = strdup(buf);
		if (yylval.v.string == NULL)
			fatal("yylex: strdup");
		return (STRING);
	case '!':
		next = lgetc(0);
		if (next == '=')
			return (NE);
		lungetc(next);
		break;
	case '<':
		next = lgetc(0);
		if (next == '=')
			return (LE);
		lungetc(next);
		break;
	case '>':
		next = lgetc(0);
		if (next == '<')
			return (XRANGE);
		else if (next == '=')
			return (GE);
		lungetc(next);
		break;
	}

#define allowed_to_end_number(x) \
	(isspace(x) || x == ')' || x ==',' || x == '/' || x == '}' || x == '=')

	if (c == '-' || isdigit(c)) {
		do {
			*p++ = c;
			if ((size_t)(p-buf) >= sizeof(buf)) {
				yyerror("string too long");
				return (findeol());
			}
		} while ((c = lgetc(0)) != EOF && isdigit(c));
		lungetc(c);
		if (p == buf + 1 && buf[0] == '-')
			goto nodigits;
		if (c == EOF || allowed_to_end_number(c)) {
			const char *errstr = NULL;

			*p = '\0';
			yylval.v.number = strtonum(buf, LLONG_MIN,
			    LLONG_MAX, &errstr);
			if (errstr) {
				yyerror("\"%s\" invalid number: %s",
				    buf, errstr);
				return (findeol());
			}
			return (NUMBER);
		} else {
nodigits:
			while (p > buf + 1)
				lungetc((unsigned char)*--p);
			c = (unsigned char)*--p;
			if (c == '-')
				return (c);
		}
	}

#define allowed_in_string(x) \
	(isalnum(x) || (ispunct(x) && x != '(' && x != ')' && \
	x != '{' && x != '}' && x != '<' && x != '>' && \
	x != '!' && x != '=' && x != '/' && x != '#' && \
	x != ','))

	if (isalnum(c) || c == ':' || c == '_' || c == '*') {
		do {
			if (c == '$' && !expanding) {
				c = expand_macro();
				if (c != 0)
					return (c);
			} else
				*p++ = c;

			if ((size_t)(p-buf) >= sizeof(buf)) {
				yyerror("string too long");
				return (findeol());
			}
		} while ((c = lgetc(0)) != EOF && (allowed_in_string(c)));
		lungetc(c);
		*p = '\0';
		if ((token = lookup(buf)) == STRING)
			if ((yylval.v.string = strdup(buf)) == NULL)
				fatal("yylex: strdup");
		return (token);
	}
	if (c == '\n') {
		yylval.lineno = file->lineno;
		file->lineno++;
	}
	if (c == EOF)
		return (0);
	return (c);
}

int
check_file_secrecy(int fd, const char *fname)
{
	struct stat	st;

	if (fstat(fd, &st)) {
		log_warn("cannot stat %s", fname);
		return (-1);
	}
	return (0);
}

struct file *
pushfile(const char *name, int secret)
{
	struct file	*nfile;

	if ((nfile = calloc(1, sizeof(struct file))) == NULL) {
		log_warn("%s", __func__);
		return (NULL);
	}
	if ((nfile->name = strdup(name)) == NULL) {
		log_warn("%s", __func__);
		free(nfile);
		return (NULL);
	}
	if ((nfile->stream = fopen(nfile->name, "r")) == NULL) {
		log_warn("%s: %s", __func__, nfile->name);
		free(nfile->name);
		free(nfile);
		return (NULL);
	}
	if (secret &&
	    check_file_secrecy(fileno(nfile->stream), nfile->name)) {
		fclose(nfile->stream);
		free(nfile->name);
		free(nfile);
		return (NULL);
	}
	nfile->lineno = TAILQ_EMPTY(&files) ? 1 : 0;
	nfile->ungetsize = 16;
	nfile->ungetbuf = malloc(nfile->ungetsize);
	if (nfile->ungetbuf == NULL) {
		log_warn("%s", __func__);
		fclose(nfile->stream);
		free(nfile->name);
		free(nfile);
		return (NULL);
	}
	TAILQ_INSERT_TAIL(&files, nfile, entry);
	return (nfile);
}

int
popfile(void)
{
	struct file	*prev;

	if ((prev = TAILQ_PREV(file, files, entry)) != NULL)
		prev->errors += file->errors;

	TAILQ_REMOVE(&files, file, entry);
	fclose(file->stream);
	free(file->name);
	free(file->ungetbuf);
	free(file);
	file = prev;
	return (file ? 0 : EOF);
}

static void
init_config(struct bgpd_config *c)
{
	u_int rdomid;

	c->min_holdtime = MIN_HOLDTIME;
	c->holdtime = INTERVAL_HOLD;
	c->connectretry = INTERVAL_CONNECTRETRY;
	c->bgpid = get_bgpid();
	c->fib_priority = kr_default_prio();
	c->default_tableid = getrtable();
	if (!ktable_exists(c->default_tableid, &rdomid))
		fatalx("current routing table %u does not exist",
		    c->default_tableid);
	if (rdomid != c->default_tableid)
		fatalx("current routing table %u is not a routing domain",
		    c->default_tableid);

	if (asprintf(&c->csock, "%s.%d", SOCKET_NAME, c->default_tableid) == -1)
		fatal(NULL);
}

struct bgpd_config *
parse_config(char *filename, struct peer_head *ph, struct rtr_config_head *rh)
{
	struct sym		*sym, *next;
	struct rde_rib		*rr;
	struct network		*n;
	int			 errors = 0;

	conf = new_config();
	init_config(conf);

	if ((filter_l = calloc(1, sizeof(struct filter_head))) == NULL)
		fatal(NULL);
	if ((peerfilter_l = calloc(1, sizeof(struct filter_head))) == NULL)
		fatal(NULL);
	if ((groupfilter_l = calloc(1, sizeof(struct filter_head))) == NULL)
		fatal(NULL);
	TAILQ_INIT(filter_l);
	TAILQ_INIT(peerfilter_l);
	TAILQ_INIT(groupfilter_l);

	curpeer = NULL;
	curgroup = NULL;

	cur_peers = ph;
	cur_rtrs = rh;
	new_peers = &conf->peers;
	netconf = &conf->networks;

	if ((rr = add_rib("Adj-RIB-In")) == NULL)
		fatal("add_rib failed");
	rr->flags = F_RIB_NOFIB | F_RIB_NOEVALUATE;
	if ((rr = add_rib("Loc-RIB")) == NULL)
		fatal("add_rib failed");
	rib_add_fib(rr, conf->default_tableid);
	rr->flags = F_RIB_LOCAL;

	if ((file = pushfile(filename, 1)) == NULL)
		goto errors;
	topfile = file;

	yyparse();
	errors = file->errors;
	popfile();

	/* check that we dont try to announce our own routes */
	TAILQ_FOREACH(n, netconf, entry)
	    if (n->net.priority == conf->fib_priority) {
		    errors++;
		    logit(LOG_CRIT, "network priority %d == fib-priority "
			"%d is not allowed.",
			n->net.priority, conf->fib_priority);
	    }

	/* Free macros and check which have not been used. */
	TAILQ_FOREACH_SAFE(sym, &symhead, entry, next) {
		if ((cmd_opts & BGPD_OPT_VERBOSE2) && !sym->used)
			fprintf(stderr, "warning: macro \"%s\" not "
			    "used\n", sym->nam);
		if (!sym->persist) {
			free(sym->nam);
			free(sym->val);
			TAILQ_REMOVE(&symhead, sym, entry);
			free(sym);
		}
	}

	if (!conf->as) {
		log_warnx("configuration error: AS not given");
		errors++;
	}

	/* clear the globals */
	curpeer = NULL;
	curgroup = NULL;
	cur_peers = NULL;
	new_peers = NULL;
	netconf = NULL;
	curflow = NULL;

	if (errors) {
errors:
		while ((rr = SIMPLEQ_FIRST(&ribnames)) != NULL) {
			SIMPLEQ_REMOVE_HEAD(&ribnames, entry);
			free(rr);
		}

		filterlist_free(filter_l);
		filterlist_free(peerfilter_l);
		filterlist_free(groupfilter_l);

		free_config(conf);
		return (NULL);
	}

	/* Create default listeners if none where specified. */
	if (TAILQ_EMPTY(conf->listen_addrs)) {
		struct listen_addr *la;

		if ((la = calloc(1, sizeof(struct listen_addr))) == NULL)
			fatal("setup_listeners calloc");
		la->fd = -1;
		la->flags = DEFAULT_LISTENER;
		la->reconf = RECONF_REINIT;
		la->sa_len = sizeof(struct sockaddr_in);
		((struct sockaddr_in *)&la->sa)->sin_family = AF_INET;
		((struct sockaddr_in *)&la->sa)->sin_addr.s_addr =
		    htonl(INADDR_ANY);
		((struct sockaddr_in *)&la->sa)->sin_port = htons(BGP_PORT);
		TAILQ_INSERT_TAIL(conf->listen_addrs, la, entry);

		if ((la = calloc(1, sizeof(struct listen_addr))) == NULL)
			fatal("setup_listeners calloc");
		la->fd = -1;
		la->flags = DEFAULT_LISTENER;
		la->reconf = RECONF_REINIT;
		la->sa_len = sizeof(struct sockaddr_in6);
		((struct sockaddr_in6 *)&la->sa)->sin6_family = AF_INET6;
		((struct sockaddr_in6 *)&la->sa)->sin6_port = htons(BGP_PORT);
		TAILQ_INSERT_TAIL(conf->listen_addrs, la, entry);
	}

	/* update clusterid in case it was not set explicitly */
	if ((conf->flags & BGPD_FLAG_REFLECTOR) && conf->clusterid == 0)
		conf->clusterid = conf->bgpid;

	/*
	 * Concatenate filter list and static group and peer filtersets
	 * together. Static group sets come first then peer sets
	 * last normal filter rules.
	 */
	TAILQ_CONCAT(conf->filters, groupfilter_l, entry);
	TAILQ_CONCAT(conf->filters, peerfilter_l, entry);
	TAILQ_CONCAT(conf->filters, filter_l, entry);

	optimize_filters(conf->filters);

	free(filter_l);
	free(peerfilter_l);
	free(groupfilter_l);

	return (conf);
}

int
symset(const char *nam, const char *val, int persist)
{
	struct sym	*sym;

	TAILQ_FOREACH(sym, &symhead, entry) {
		if (strcmp(nam, sym->nam) == 0)
			break;
	}

	if (sym != NULL) {
		if (sym->persist == 1)
			return (0);
		else {
			free(sym->nam);
			free(sym->val);
			TAILQ_REMOVE(&symhead, sym, entry);
			free(sym);
		}
	}
	if ((sym = calloc(1, sizeof(*sym))) == NULL)
		return (-1);

	sym->nam = strdup(nam);
	if (sym->nam == NULL) {
		free(sym);
		return (-1);
	}
	sym->val = strdup(val);
	if (sym->val == NULL) {
		free(sym->nam);
		free(sym);
		return (-1);
	}
	sym->used = 0;
	sym->persist = persist;
	TAILQ_INSERT_TAIL(&symhead, sym, entry);
	return (0);
}

int
cmdline_symset(char *s)
{
	char	*sym, *val;
	int	ret;

	if ((val = strrchr(s, '=')) == NULL)
		return (-1);
	sym = strndup(s, val - s);
	if (sym == NULL)
		fatal("%s: strndup", __func__);
	ret = symset(sym, val + 1, 1);
	free(sym);

	return (ret);
}

char *
symget(const char *nam)
{
	struct sym	*sym;

	TAILQ_FOREACH(sym, &symhead, entry) {
		if (strcmp(nam, sym->nam) == 0) {
			sym->used = 1;
			return (sym->val);
		}
	}
	return (NULL);
}

static int
cmpcommunity(struct community *a, struct community *b)
{
	if (a->flags > b->flags)
		return 1;
	if (a->flags < b->flags)
		return -1;
	if (a->data1 > b->data1)
		return 1;
	if (a->data1 < b->data1)
		return -1;
	if (a->data2 > b->data2)
		return 1;
	if (a->data2 < b->data2)
		return -1;
	if (a->data3 > b->data3)
		return 1;
	if (a->data3 < b->data3)
		return -1;
	return 0;
}

static int
getcommunity(char *s, int large, uint32_t *val, uint32_t *flag)
{
	long long	 max = USHRT_MAX;
	const char	*errstr;

	*flag = 0;
	*val = 0;
	if (strcmp(s, "*") == 0) {
		*flag = COMMUNITY_ANY;
		return 0;
	} else if (strcmp(s, "neighbor-as") == 0) {
		*flag = COMMUNITY_NEIGHBOR_AS;
		return 0;
	} else if (strcmp(s, "local-as") == 0) {
		*flag = COMMUNITY_LOCAL_AS;
		return 0;
	}
	if (large)
		max = UINT_MAX;
	*val = strtonum(s, 0, max, &errstr);
	if (errstr) {
		yyerror("Community %s is %s (max: %lld)", s, errstr, max);
		return -1;
	}
	return 0;
}

static void
setcommunity(struct community *c, uint32_t as, uint32_t data,
    uint32_t asflag, uint32_t dataflag)
{
	c->flags = COMMUNITY_TYPE_BASIC;
	c->flags |= asflag << 8;
	c->flags |= dataflag << 16;
	c->data1 = as;
	c->data2 = data;
	c->data3 = 0;
}

static int
parselargecommunity(struct community *c, char *s)
{
	char *p, *q;
	uint32_t dflag1, dflag2, dflag3;

	if ((p = strchr(s, ':')) == NULL) {
		yyerror("Bad community syntax");
		return (-1);
	}
	*p++ = 0;

	if ((q = strchr(p, ':')) == NULL) {
		yyerror("Bad community syntax");
		return (-1);
	}
	*q++ = 0;

	if (getcommunity(s, 1, &c->data1, &dflag1) == -1 ||
	    getcommunity(p, 1, &c->data2, &dflag2) == -1 ||
	    getcommunity(q, 1, &c->data3, &dflag3) == -1)
		return (-1);
	c->flags = COMMUNITY_TYPE_LARGE;
	c->flags |= dflag1 << 8;;
	c->flags |= dflag2 << 16;;
	c->flags |= dflag3 << 24;;
	return (0);
}

int
parsecommunity(struct community *c, int type, char *s)
{
	char *p;
	uint32_t as, data, asflag, dataflag;

	if (type == COMMUNITY_TYPE_LARGE)
		return parselargecommunity(c, s);

	/* Well-known communities */
	if (strcasecmp(s, "GRACEFUL_SHUTDOWN") == 0) {
		setcommunity(c, COMMUNITY_WELLKNOWN,
		    COMMUNITY_GRACEFUL_SHUTDOWN, 0, 0);
		return (0);
	} else if (strcasecmp(s, "NO_EXPORT") == 0) {
		setcommunity(c, COMMUNITY_WELLKNOWN,
		    COMMUNITY_NO_EXPORT, 0, 0);
		return (0);
	} else if (strcasecmp(s, "NO_ADVERTISE") == 0) {
		setcommunity(c, COMMUNITY_WELLKNOWN,
		    COMMUNITY_NO_ADVERTISE, 0, 0);
		return (0);
	} else if (strcasecmp(s, "NO_EXPORT_SUBCONFED") == 0) {
		setcommunity(c, COMMUNITY_WELLKNOWN,
		    COMMUNITY_NO_EXPSUBCONFED, 0, 0);
		return (0);
	} else if (strcasecmp(s, "NO_PEER") == 0) {
		setcommunity(c, COMMUNITY_WELLKNOWN,
		    COMMUNITY_NO_PEER, 0, 0);
		return (0);
	} else if (strcasecmp(s, "BLACKHOLE") == 0) {
		setcommunity(c, COMMUNITY_WELLKNOWN,
		    COMMUNITY_BLACKHOLE, 0, 0);
		return (0);
	}

	if ((p = strchr(s, ':')) == NULL) {
		yyerror("Bad community syntax");
		return (-1);
	}
	*p++ = 0;

	if (getcommunity(s, 0, &as, &asflag) == -1 ||
	    getcommunity(p, 0, &data, &dataflag) == -1)
		return (-1);
	setcommunity(c, as, data, asflag, dataflag);
	return (0);
}

static int
parsesubtype(char *name, int *type, int *subtype)
{
	const struct ext_comm_pairs *cp;
	int found = 0;

	for (cp = iana_ext_comms; cp->subname != NULL; cp++) {
		if (strcmp(name, cp->subname) == 0) {
			if (found == 0) {
				*type = cp->type;
				*subtype = cp->subtype;
			}
			found++;
		}
	}
	if (found > 1)
		*type = -1;
	return (found);
}

static int
parseextvalue(int type, char *s, uint32_t *v, uint32_t *flag)
{
	const char	*errstr;
	char		*p;
	struct in_addr	 ip;
	uint32_t	 uvalh, uval;

	if (type != -1) {
		/* nothing */
	} else if (strcmp(s, "neighbor-as") == 0) {
		*flag = COMMUNITY_NEIGHBOR_AS;
		*v = 0;
		return EXT_COMMUNITY_TRANS_TWO_AS;
	} else if (strcmp(s, "local-as") == 0) {
		*flag = COMMUNITY_LOCAL_AS;
		*v = 0;
		return EXT_COMMUNITY_TRANS_TWO_AS;
	} else if ((p = strchr(s, '.')) == NULL) {
		/* AS_PLAIN number (4 or 2 byte) */
		strtonum(s, 0, USHRT_MAX, &errstr);
		if (errstr == NULL)
			type = EXT_COMMUNITY_TRANS_TWO_AS;
		else
			type = EXT_COMMUNITY_TRANS_FOUR_AS;
	} else if (strchr(p + 1, '.') == NULL) {
		/* AS_DOT number (4-byte) */
		type = EXT_COMMUNITY_TRANS_FOUR_AS;
	} else {
		/* more than one dot -> IP address */
		type = EXT_COMMUNITY_TRANS_IPV4;
	}

	switch (type & EXT_COMMUNITY_VALUE) {
	case EXT_COMMUNITY_TRANS_TWO_AS:
		uval = strtonum(s, 0, USHRT_MAX, &errstr);
		if (errstr) {
			yyerror("Bad ext-community %s is %s", s, errstr);
			return (-1);
		}
		*v = uval;
		break;
	case EXT_COMMUNITY_TRANS_FOUR_AS:
		if ((p = strchr(s, '.')) == NULL) {
			uval = strtonum(s, 0, UINT_MAX, &errstr);
			if (errstr) {
				yyerror("Bad ext-community %s is %s", s,
				    errstr);
				return (-1);
			}
			*v = uval;
			break;
		}
		*p++ = '\0';
		uvalh = strtonum(s, 0, USHRT_MAX, &errstr);
		if (errstr) {
			yyerror("Bad ext-community %s is %s", s, errstr);
			return (-1);
		}
		uval = strtonum(p, 0, USHRT_MAX, &errstr);
		if (errstr) {
			yyerror("Bad ext-community %s is %s", p, errstr);
			return (-1);
		}
		*v = uval | (uvalh << 16);
		break;
	case EXT_COMMUNITY_TRANS_IPV4:
		if (inet_pton(AF_INET, s, &ip) != 1) {
			yyerror("Bad ext-community %s not parseable", s);
			return (-1);
		}
		*v = ntohl(ip.s_addr);
		break;
	default:
		fatalx("%s: unexpected type %d", __func__, type);
	}
	return (type);
}

int
parseextcommunity(struct community *c, char *t, char *s)
{
	const struct ext_comm_pairs *cp;
	char		*p, *ep;
	uint64_t	 ullval;
	uint32_t	 uval, uval2, dflag1 = 0, dflag2 = 0;
	int		 type = 0, subtype = 0;

	if (strcmp(t, "*") == 0 && strcmp(s, "*") == 0) {
		c->flags = COMMUNITY_TYPE_EXT;
		c->flags |= COMMUNITY_ANY << 24;
		return (0);
	}
	if (parsesubtype(t, &type, &subtype) == 0) {
		yyerror("Bad ext-community unknown type");
		return (-1);
	}

	switch (type) {
	case EXT_COMMUNITY_TRANS_TWO_AS:
	case EXT_COMMUNITY_TRANS_FOUR_AS:
	case EXT_COMMUNITY_TRANS_IPV4:
	case EXT_COMMUNITY_GEN_TWO_AS:
	case EXT_COMMUNITY_GEN_FOUR_AS:
	case EXT_COMMUNITY_GEN_IPV4:
	case -1:
		if (strcmp(s, "*") == 0) {
			dflag1 = COMMUNITY_ANY;
			break;
		}
		if ((p = strchr(s, ':')) == NULL) {
			yyerror("Bad ext-community %s", s);
			return (-1);
		}
		*p++ = '\0';
		if ((type = parseextvalue(type, s, &uval, &dflag1)) == -1)
			return (-1);

		switch (type) {
		case EXT_COMMUNITY_TRANS_TWO_AS:
		case EXT_COMMUNITY_GEN_TWO_AS:
			if (getcommunity(p, 1, &uval2, &dflag2) == -1)
				return (-1);
			break;
		case EXT_COMMUNITY_TRANS_IPV4:
		case EXT_COMMUNITY_TRANS_FOUR_AS:
		case EXT_COMMUNITY_GEN_IPV4:
		case EXT_COMMUNITY_GEN_FOUR_AS:
			if (getcommunity(p, 0, &uval2, &dflag2) == -1)
				return (-1);
			break;
		default:
			fatalx("parseextcommunity: unexpected result");
		}

		c->data1 = uval;
		c->data2 = uval2;
		break;
	case EXT_COMMUNITY_TRANS_OPAQUE:
	case EXT_COMMUNITY_TRANS_EVPN:
		if (strcmp(s, "*") == 0) {
			dflag1 = COMMUNITY_ANY;
			break;
		}
		errno = 0;
		ullval = strtoull(s, &ep, 0);
		if (s[0] == '\0' || *ep != '\0') {
			yyerror("Bad ext-community bad value");
			return (-1);
		}
		if (errno == ERANGE && ullval > EXT_COMMUNITY_OPAQUE_MAX) {
			yyerror("Bad ext-community value too big");
			return (-1);
		}
		c->data1 = ullval >> 32;
		c->data2 = ullval;
		break;
	case EXT_COMMUNITY_NON_TRANS_OPAQUE:
		if (subtype == EXT_COMMUNITY_SUBTYPE_OVS) {
			if (strcmp(s, "valid") == 0) {
				c->data2 = EXT_COMMUNITY_OVS_VALID;
				break;
			} else if (strcmp(s, "invalid") == 0) {
				c->data2 = EXT_COMMUNITY_OVS_INVALID;
				break;
			} else if (strcmp(s, "not-found") == 0) {
				c->data2 = EXT_COMMUNITY_OVS_NOTFOUND;
				break;
			} else if (strcmp(s, "*") == 0) {
				dflag1 = COMMUNITY_ANY;
				break;
			}
		}
		yyerror("Bad ext-community %s", s);
		return (-1);
	}

	c->data3 = type << 8 | subtype;

	/* special handling of ext-community rt * since type is not known */
	if (dflag1 == COMMUNITY_ANY && type == -1) {
		c->flags = COMMUNITY_TYPE_EXT;
		c->flags |= dflag1 << 8;
		return (0);
	}

	/* verify type/subtype combo */
	for (cp = iana_ext_comms; cp->subname != NULL; cp++) {
		if (cp->type == type && cp->subtype == subtype) {
			c->flags = COMMUNITY_TYPE_EXT;
			c->flags |= dflag1 << 8;
			c->flags |= dflag2 << 16;
			return (0);
		}
	}

	yyerror("Bad ext-community bad format for type");
	return (-1);
}

struct peer *
alloc_peer(void)
{
	struct peer	*p;

	if ((p = calloc(1, sizeof(struct peer))) == NULL)
		fatal("new_peer");

	/* some sane defaults */
	p->state = STATE_NONE;
	p->reconf_action = RECONF_REINIT;
	p->conf.distance = 1;
	p->conf.export_type = EXPORT_UNSET;
	p->conf.capabilities.refresh = 1;
	p->conf.capabilities.grestart.restart = 1;
	p->conf.capabilities.as4byte = 1;
	p->conf.capabilities.policy = 1;
	p->conf.local_as = conf->as;
	p->conf.local_short_as = conf->short_as;
	p->conf.remote_port = BGP_PORT;

	if (conf->flags & BGPD_FLAG_DECISION_TRANS_AS)
		p->conf.flags |= PEERFLAG_TRANS_AS;
	if (conf->flags & BGPD_FLAG_DECISION_ALL_PATHS)
		p->conf.flags |= PEERFLAG_EVALUATE_ALL;
	if (conf->flags & BGPD_FLAG_NO_AS_SET)
		p->conf.flags |= PEERFLAG_NO_AS_SET;

	return (p);
}

struct peer *
new_peer(void)
{
	struct peer		*p;

	p = alloc_peer();

	if (curgroup != NULL) {
		memcpy(p, curgroup, sizeof(struct peer));
		p->conf.groupid = curgroup->conf.id;
	}
	return (p);
}

struct peer *
new_group(void)
{
	return (alloc_peer());
}

int
add_mrtconfig(enum mrt_type type, char *name, int timeout, struct peer *p,
    char *rib)
{
	struct mrt	*m, *n;

	LIST_FOREACH(m, conf->mrt, entry) {
		if ((rib && strcmp(rib, m->rib)) ||
		    (!rib && *m->rib))
			continue;
		if (p == NULL) {
			if (m->peer_id != 0 || m->group_id != 0)
				continue;
		} else {
			if (m->peer_id != p->conf.id ||
			    m->group_id != p->conf.groupid)
				continue;
		}
		if (m->type == type) {
			yyerror("only one mrtdump per type allowed.");
			return (-1);
		}
	}

	if ((n = calloc(1, sizeof(struct mrt_config))) == NULL)
		fatal("add_mrtconfig");

	n->type = type;
	n->state = MRT_STATE_OPEN;
	if (strlcpy(MRT2MC(n)->name, name, sizeof(MRT2MC(n)->name)) >=
	    sizeof(MRT2MC(n)->name)) {
		yyerror("filename \"%s\" too long: max %zu",
		    name, sizeof(MRT2MC(n)->name) - 1);
		free(n);
		return (-1);
	}
	MRT2MC(n)->ReopenTimerInterval = timeout;
	if (p != NULL) {
		if (curgroup == p) {
			n->peer_id = 0;
			n->group_id = p->conf.id;
		} else {
			n->peer_id = p->conf.id;
			n->group_id = p->conf.groupid;
		}
	}
	if (rib) {
		if (!find_rib(rib)) {
			yyerror("rib \"%s\" does not exist.", rib);
			free(n);
			return (-1);
		}
		if (strlcpy(n->rib, rib, sizeof(n->rib)) >=
		    sizeof(n->rib)) {
			yyerror("rib name \"%s\" too long: max %zu",
			    name, sizeof(n->rib) - 1);
			free(n);
			return (-1);
		}
	}

	LIST_INSERT_HEAD(conf->mrt, n, entry);

	return (0);
}

struct rde_rib *
add_rib(char *name)
{
	struct rde_rib	*rr;

	if ((rr = find_rib(name)) == NULL) {
		if ((rr = calloc(1, sizeof(*rr))) == NULL) {
			log_warn("add_rib");
			return (NULL);
		}
		if (strlcpy(rr->name, name, sizeof(rr->name)) >=
		    sizeof(rr->name)) {
			yyerror("rib name \"%s\" too long: max %zu",
			    name, sizeof(rr->name) - 1);
			free(rr);
			return (NULL);
		}
		rr->flags = F_RIB_NOFIB;
		SIMPLEQ_INSERT_TAIL(&ribnames, rr, entry);
	}
	return (rr);
}

struct rde_rib *
find_rib(char *name)
{
	struct rde_rib	*rr;

	SIMPLEQ_FOREACH(rr, &ribnames, entry) {
		if (!strcmp(rr->name, name))
			return (rr);
	}
	return (NULL);
}

int
rib_add_fib(struct rde_rib *rr, u_int rtableid)
{
	u_int	rdom;

	if (!ktable_exists(rtableid, &rdom)) {
		yyerror("rtable id %u does not exist", rtableid);
		return (-1);
	}
	/*
	 * conf->default_tableid is also a rdomain because that is checked
	 * in init_config()
	 */
	if (rdom != conf->default_tableid) {
		log_warnx("rtable %u does not belong to rdomain %u",
		    rtableid, conf->default_tableid);
		return (-1);
	}
	rr->rtableid = rtableid;
	rr->flags &= ~F_RIB_NOFIB;
	return (0);
}

struct prefixset *
find_prefixset(char *name, struct prefixset_head *p)
{
	struct prefixset *ps;

	SIMPLEQ_FOREACH(ps, p, entry) {
		if (!strcmp(ps->name, name))
			return (ps);
	}
	return (NULL);
}

int
get_id(struct peer *newpeer)
{
	static uint32_t id = PEER_ID_STATIC_MIN;
	struct peer	*p = NULL;

	/* check if the peer already existed before */
	if (newpeer->conf.remote_addr.aid) {
		/* neighbor */
		if (cur_peers)
			RB_FOREACH(p, peer_head, cur_peers)
				if (p->conf.remote_masklen ==
				    newpeer->conf.remote_masklen &&
				    memcmp(&p->conf.remote_addr,
				    &newpeer->conf.remote_addr,
				    sizeof(p->conf.remote_addr)) == 0)
					break;
		if (p) {
			newpeer->conf.id = p->conf.id;
			return (0);
		}
	} else {
		/* group */
		if (cur_peers)
			RB_FOREACH(p, peer_head, cur_peers)
				if (strcmp(p->conf.group,
				    newpeer->conf.group) == 0)
					break;
		if (p) {
			newpeer->conf.id = p->conf.groupid;
			return (0);
		}
	}

	/* else new one */
	if (id < PEER_ID_STATIC_MAX) {
		newpeer->conf.id = id++;
		return (0);
	}

	return (-1);
}

int
merge_prefixspec(struct filter_prefix *p, struct filter_prefixlen *pl)
{
	uint8_t max_len = 0;

	switch (p->addr.aid) {
	case AID_INET:
	case AID_VPN_IPv4:
		max_len = 32;
		break;
	case AID_INET6:
	case AID_VPN_IPv6:
		max_len = 128;
		break;
	}

	if (pl->op == OP_NONE) {
		p->len_min = p->len_max = p->len;
		return (0);
	}

	if (pl->len_min == -1)
		pl->len_min = p->len;
	if (pl->len_max == -1)
		pl->len_max = max_len;

	if (pl->len_max > max_len) {
		yyerror("prefixlen %d too big, limit %d",
		    pl->len_max, max_len);
		return (-1);
	}
	if (pl->len_min > pl->len_max) {
		yyerror("prefixlen %d too big, limit %d",
		    pl->len_min, pl->len_max);
		return (-1);
	}
	if (pl->len_min < p->len) {
		yyerror("prefixlen %d smaller than prefix, limit %d",
		    pl->len_min, p->len);
		return (-1);
	}

	p->op = pl->op;
	p->len_min = pl->len_min;
	p->len_max = pl->len_max;
	return (0);
}

int
expand_rule(struct filter_rule *rule, struct filter_rib_l *rib,
    struct filter_peers_l *peer, struct filter_match_l *match,
    struct filter_set_head *set)
{
	struct filter_rule	*r;
	struct filter_rib_l	*rb, *rbnext;
	struct filter_peers_l	*p, *pnext;
	struct filter_prefix_l	*prefix, *prefix_next;
	struct filter_as_l	*a, *anext;
	struct filter_set	*s;

	rb = rib;
	do {
		p = peer;
		do {
			a = match->as_l;
			do {
				prefix = match->prefix_l;
				do {
					if ((r = calloc(1,
					    sizeof(struct filter_rule))) ==
						 NULL) {
						log_warn("expand_rule");
						return (-1);
					}

					memcpy(r, rule, sizeof(struct filter_rule));
					memcpy(&r->match, match,
					    sizeof(struct filter_match));
					filterset_copy(set, &r->set);

					if (rb != NULL)
						strlcpy(r->rib, rb->name,
						    sizeof(r->rib));

					if (p != NULL)
						memcpy(&r->peer, &p->p,
						    sizeof(struct filter_peers));

					if (prefix != NULL)
						memcpy(&r->match.prefix, &prefix->p,
						    sizeof(r->match.prefix));

					if (a != NULL)
						memcpy(&r->match.as, &a->a,
						    sizeof(struct filter_as));

					TAILQ_INSERT_TAIL(filter_l, r, entry);

					if (prefix != NULL)
						prefix = prefix->next;
				} while (prefix != NULL);

				if (a != NULL)
					a = a->next;
			} while (a != NULL);

			if (p != NULL)
				p = p->next;
		} while (p != NULL);

		if (rb != NULL)
			rb = rb->next;
	} while (rb != NULL);

	for (rb = rib; rb != NULL; rb = rbnext) {
		rbnext = rb->next;
		free(rb);
	}

	for (p = peer; p != NULL; p = pnext) {
		pnext = p->next;
		free(p);
	}

	for (a = match->as_l; a != NULL; a = anext) {
		anext = a->next;
		free(a);
	}

	for (prefix = match->prefix_l; prefix != NULL; prefix = prefix_next) {
		prefix_next = prefix->next;
		free(prefix);
	}

	if (set != NULL) {
		while ((s = TAILQ_FIRST(set)) != NULL) {
			TAILQ_REMOVE(set, s, entry);
			free(s);
		}
		free(set);
	}

	return (0);
}

static int
h2i(char c)
{
	if (c >= '0' && c <= '9')
		return c - '0';
	else if (c >= 'a' && c <= 'f')
		return c - 'a' + 10;
	else if (c >= 'A' && c <= 'F')
		return c - 'A' + 10;
	else
		return -1;
}

int
str2key(char *s, char *dest, size_t max_len)
{
	size_t	i;

	if (strlen(s) / 2 > max_len) {
		yyerror("key too long");
		return (-1);
	}

	if (strlen(s) % 2) {
		yyerror("key must be of even length");
		return (-1);
	}

	for (i = 0; i < strlen(s) / 2; i++) {
		int hi, lo;

		hi = h2i(s[2 * i]);
		lo = h2i(s[2 * i + 1]);
		if (hi == -1 || lo == -1) {
			yyerror("key must be specified in hex");
			return (-1);
		}
		dest[i] = (hi << 4) | lo;
	}

	return (0);
}

int
neighbor_consistent(struct peer *p)
{
	struct bgpd_addr *local_addr;
	struct peer *xp;

	switch (p->conf.remote_addr.aid) {
	case AID_INET:
		local_addr = &p->conf.local_addr_v4;
		break;
	case AID_INET6:
		local_addr = &p->conf.local_addr_v6;
		break;
	default:
		yyerror("Bad address family for remote-addr");
		return (-1);
	}

	/* with any form of ipsec local-address is required */
	if ((p->conf.auth.method == AUTH_IPSEC_IKE_ESP ||
	    p->conf.auth.method == AUTH_IPSEC_IKE_AH ||
	    p->conf.auth.method == AUTH_IPSEC_MANUAL_ESP ||
	    p->conf.auth.method == AUTH_IPSEC_MANUAL_AH) &&
	    local_addr->aid == AID_UNSPEC) {
		yyerror("neighbors with any form of IPsec configured "
		    "need local-address to be specified");
		return (-1);
	}

	/* with static keying we need both directions */
	if ((p->conf.auth.method == AUTH_IPSEC_MANUAL_ESP ||
	    p->conf.auth.method == AUTH_IPSEC_MANUAL_AH) &&
	    (!p->conf.auth.spi_in || !p->conf.auth.spi_out)) {
		yyerror("with manual keyed IPsec, SPIs and keys "
		    "for both directions are required");
		return (-1);
	}

	if (!conf->as) {
		yyerror("AS needs to be given before neighbor definitions");
		return (-1);
	}

	/* set default values if they where undefined */
	p->conf.ebgp = (p->conf.remote_as != conf->as);
	if (p->conf.enforce_as == ENFORCE_AS_UNDEF)
		p->conf.enforce_as = p->conf.ebgp ?
		    ENFORCE_AS_ON : ENFORCE_AS_OFF;
	if (p->conf.enforce_local_as == ENFORCE_AS_UNDEF)
		p->conf.enforce_local_as = ENFORCE_AS_ON;

	if (p->conf.remote_as == 0 && !p->conf.template) {
		yyerror("peer AS may not be zero");
		return (-1);
	}

	/* EBGP neighbors are not allowed in route reflector clusters */
	if (p->conf.reflector_client && p->conf.ebgp) {
		yyerror("EBGP neighbors are not allowed in route "
		    "reflector clusters");
		return (-1);
	}

	/* BGP role and RFC 9234 role are only valid for EBGP neighbors */
	if (!p->conf.ebgp) {
		p->conf.role = ROLE_NONE;
		p->conf.capabilities.policy = 0;
	} else if (p->conf.role == ROLE_NONE) {
		/* no role, no policy capability */
		p->conf.capabilities.policy = 0;
	}

	/* check for duplicate peer definitions */
	RB_FOREACH(xp, peer_head, new_peers)
		if (xp->conf.remote_masklen ==
		    p->conf.remote_masklen &&
		    memcmp(&xp->conf.remote_addr,
		    &p->conf.remote_addr,
		    sizeof(p->conf.remote_addr)) == 0)
			break;
	if (xp != NULL) {
		char *descr = log_fmt_peer(&p->conf);
		yyerror("duplicate %s", descr);
		free(descr);
		return (-1);
	}

	return (0);
}

static void
filterset_add(struct filter_set_head *sh, struct filter_set *s)
{
	struct filter_set	*t;

	TAILQ_FOREACH(t, sh, entry) {
		if (s->type < t->type) {
			TAILQ_INSERT_BEFORE(t, s, entry);
			return;
		}
		if (s->type == t->type) {
			switch (s->type) {
			case ACTION_SET_COMMUNITY:
			case ACTION_DEL_COMMUNITY:
				switch (cmpcommunity(&s->action.community,
				    &t->action.community)) {
				case -1:
					TAILQ_INSERT_BEFORE(t, s, entry);
					return;
				case 0:
					break;
				case 1:
					continue;
				}
				break;
			case ACTION_SET_NEXTHOP:
				/* only last nexthop per AF matters */
				if (s->action.nexthop.aid <
				    t->action.nexthop.aid) {
					TAILQ_INSERT_BEFORE(t, s, entry);
					return;
				} else if (s->action.nexthop.aid ==
				    t->action.nexthop.aid) {
					t->action.nexthop = s->action.nexthop;
					break;
				}
				continue;
			case ACTION_SET_NEXTHOP_BLACKHOLE:
			case ACTION_SET_NEXTHOP_REJECT:
			case ACTION_SET_NEXTHOP_NOMODIFY:
			case ACTION_SET_NEXTHOP_SELF:
				/* set it only once */
				break;
			case ACTION_SET_LOCALPREF:
			case ACTION_SET_MED:
			case ACTION_SET_WEIGHT:
				/* only last set matters */
				t->action.metric = s->action.metric;
				break;
			case ACTION_SET_RELATIVE_LOCALPREF:
			case ACTION_SET_RELATIVE_MED:
			case ACTION_SET_RELATIVE_WEIGHT:
				/* sum all relative numbers */
				t->action.relative += s->action.relative;
				break;
			case ACTION_SET_ORIGIN:
				/* only last set matters */
				t->action.origin = s->action.origin;
				break;
			case ACTION_PFTABLE:
				/* only last set matters */
				strlcpy(t->action.pftable, s->action.pftable,
				    sizeof(t->action.pftable));
				break;
			case ACTION_RTLABEL:
				/* only last set matters */
				strlcpy(t->action.rtlabel, s->action.rtlabel,
				    sizeof(t->action.rtlabel));
				break;
			default:
				break;
			}
			free(s);
			return;
		}
	}

	TAILQ_INSERT_TAIL(sh, s, entry);
}

int
merge_filterset(struct filter_set_head *sh, struct filter_set *s)
{
	struct filter_set	*t;

	TAILQ_FOREACH(t, sh, entry) {
		/*
		 * need to cycle across the full list because even
		 * if types are not equal filterset_cmp() may return 0.
		 */
		if (filterset_cmp(s, t) == 0) {
			if (s->type == ACTION_SET_COMMUNITY)
				yyerror("community is already set");
			else if (s->type == ACTION_DEL_COMMUNITY)
				yyerror("community will already be deleted");
			else
				yyerror("redefining set parameter %s",
				    filterset_name(s->type));
			return (-1);
		}
	}

	filterset_add(sh, s);
	return (0);
}

static int
filter_equal(struct filter_rule *fa, struct filter_rule *fb)
{
	if (fa == NULL || fb == NULL)
		return 0;
	if (fa->action != fb->action || fa->quick != fb->quick ||
	    fa->dir != fb->dir)
		return 0;
	if (memcmp(&fa->peer, &fb->peer, sizeof(fa->peer)))
		return 0;
	if (memcmp(&fa->match, &fb->match, sizeof(fa->match)))
		return 0;

	return 1;
}

/* do a basic optimization by folding equal rules together */
void
optimize_filters(struct filter_head *fh)
{
	struct filter_rule *r, *nr;

	TAILQ_FOREACH_SAFE(r, fh, entry, nr) {
		while (filter_equal(r, nr)) {
			struct filter_set	*t;

			while ((t = TAILQ_FIRST(&nr->set)) != NULL) {
				TAILQ_REMOVE(&nr->set, t, entry);
				filterset_add(&r->set, t);
			}

			TAILQ_REMOVE(fh, nr, entry);
			free(nr);
			nr = TAILQ_NEXT(r, entry);
		}
	}
}

struct filter_rule *
get_rule(enum action_types type)
{
	struct filter_rule	*r;
	int			 out;

	switch (type) {
	case ACTION_SET_PREPEND_SELF:
	case ACTION_SET_NEXTHOP_NOMODIFY:
	case ACTION_SET_NEXTHOP_SELF:
		out = 1;
		break;
	default:
		out = 0;
		break;
	}
	r = (curpeer == curgroup) ? curgroup_filter[out] : curpeer_filter[out];
	if (r == NULL) {
		if ((r = calloc(1, sizeof(struct filter_rule))) == NULL)
			fatal(NULL);
		r->quick = 0;
		r->dir = out ? DIR_OUT : DIR_IN;
		r->action = ACTION_NONE;
		TAILQ_INIT(&r->set);
		if (curpeer == curgroup) {
			/* group */
			r->peer.groupid = curgroup->conf.id;
			curgroup_filter[out] = r;
		} else {
			/* peer */
			r->peer.peerid = curpeer->conf.id;
			curpeer_filter[out] = r;
		}
	}
	return (r);
}

struct set_table *curset;
static int
new_as_set(char *name)
{
	struct as_set *aset;

	if (as_sets_lookup(&conf->as_sets, name) != NULL) {
		yyerror("as-set \"%s\" already exists", name);
		return -1;
	}

	aset = as_sets_new(&conf->as_sets, name, 0, sizeof(uint32_t));
	if (aset == NULL)
		fatal(NULL);

	curset = aset->set;
	return 0;
}

static void
add_as_set(uint32_t as)
{
	if (curset == NULL)
		fatalx("%s: bad mojo jojo", __func__);

	if (set_add(curset, &as, 1) != 0)
		fatal(NULL);
}

static void
done_as_set(void)
{
	curset = NULL;
}

static struct prefixset *
new_prefix_set(char *name, int is_roa)
{
	const char *type = "prefix-set";
	struct prefixset_head *sets = &conf->prefixsets;
	struct prefixset *pset;

	if (is_roa) {
		type = "origin-set";
		sets = &conf->originsets;
	}

	if (find_prefixset(name, sets) != NULL) {
		yyerror("%s \"%s\" already exists", type, name);
		return NULL;
	}
	if ((pset = calloc(1, sizeof(*pset))) == NULL)
		fatal("prefixset");
	if (strlcpy(pset->name, name, sizeof(pset->name)) >=
	    sizeof(pset->name)) {
		yyerror("%s \"%s\" too long: max %zu", type,
		    name, sizeof(pset->name) - 1);
		free(pset);
		return NULL;
	}
	RB_INIT(&pset->psitems);
	RB_INIT(&pset->roaitems);
	return pset;
}

static void
add_roa_set(struct prefixset_item *npsi, uint32_t as, uint8_t max,
    time_t expires)
{
	struct roa *roa, *r;

	if ((roa = calloc(1, sizeof(*roa))) == NULL)
		fatal("add_roa_set");

	roa->aid = npsi->p.addr.aid;
	roa->prefixlen = npsi->p.len;
	roa->maxlen = max;
	roa->asnum = as;
	roa->expires = expires;
	switch (roa->aid) {
	case AID_INET:
		roa->prefix.inet = npsi->p.addr.v4;
		break;
	case AID_INET6:
		roa->prefix.inet6 = npsi->p.addr.v6;
		break;
	default:
		fatalx("Bad address family for roa_set address");
	}

	r = RB_INSERT(roa_tree, curroatree, roa);
	if (r != NULL) {
		/* just ignore duplicates */
		if (r->expires != 0 && expires != 0 && expires > r->expires)
			r->expires = expires;
		free(roa);
	}
}

static struct rtr_config *
get_rtr(struct bgpd_addr *addr)
{
	struct rtr_config *n;

	n = calloc(1, sizeof(*n));
	if (n == NULL) {
		yyerror("out of memory");
		return NULL;
	}

	n->remote_addr = *addr;
	strlcpy(n->descr, log_addr(addr), sizeof(currtr->descr));

	return n;
}

static int
insert_rtr(struct rtr_config *new)
{
	static uint32_t id;
	struct rtr_config *r;

	if (id == UINT32_MAX) {
		yyerror("out of rtr session IDs");
		return -1;
	}

	SIMPLEQ_FOREACH(r, &conf->rtrs, entry)
		if (memcmp(&r->remote_addr, &new->remote_addr,
		    sizeof(r->remote_addr)) == 0 &&
		    r->remote_port == new->remote_port) {
			yyerror("duplicate rtr session to %s:%u",
			    log_addr(&new->remote_addr), new->remote_port);
			return -1;
		}

	if (cur_rtrs)
		SIMPLEQ_FOREACH(r, cur_rtrs, entry)
			if (memcmp(&r->remote_addr, &new->remote_addr,
			    sizeof(r->remote_addr)) == 0 &&
			    r->remote_port == new->remote_port) {
				new->id = r->id;
				break;
			}

	if (new->id == 0)
		new->id = ++id;

	SIMPLEQ_INSERT_TAIL(&conf->rtrs, currtr, entry);

	return 0;
}

static int
merge_aspa_set(uint32_t as, struct aspa_tas_l *tas, time_t expires)
{
	struct aspa_set	*aspa, needle = { .as = as };
	uint32_t i, num, *newtas;

	aspa = RB_FIND(aspa_tree, &conf->aspa, &needle);
	if (aspa == NULL) {
		if ((aspa = calloc(1, sizeof(*aspa))) == NULL) {
			yyerror("out of memory");
			return -1;
		}
		aspa->as = as;
		aspa->expires = expires;
		RB_INSERT(aspa_tree, &conf->aspa, aspa);
	}

	if (MAX_ASPA_SPAS_COUNT - aspa->num <= tas->num) {
		yyerror("too many providers for customer-as %u", as);
		return -1;
	}
	num = aspa->num + tas->num;
	newtas = recallocarray(aspa->tas, aspa->num, num, sizeof(uint32_t));
	if (newtas == NULL) {
		yyerror("out of memory");
		return -1;
	}
	/* fill starting at the end since the tas list is reversed */
	if (num > 0) {
		for (i = num - 1; tas; tas = tas->next, i--)
			newtas[i] = tas->as;
	}

	aspa->num = num;
	aspa->tas = newtas;

	/* take the longest expiry time, same logic as for ROA entries */
	if (aspa->expires != 0 && expires != 0 && expires > aspa->expires)
		aspa->expires = expires;

	return 0;
}

static int
kw_casecmp(const void *k, const void *e)
{
	return (strcasecmp(k, ((const struct keywords *)e)->k_name));
}

static int
map_tos(char *s, int *val)
{
	/* DiffServ Codepoints and other TOS mappings */
	const struct keywords	 toswords[] = {
		{ "af11",		IPTOS_DSCP_AF11 },
		{ "af12",		IPTOS_DSCP_AF12 },
		{ "af13",		IPTOS_DSCP_AF13 },
		{ "af21",		IPTOS_DSCP_AF21 },
		{ "af22",		IPTOS_DSCP_AF22 },
		{ "af23",		IPTOS_DSCP_AF23 },
		{ "af31",		IPTOS_DSCP_AF31 },
		{ "af32",		IPTOS_DSCP_AF32 },
		{ "af33",		IPTOS_DSCP_AF33 },
		{ "af41",		IPTOS_DSCP_AF41 },
		{ "af42",		IPTOS_DSCP_AF42 },
		{ "af43",		IPTOS_DSCP_AF43 },
		{ "critical",		IPTOS_PREC_CRITIC_ECP },
		{ "cs0",		IPTOS_DSCP_CS0 },
		{ "cs1",		IPTOS_DSCP_CS1 },
		{ "cs2",		IPTOS_DSCP_CS2 },
		{ "cs3",		IPTOS_DSCP_CS3 },
		{ "cs4",		IPTOS_DSCP_CS4 },
		{ "cs5",		IPTOS_DSCP_CS5 },
		{ "cs6",		IPTOS_DSCP_CS6 },
		{ "cs7",		IPTOS_DSCP_CS7 },
		{ "ef",			IPTOS_DSCP_EF },
		{ "inetcontrol",	IPTOS_PREC_INTERNETCONTROL },
		{ "lowdelay",		IPTOS_LOWDELAY },
		{ "netcontrol",		IPTOS_PREC_NETCONTROL },
		{ "reliability",	IPTOS_RELIABILITY },
		{ "throughput",		IPTOS_THROUGHPUT }
	};
	const struct keywords	*p;

	p = bsearch(s, toswords, nitems(toswords), sizeof(toswords[0]),
	    kw_casecmp);

	if (p) {
		*val = p->k_val;
		return (1);
	}
	return (0);
}

static int
getservice(char *n)
{
	struct servent	*s;

	s = getservbyname(n, "tcp");
	if (s == NULL)
		s = getservbyname(n, "udp");
	if (s == NULL)
		return -1;
	return s->s_port;
}

static int
parse_flags(char *s)
{
	const char *flags = FLOWSPEC_TCP_FLAG_STRING;
	char *p, *q;
	uint8_t f = 0;

	if (curflow->type == FLOWSPEC_TYPE_FRAG) {
		if (curflow->aid == AID_INET)
			flags = FLOWSPEC_FRAG_STRING4;
		else
			flags = FLOWSPEC_FRAG_STRING6;
	}

	for (p = s; *p; p++) {
		if ((q = strchr(flags, *p)) == NULL)
			return -1;
		f |= 1 << (q - flags);
	}
	return (f ? f : 0xff);
}

static void
component_finish(int type, uint8_t *data, int len)
{
	uint8_t *last;
	int i;

	switch (type) {
	case FLOWSPEC_TYPE_DEST:
	case FLOWSPEC_TYPE_SOURCE:
		/* nothing to do */
		return;
	default:
		break;
	}

	i = 0;
	do {
		last = data + i;
		i += FLOWSPEC_OP_LEN(*last) + 1;
	} while (i < len);
	*last |= FLOWSPEC_OP_EOL;
}

static struct flowspec_config *
flow_to_flowspec(struct flowspec_context *ctx)
{
	struct flowspec_config *f;
	int i, len = 0;
	uint8_t aid;

	switch (ctx->aid) {
	case AID_INET:
		aid = AID_FLOWSPECv4;
		break;
	case AID_INET6:
		aid = AID_FLOWSPECv6;
		break;
	default:
		return NULL;
	}

	for (i = FLOWSPEC_TYPE_MIN; i < FLOWSPEC_TYPE_MAX; i++)
		if (ctx->components[i] != NULL)
			len += ctx->complen[i] + 1;

	f = flowspec_alloc(aid, len);
	if (f == NULL)
		return NULL;

	len = 0;
	for (i = FLOWSPEC_TYPE_MIN; i < FLOWSPEC_TYPE_MAX; i++)
		if (ctx->components[i] != NULL) {
			f->flow->data[len++] = i;
			component_finish(i, ctx->components[i],
			    ctx->complen[i]);
			memcpy(f->flow->data + len, ctx->components[i],
			    ctx->complen[i]);
			len += ctx->complen[i];
		}

	return f;
}

static void
flow_free(struct flowspec_context *ctx)
{
	int i;

	for (i = 0; i < FLOWSPEC_TYPE_MAX; i++)
		free(ctx->components[i]);
	free(ctx);
}

static int
push_prefix(struct bgpd_addr *addr, uint8_t len)
{
	void *data;
	uint8_t *comp;
	int complen, l;

	if (curflow->components[curflow->addr_type] != NULL) {
		yyerror("flowspec address already set");
		return -1;
	}

	if (curflow->aid != addr->aid) {
		yyerror("wrong address family for flowspec address");
		return -1;
	}

	switch (curflow->aid) {
	case AID_INET:
		complen = PREFIX_SIZE(len);
		data = &addr->v4;
		break;
	case AID_INET6:
		/* IPv6 includes an offset byte */
		complen = PREFIX_SIZE(len) + 1;
		data = &addr->v6;
		break;
	default:
		yyerror("unsupported address family for flowspec address");
		return -1;
	}
	comp = malloc(complen);
	if (comp == NULL) {
		yyerror("out of memory");
		return -1;
	}

	l = 0;
	comp[l++] = len;
	if (curflow->aid == AID_INET6)
		comp[l++] = 0;
	memcpy(comp + l, data, complen - l);

	curflow->complen[curflow->addr_type] = complen;
	curflow->components[curflow->addr_type] = comp;

	return 0;
}

static int
push_binop(uint8_t binop, long long val)
{
	uint8_t *comp;
	int complen;
	uint8_t u8;

	if (val < 0 || val > 0xff) {
		yyerror("unsupported value for flowspec bin_op");
		return -1;
	}
	u8 = val;

	complen = curflow->complen[curflow->type];
	comp = realloc(curflow->components[curflow->type],
	    complen + 2);
	if (comp == NULL) {
		yyerror("out of memory");
		return -1;
	}

	comp[complen++] = binop;
	comp[complen++] = u8;
	curflow->complen[curflow->type] = complen;
	curflow->components[curflow->type] = comp;

	return 0;
}

static uint8_t
component_numop(enum comp_ops op, int and, int len)
{
	uint8_t flag = 0;

	switch (op) {
	case OP_EQ:
		flag |= FLOWSPEC_OP_NUM_EQ;
		break;
	case OP_NE:
		flag |= FLOWSPEC_OP_NUM_NOT;
		break;
	case OP_LE:
		flag |= FLOWSPEC_OP_NUM_LE;
		break;
	case OP_LT:
		flag |= FLOWSPEC_OP_NUM_LT;
		break;
	case OP_GE:
		flag |= FLOWSPEC_OP_NUM_GE;
		break;
	case OP_GT:
		flag |= FLOWSPEC_OP_NUM_GT;
		break;
	default:
		fatalx("unsupported op");
	}

	switch (len) {
	case 2:
		flag |= 1 << FLOWSPEC_OP_LEN_SHIFT;
		break;
	case 4:
		flag |= 2 << FLOWSPEC_OP_LEN_SHIFT;
		break;
	case 8:
		flag |= 3 << FLOWSPEC_OP_LEN_SHIFT;
		break;
	}

	if (and)
		flag |= FLOWSPEC_OP_AND;

	return flag;
}

static int
push_numop(enum comp_ops op, int and, long long val)
{
	uint8_t *comp;
	void *data;
	uint32_t u32;
	uint16_t u16;
	uint8_t u8;
	int len, complen;

	if (val < 0 || val > 0xffffffff) {
		yyerror("unsupported value for flowspec num_op");
		return -1;
	} else if (val <= 255) {
		len = 1;
		u8 = val;
		data = &u8;
	} else if (val <= 0xffff) {
		len = 2;
		u16 = htons(val);
		data = &u16;
	} else {
		len = 4;
		u32 = htonl(val);
		data = &u32;
	}

	complen = curflow->complen[curflow->type];
	comp = realloc(curflow->components[curflow->type],
	    complen + len + 1);
	if (comp == NULL) {
		yyerror("out of memory");
		return -1;
	}

	comp[complen++] = component_numop(op, and, len);
	memcpy(comp + complen, data, len);
	complen += len;
	curflow->complen[curflow->type] = complen;
	curflow->components[curflow->type] = comp;

	return 0;
}

static int
push_unary_numop(enum comp_ops op, long long val)
{
	return push_numop(op, 0, val);
}

static int
push_binary_numop(enum comp_ops op, long long min, long long max)
{
	switch (op) {
	case OP_RANGE:
		if (push_numop(OP_GE, 0, min) == -1)
			return -1;
		return push_numop(OP_LE, 1, max);
	case OP_XRANGE:
		if (push_numop(OP_LT, 0, min) == -1)
			return -1;
		return push_numop(OP_GT, 0, max);
	default:
		yyerror("unsupported binary flowspec num_op");
		return -1;
	}
}

struct icmptypeent {
	const char *name;
	u_int8_t type;
};

struct icmpcodeent {
	const char *name;
	u_int8_t type;
	u_int8_t code;
};

static const struct icmptypeent icmp_type[] = {
	{ "echoreq",	ICMP_ECHO },
	{ "echorep",	ICMP_ECHOREPLY },
	{ "unreach",	ICMP_UNREACH },
	{ "squench",	ICMP_SOURCEQUENCH },
	{ "redir",	ICMP_REDIRECT },
	{ "althost",	ICMP_ALTHOSTADDR },
	{ "routeradv",	ICMP_ROUTERADVERT },
	{ "routersol",	ICMP_ROUTERSOLICIT },
	{ "timex",	ICMP_TIMXCEED },
	{ "paramprob",	ICMP_PARAMPROB },
	{ "timereq",	ICMP_TSTAMP },
	{ "timerep",	ICMP_TSTAMPREPLY },
	{ "inforeq",	ICMP_IREQ },
	{ "inforep",	ICMP_IREQREPLY },
	{ "maskreq",	ICMP_MASKREQ },
	{ "maskrep",	ICMP_MASKREPLY },
	{ "trace",	ICMP_TRACEROUTE },
	{ "dataconv",	ICMP_DATACONVERR },
	{ "mobredir",	ICMP_MOBILE_REDIRECT },
	{ "ipv6-where",	ICMP_IPV6_WHEREAREYOU },
	{ "ipv6-here",	ICMP_IPV6_IAMHERE },
	{ "mobregreq",	ICMP_MOBILE_REGREQUEST },
	{ "mobregrep",	ICMP_MOBILE_REGREPLY },
	{ "skip",	ICMP_SKIP },
	{ "photuris",	ICMP_PHOTURIS }
};

static const struct icmptypeent icmp6_type[] = {
	{ "unreach",	ICMP6_DST_UNREACH },
	{ "toobig",	ICMP6_PACKET_TOO_BIG },
	{ "timex",	ICMP6_TIME_EXCEEDED },
	{ "paramprob",	ICMP6_PARAM_PROB },
	{ "echoreq",	ICMP6_ECHO_REQUEST },
	{ "echorep",	ICMP6_ECHO_REPLY },
	{ "groupqry",	ICMP6_MEMBERSHIP_QUERY },
	{ "listqry",	MLD_LISTENER_QUERY },
	{ "grouprep",	ICMP6_MEMBERSHIP_REPORT },
	{ "listenrep",	MLD_LISTENER_REPORT },
	{ "groupterm",	ICMP6_MEMBERSHIP_REDUCTION },
	{ "listendone", MLD_LISTENER_DONE },
	{ "routersol",	ND_ROUTER_SOLICIT },
	{ "routeradv",	ND_ROUTER_ADVERT },
	{ "neighbrsol", ND_NEIGHBOR_SOLICIT },
	{ "neighbradv", ND_NEIGHBOR_ADVERT },
	{ "redir",	ND_REDIRECT },
	{ "routrrenum", ICMP6_ROUTER_RENUMBERING },
	{ "wrureq",	ICMP6_WRUREQUEST },
	{ "wrurep",	ICMP6_WRUREPLY },
	{ "fqdnreq",	ICMP6_FQDN_QUERY },
	{ "fqdnrep",	ICMP6_FQDN_REPLY },
	{ "niqry",	ICMP6_NI_QUERY },
	{ "nirep",	ICMP6_NI_REPLY },
	{ "mtraceresp",	MLD_MTRACE_RESP },
	{ "mtrace",	MLD_MTRACE },
	{ "listenrepv2", MLDV2_LISTENER_REPORT },
};

static const struct icmpcodeent icmp_code[] = {
	{ "net-unr",		ICMP_UNREACH,	ICMP_UNREACH_NET },
	{ "host-unr",		ICMP_UNREACH,	ICMP_UNREACH_HOST },
	{ "proto-unr",		ICMP_UNREACH,	ICMP_UNREACH_PROTOCOL },
	{ "port-unr",		ICMP_UNREACH,	ICMP_UNREACH_PORT },
	{ "needfrag",		ICMP_UNREACH,	ICMP_UNREACH_NEEDFRAG },
	{ "srcfail",		ICMP_UNREACH,	ICMP_UNREACH_SRCFAIL },
	{ "net-unk",		ICMP_UNREACH,	ICMP_UNREACH_NET_UNKNOWN },
	{ "host-unk",		ICMP_UNREACH,	ICMP_UNREACH_HOST_UNKNOWN },
	{ "isolate",		ICMP_UNREACH,	ICMP_UNREACH_ISOLATED },
	{ "net-prohib",		ICMP_UNREACH,	ICMP_UNREACH_NET_PROHIB },
	{ "host-prohib",	ICMP_UNREACH,	ICMP_UNREACH_HOST_PROHIB },
	{ "net-tos",		ICMP_UNREACH,	ICMP_UNREACH_TOSNET },
	{ "host-tos",		ICMP_UNREACH,	ICMP_UNREACH_TOSHOST },
	{ "filter-prohib",	ICMP_UNREACH,	ICMP_UNREACH_FILTER_PROHIB },
	{ "host-preced",	ICMP_UNREACH,	ICMP_UNREACH_HOST_PRECEDENCE },
	{ "cutoff-preced",	ICMP_UNREACH,	ICMP_UNREACH_PRECEDENCE_CUTOFF },
	{ "redir-net",		ICMP_REDIRECT,	ICMP_REDIRECT_NET },
	{ "redir-host",		ICMP_REDIRECT,	ICMP_REDIRECT_HOST },
	{ "redir-tos-net",	ICMP_REDIRECT,	ICMP_REDIRECT_TOSNET },
	{ "redir-tos-host",	ICMP_REDIRECT,	ICMP_REDIRECT_TOSHOST },
	{ "normal-adv",		ICMP_ROUTERADVERT, ICMP_ROUTERADVERT_NORMAL },
	{ "common-adv",		ICMP_ROUTERADVERT, ICMP_ROUTERADVERT_NOROUTE_COMMON },
	{ "transit",		ICMP_TIMXCEED,	ICMP_TIMXCEED_INTRANS },
	{ "reassemb",		ICMP_TIMXCEED,	ICMP_TIMXCEED_REASS },
	{ "badhead",		ICMP_PARAMPROB,	ICMP_PARAMPROB_ERRATPTR },
	{ "optmiss",		ICMP_PARAMPROB,	ICMP_PARAMPROB_OPTABSENT },
	{ "badlen",		ICMP_PARAMPROB,	ICMP_PARAMPROB_LENGTH },
	{ "unknown-ind",	ICMP_PHOTURIS,	ICMP_PHOTURIS_UNKNOWN_INDEX },
	{ "auth-fail",		ICMP_PHOTURIS,	ICMP_PHOTURIS_AUTH_FAILED },
	{ "decrypt-fail",	ICMP_PHOTURIS,	ICMP_PHOTURIS_DECRYPT_FAILED }
};

static const struct icmpcodeent icmp6_code[] = {
	{ "admin-unr", ICMP6_DST_UNREACH, ICMP6_DST_UNREACH_ADMIN },
	{ "noroute-unr", ICMP6_DST_UNREACH, ICMP6_DST_UNREACH_NOROUTE },
	{ "beyond-unr", ICMP6_DST_UNREACH, ICMP6_DST_UNREACH_BEYONDSCOPE },
	{ "addr-unr", ICMP6_DST_UNREACH, ICMP6_DST_UNREACH_ADDR },
	{ "port-unr", ICMP6_DST_UNREACH, ICMP6_DST_UNREACH_NOPORT },
	{ "transit", ICMP6_TIME_EXCEEDED, ICMP6_TIME_EXCEED_TRANSIT },
	{ "reassemb", ICMP6_TIME_EXCEEDED, ICMP6_TIME_EXCEED_REASSEMBLY },
	{ "badhead", ICMP6_PARAM_PROB, ICMP6_PARAMPROB_HEADER },
	{ "nxthdr", ICMP6_PARAM_PROB, ICMP6_PARAMPROB_NEXTHEADER },
	{ "redironlink", ND_REDIRECT, ND_REDIRECT_ONLINK },
	{ "redirrouter", ND_REDIRECT, ND_REDIRECT_ROUTER }
};

static int
geticmptypebyname(char *w, uint8_t aid)
{
	size_t	i;

	switch (aid) {
	case AID_INET:
		for (i = 0; i < nitems(icmp_type); i++) {
			if (!strcmp(w, icmp_type[i].name))
				return (icmp_type[i].type);
		}
		break;
	case AID_INET6:
		for (i = 0; i < nitems(icmp6_type); i++) {
			if (!strcmp(w, icmp6_type[i].name))
				return (icmp6_type[i].type);
		}
		break;
	}
	return -1;
}

static int
geticmpcodebyname(u_long type, char *w, uint8_t aid)
{
	size_t	i;

	switch (aid) {
	case AID_INET:
		for (i = 0; i < nitems(icmp_code); i++) {
			if (type == icmp_code[i].type &&
			    !strcmp(w, icmp_code[i].name))
				return (icmp_code[i].code);
		}
		break;
	case AID_INET6:
		for (i = 0; i < nitems(icmp6_code); i++) {
			if (type == icmp6_code[i].type &&
			    !strcmp(w, icmp6_code[i].name))
				return (icmp6_code[i].code);
		}
		break;
	}
	return -1;
}
